/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.ContainerConfig;
import com.oracle.bmc.devops.model.NetworkChannel;
import com.oracle.bmc.devops.model.ShapeConfig;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="containerConfigType")
@JsonFilter(value="explicitlySetFilter")
public final class ContainerInstanceConfig
extends ContainerConfig {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="shapeConfig")
    private final ShapeConfig shapeConfig;
    @JsonProperty(value="networkChannel")
    private final NetworkChannel networkChannel;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ContainerInstanceConfig(String compartmentId, String availabilityDomain, String shapeName, ShapeConfig shapeConfig, NetworkChannel networkChannel) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.shapeName = shapeName;
        this.shapeConfig = shapeConfig;
        this.networkChannel = networkChannel;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public ShapeConfig getShapeConfig() {
        return this.shapeConfig;
    }

    public NetworkChannel getNetworkChannel() {
        return this.networkChannel;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerInstanceConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", networkChannel=").append(String.valueOf((Object)this.networkChannel));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerInstanceConfig)) {
            return false;
        }
        ContainerInstanceConfig other = (ContainerInstanceConfig)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals((Object)this.networkChannel, (Object)other.networkChannel) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.networkChannel == null ? 43 : this.networkChannel.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="shapeConfig")
        private ShapeConfig shapeConfig;
        @JsonProperty(value="networkChannel")
        private NetworkChannel networkChannel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder shapeConfig(ShapeConfig shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder networkChannel(NetworkChannel networkChannel) {
            this.networkChannel = networkChannel;
            this.__explicitlySet__.add("networkChannel");
            return this;
        }

        public ContainerInstanceConfig build() {
            ContainerInstanceConfig model = new ContainerInstanceConfig(this.compartmentId, this.availabilityDomain, this.shapeName, this.shapeConfig, this.networkChannel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerInstanceConfig model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("networkChannel")) {
                this.networkChannel(model.getNetworkChannel());
            }
            return this;
        }
    }
}

