/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClassFactoryImpl;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.jgit.Utils;

public final class GitRevisionInfo {
    private final RevCommit revCommit;
    private final Repository repository;
    private final Map<String, GitBranch> branches;
    private GitFileInfo[] modifiedFiles;
    private String shortMessage;

    GitRevisionInfo(RevCommit commit, Repository repository) {
        this(commit, Collections.emptyMap(), repository);
    }

    GitRevisionInfo(RevCommit commit, Map<String, GitBranch> affectedBranches, Repository repository) {
        this.revCommit = commit;
        this.repository = repository;
        this.branches = Collections.unmodifiableMap(affectedBranches);
    }

    public String getRevision() {
        return ObjectId.toString((ObjectId)this.revCommit.getId());
    }

    public String getShortMessage() {
        if (this.shortMessage == null) {
            String msg = this.revCommit.getFullMessage();
            StringBuilder sb = new StringBuilder();
            boolean empty = true;
            for (int pos = 0; pos < msg.length(); ++pos) {
                char c = msg.charAt(pos);
                if (c == '\r' || c == '\n') {
                    if (empty) continue;
                    break;
                }
                sb.append(c);
                empty = false;
            }
            this.shortMessage = sb.toString();
        }
        return this.shortMessage;
    }

    public String getFullMessage() {
        return this.revCommit.getFullMessage();
    }

    public long getCommitTime() {
        PersonIdent author = this.revCommit.getAuthorIdent();
        if (author == null) {
            return (long)this.revCommit.getCommitTime() * 1000L;
        }
        return author.getWhenAsInstant().toEpochMilli();
    }

    public GitUser getAuthor() {
        return GitClassFactoryImpl.getInstance().createUser(this.revCommit.getAuthorIdent());
    }

    public GitUser getCommitter() {
        return GitClassFactoryImpl.getInstance().createUser(this.revCommit.getCommitterIdent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, GitFileInfo> getModifiedFiles() throws GitException {
        if (this.modifiedFiles == null) {
            GitRevisionInfo gitRevisionInfo = this;
            synchronized (gitRevisionInfo) {
                this.listFiles();
            }
        }
        HashMap<File, GitFileInfo> files = new HashMap<File, GitFileInfo>((int)Math.ceil((double)this.modifiedFiles.length / 0.75));
        for (GitFileInfo info : this.modifiedFiles) {
            files.put(info.getFile(), info);
        }
        return files;
    }

    public String[] getParents() {
        String[] parents = new String[this.revCommit.getParentCount()];
        for (int i = 0; i < this.revCommit.getParentCount(); ++i) {
            parents[i] = ObjectId.toString((ObjectId)this.revCommit.getParent(i).getId());
        }
        return parents;
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    private void listFiles() throws GitException {
        try (RevWalk revWalk = new RevWalk(this.repository);
             TreeWalk walk = new TreeWalk(this.repository);){
            List<Object> result;
            walk.reset();
            walk.setRecursive(true);
            RevCommit parentCommit = null;
            if (this.revCommit.getParentCount() > 0) {
                for (RevCommit commit : this.revCommit.getParents()) {
                    revWalk.markStart(revWalk.lookupCommit((AnyObjectId)commit));
                }
                revWalk.setRevFilter(RevFilter.MERGE_BASE);
                Iterator it = revWalk.iterator();
                if (it.hasNext()) {
                    parentCommit = (RevCommit)it.next();
                }
                if (parentCommit != null) {
                    walk.addTree((AnyObjectId)parentCommit.getTree().getId());
                }
            }
            walk.addTree((AnyObjectId)this.revCommit.getTree().getId());
            walk.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilter.ANY_DIFF));
            if (parentCommit != null) {
                result = Utils.getDiffEntries(this.repository, walk, GitClassFactoryImpl.getInstance());
            } else {
                result = new ArrayList();
                while (walk.next()) {
                    result.add(new GitFileInfo(new File(this.repository.getWorkTree(), walk.getPathString()), walk.getPathString(), GitFileInfo.Status.ADDED, null, null));
                }
            }
            this.modifiedFiles = (GitFileInfo[])result.toArray(GitFileInfo[]::new);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static final class GitFileInfo {
        private final String relativePath;
        private final String originalPath;
        private final Status status;
        private final File file;
        private final File originalFile;

        GitFileInfo(File file, String relativePath, Status status, File originalFile, String originalPath) {
            this.relativePath = relativePath;
            this.status = status;
            this.file = file;
            this.originalFile = originalFile;
            this.originalPath = originalPath;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public String getOriginalPath() {
            return this.originalPath;
        }

        public Status getStatus() {
            return this.status;
        }

        public File getFile() {
            return this.file;
        }

        public File getOriginalFile() {
            return this.originalFile;
        }

        public static enum Status {
            ADDED,
            MODIFIED,
            RENAMED,
            COPIED,
            REMOVED,
            UNKNOWN;

        }
    }
}

