/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;

public class InsertTabAction
extends BaseAction {
    private static final List<Action> CUSTOM_ACTIONS = List.of(new InsertTabAction());

    public InsertTabAction() {
        super("insert-tab");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        BaseKit.InsertTabAction insertTabAction = new BaseKit.InsertTabAction();
        insertTabAction.actionPerformed(evt, target);
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomic((Runnable)new TabReplacer(doc, caret.getDot()));
        }
    }

    private static int getSpacesPerTab(Document doc) {
        return CodeStylePreferences.get((Document)doc).getPreferences().getInt("spaces-per-tab", 2);
    }

    public static List<Action> createCustomActions() {
        return CUSTOM_ACTIONS;
    }

    private static class TabReplacer
    implements Runnable {
        private static final String TAB_CHARACTER = "\t";
        private static final Logger LOGGER = Logger.getLogger(TabReplacer.class.getName());
        private final BaseDocument baseDocument;
        private final int caretOffset;

        public TabReplacer(BaseDocument baseDocument, int caretOffset) {
            this.baseDocument = baseDocument;
            this.caretOffset = caretOffset;
        }

        @Override
        public void run() {
            try {
                this.tryReplaceTab();
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }

        private void tryReplaceTab() throws BadLocationException {
            int rowFirstNonWhite = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)this.baseDocument, (int)this.caretOffset);
            if (TabReplacer.shouldBeReplaced(rowFirstNonWhite, this.caretOffset)) {
                this.replaceTab();
            }
        }

        private void replaceTab() throws BadLocationException {
            int rowStart = LineDocumentUtils.getLineStartOffset((LineDocument)this.baseDocument, (int)this.caretOffset);
            assert (this.caretOffset >= rowStart) : "Caret: " + this.caretOffset + " rowStart: " + rowStart;
            String indentString = this.baseDocument.getText(rowStart, this.caretOffset - rowStart);
            if (indentString.contains(TAB_CHARACTER)) {
                String newIndentString = indentString.replace(TAB_CHARACTER, " ".repeat(InsertTabAction.getSpacesPerTab((Document)this.baseDocument)));
                this.baseDocument.replace(rowStart, this.caretOffset - rowStart, newIndentString, null);
            }
        }

        private static boolean shouldBeReplaced(int firstNonWhiteCharOffset, int caretOffset) {
            return firstNonWhiteCharOffset >= caretOffset || firstNonWhiteCharOffset == -1;
        }
    }
}

