/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.beans.ConstructorProperties;

public class ExponentialBackoffDelayStrategy
implements DelayStrategy {
    private final long maxDelayInMillis;

    @Override
    public long nextDelay(WaiterConfiguration.WaitContext context) {
        long delay = (long)Math.pow(2.0, context.getAttemptsMade());
        if ((delay *= 1000L) <= 0L) {
            return this.maxDelayInMillis;
        }
        return Math.min(delay, this.maxDelayInMillis);
    }

    @ConstructorProperties(value={"maxDelayInMillis"})
    public ExponentialBackoffDelayStrategy(long maxDelayInMillis) {
        this.maxDelayInMillis = maxDelayInMillis;
    }

    public String toString() {
        return "ExponentialBackoffDelayStrategy(maxDelayInMillis=" + this.maxDelayInMillis + ")";
    }
}

