/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.Window;
import java.beans.DesignMode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.BindingDesignSupport;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.CreationFactory;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADMenuComponent;
import org.netbeans.modules.form.RADMenuItemComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.ViewConverter;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutBuilder;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;

public class VisualReplicator {
    private RADComponent topMetaComponent;
    private Map<String, Object> idToClone = new HashMap<String, Object>();
    private Map<Object, String> cloneToId = new HashMap<Object, String>();
    private Map<Container, LayoutManager> defaultLayouts = new HashMap<Container, LayoutManager>();
    private Map<String, SwingLayoutBuilder> layoutBuilders = new HashMap<String, SwingLayoutBuilder>();
    private BindingDesignSupport bindingSupport;
    private BindingDesignSupport.BindingVisualReplicator bindingReplicator;
    private boolean designRestrictions;
    private ViewConverter[] converters;
    private static final String KEEP_ROOTPANE = "netbeans.form.no_custom_rootpane";

    public VisualReplicator(boolean designRestrictions, ViewConverter[] converters, BindingDesignSupport bindingSupport) {
        this.designRestrictions = designRestrictions;
        this.converters = converters;
        this.bindingSupport = bindingSupport;
    }

    public Object getClonedComponent(RADComponent metacomp) {
        return metacomp != null ? this.idToClone.get(metacomp.getId()) : null;
    }

    public Object getClonedComponent(String id) {
        return this.idToClone.get(id);
    }

    private Object getClonedComponent(RADComponent metacomp, boolean nonWindow) {
        Object w;
        Object clone = this.getClonedComponent(metacomp);
        if (!nonWindow && clone instanceof JRootPane && (w = ((JRootPane)clone).getClientProperty("netbeans.form-design-window")) instanceof RootPaneContainer) {
            clone = w;
        }
        return clone;
    }

    public String getClonedComponentId(Object component) {
        return this.cloneToId.get(component);
    }

    public Map<String, Object> getMapToClones() {
        return Collections.unmodifiableMap(this.idToClone);
    }

    private FormModel getFormModel() {
        return this.getTopMetaComponent().getFormModel();
    }

    SwingLayoutBuilder getLayoutBuilder(String containerId) {
        SwingLayoutBuilder builder = this.layoutBuilders.get(containerId);
        if (builder == null) {
            RADVisualContainer metacont = (RADVisualContainer)this.getFormModel().getMetaComponent(containerId);
            Container cont = (Container)this.getClonedComponent(containerId);
            Container contDelegate = metacont.getContainerDelegate(cont);
            builder = new SwingLayoutBuilder(this.getFormModel().getLayoutModel(), contDelegate, containerId);
            this.layoutBuilders.put(containerId, builder);
        }
        return builder;
    }

    private BindingDesignSupport.BindingVisualReplicator getBindingReplicator() {
        if (this.bindingReplicator == null) {
            this.bindingReplicator = this.bindingSupport.createReplicator();
        }
        return this.bindingReplicator;
    }

    public RADComponent getTopMetaComponent() {
        return this.topMetaComponent;
    }

    public void setTopMetaComponent(RADComponent metacomponent) {
        this.topMetaComponent = metacomponent;
        this.idToClone.clear();
        this.cloneToId.clear();
        this.defaultLayouts.clear();
        this.layoutBuilders.clear();
        this.bindingReplicator = null;
    }

    public boolean getDesignRestrictions() {
        return this.designRestrictions;
    }

    public Object createClone() {
        return this.createClone(this.getTopMetaComponent());
    }

    public Object createClone(RADComponent metacomp) {
        Object clone;
        if (metacomp == null) {
            return null;
        }
        ArrayList<RADProperty> relativeProperties = new ArrayList<RADProperty>();
        try {
            RADComponent rc;
            clone = this.cloneComponent(metacomp, relativeProperties);
            if (!relativeProperties.isEmpty()) {
                this.copyRelativeProperties(relativeProperties);
            }
            HashMap<String, Object> mapToClones = new HashMap<String, Object>(this.getMapToClones());
            FormModel formModel = this.getFormModel();
            Set entries = mapToClones.entrySet();
            for (Map.Entry entry : entries) {
                String id = (String)entry.getKey();
                Object comp = entry.getValue();
                rc = formModel.getMetaComponent(id);
                if (rc == null || comp != null && rc.getBeanClass().isAssignableFrom(comp.getClass())) continue;
                entry.setValue(rc.getBeanInstance());
            }
            boolean restrictions = this.getDesignRestrictions();
            for (Map.Entry entry : entries) {
                String id = (String)entry.getKey();
                rc = formModel.getMetaComponent(id);
                if (rc == null || rc.getKnownBindingProperties().length == 0) continue;
                if (restrictions) {
                    Container parent;
                    this.getBindingReplicator().establishUpdatedBindings(rc, false, mapToClones, false);
                    Object comp = entry.getValue();
                    if (!(comp instanceof Component) || (parent = ((Component)comp).getParent()) == null) continue;
                    ((Component)parent).invalidate();
                    continue;
                }
                this.getBindingReplicator().establishOneOffBindings(rc, false, mapToClones);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            clone = null;
        }
        if (this.getDesignRestrictions() && clone instanceof RootPaneContainer && clone instanceof Window) {
            JRootPane rootPane = ((RootPaneContainer)clone).getRootPane();
            rootPane.putClientProperty("netbeans.form-design-window", clone);
            this.cloneToId.remove(clone);
            clone = rootPane;
            this.idToClone.put(metacomp.getId(), clone);
            this.cloneToId.put(clone, metacomp.getId());
        }
        return clone;
    }

    public void reorderComponents(ComponentContainer metacont) {
        Object menu;
        if (metacont instanceof RADVisualContainer) {
            this.updateContainerLayout((RADVisualContainer)metacont);
        } else if (metacont instanceof RADMenuComponent && (menu = this.getClonedComponent((RADComponent)((Object)metacont))) instanceof Container) {
            Container cont = (Container)menu;
            cont.removeAll();
            for (RADComponent metacomp : ((RADMenuComponent)metacont).getSubBeans()) {
                VisualReplicator.addToMenu(cont, this.getClonedComponent(metacomp));
            }
        }
    }

    public void updateContainerLayout(RADVisualContainer metacont) {
        int i;
        Container cont = (Container)this.getClonedComponent(metacont);
        if (cont == null) {
            return;
        }
        Container contDelegate = metacont.getContainerDelegate(cont);
        LayoutSupportManager laysup = metacont.getLayoutSupport();
        if (laysup != null) {
            layoutBuilder = null;
            this.layoutBuilders.remove(metacont.getId());
            laysup.clearContainer(cont, contDelegate);
        } else {
            layoutBuilder = this.getLayoutBuilder(metacont.getId());
            layoutBuilder.clearContainer();
        }
        RADVisualComponent[] metacomps = metacont.getSubComponents();
        Component[] comps = new Component[metacomps.length];
        String[] compIds = new String[metacomps.length];
        for (i = 0; i < metacomps.length; ++i) {
            Component defaultComp;
            RADVisualComponent metacomp = metacomps[i];
            if (metacont.getContainerMenu() == metacomp) continue;
            Component comp = (Component)this.getClonedComponent(metacomp);
            if (comp == null) {
                comp = (Component)this.createClone(metacomp);
            } else if (comp.getParent() != null) {
                comp.getParent().remove(comp);
            }
            Boolean visible = null;
            RADProperty visibilityProp = metacomp.getPropertyByName("visible", RADProperty.class, false);
            if (visibilityProp != null && visibilityProp.isChanged()) {
                Object value;
                try {
                    value = visibilityProp.getRealValue();
                }
                catch (Exception ex) {
                    value = null;
                }
                if (value instanceof Boolean) {
                    visible = (Boolean)value;
                }
            }
            if (visible == null && (defaultComp = (Component)BeanSupport.getDefaultInstance(comp.getClass())) != null) {
                Boolean bl = visible = defaultComp.isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (visible != null) {
                comp.setVisible(visible);
            }
            FakePeerSupport.attachFakePeer(comp);
            if (comp instanceof Container) {
                FakePeerSupport.attachFakePeerRecursively((Container)comp);
            }
            comps[i] = comp;
            compIds[i] = metacomp.getId();
        }
        if (laysup != null) {
            this.handleDefaultLayout(metacont, contDelegate);
            laysup.setLayoutToContainer(cont, contDelegate);
            if (comps.length > 0) {
                VisualReplicator.updateLayeredPane(cont, metacomps, comps);
                laysup.addComponentsToContainer(cont, contDelegate, comps, 0);
            }
            laysup.arrangeContainer(cont, contDelegate);
        } else {
            contDelegate.removeAll();
            for (i = 0; i < comps.length; ++i) {
                FakePeerSupport.attachFakePeer(comps[i]);
                if (!(comps[i] instanceof Container)) continue;
                FakePeerSupport.attachFakePeerRecursively((Container)comps[i]);
            }
            VisualReplicator.updateLayeredPane(cont, metacomps, comps);
            this.setupContainerLayout(metacont, comps, compIds);
        }
    }

    private static void updateLayeredPane(Container cont, RADVisualComponent[] metacomps, Component[] comps) {
        if (cont instanceof JLayeredPane) {
            JLayeredPane layeredPane = (JLayeredPane)cont;
            for (int i = 0; i < metacomps.length; ++i) {
                RADVisualComponent sub = metacomps[i];
                int layer = sub.getComponentLayer();
                layeredPane.setLayer(comps[i], layer);
            }
        }
    }

    public void updateAddedComponents(ComponentContainer metacont) {
        Container container = null;
        if (metacont instanceof RADComponent) {
            Object contClone = this.getClonedComponent((RADComponent)((Object)metacont));
            if (contClone instanceof Container) {
                if (metacont instanceof RADVisualContainer) {
                    RADVisualContainer visualMetaCont = (RADVisualContainer)metacont;
                    if (visualMetaCont.getLayoutSupport() == null) {
                        this.updateContainerLayout(visualMetaCont);
                    }
                    container = visualMetaCont.getContainerDelegate((Container)contClone);
                } else {
                    container = (Container)contClone;
                }
            } else {
                return;
            }
        }
        RADComponent[] subComps = metacont.getSubBeans();
        for (int i = 0; i < subComps.length; ++i) {
            Container cloneCont;
            Object compClone = this.getClonedComponent(subComps[i]);
            if (compClone == null) {
                this.addComponent(subComps[i]);
                continue;
            }
            if (!(compClone instanceof Component) || (cloneCont = ((Component)compClone).getParent()) == container || this.cloneToId.get(cloneCont) == null) continue;
            return;
        }
    }

    public void addComponent(RADComponent metacomp) {
        if (metacomp == null) {
            return;
        }
        if (this.getClonedComponent(metacomp) != null) {
            return;
        }
        if (metacomp instanceof RADVisualComponent) {
            Object clone = this.createClone(metacomp);
            if (!(clone instanceof Component)) {
                return;
            }
            RADVisualContainer metacont = (RADVisualContainer)metacomp.getParentComponent();
            Container cont = (Container)this.getClonedComponent(metacont);
            if (metacomp == metacont.getContainerMenu()) {
                VisualReplicator.setContainerMenu(cont, clone);
            } else if (metacont.isMenuTypeComponent()) {
                VisualReplicator.addToMenu(cont, clone);
            } else {
                LayoutSupportManager laysup = metacont.getLayoutSupport();
                if (laysup != null) {
                    if (cont == null) {
                        return;
                    }
                    Container contDelegate = metacont.getContainerDelegate(cont);
                    laysup.addComponentsToContainer(cont, contDelegate, new Component[]{(Component)clone}, ((RADVisualComponent)metacomp).getComponentIndex());
                    laysup.arrangeContainer(cont, contDelegate);
                    if (contDelegate instanceof JLayeredPane) {
                        int layer = ((RADVisualComponent)metacomp).getComponentLayer();
                        ((JLayeredPane)contDelegate).setLayer((Component)clone, layer);
                    }
                }
            }
        } else if (metacomp instanceof RADMenuItemComponent) {
            Object clone = this.createClone(metacomp);
            RADComponent menuCont = metacomp.getParentComponent();
            if (menuCont == null) {
                return;
            }
            Object cont = this.getClonedComponent(menuCont);
            if (menuCont instanceof RADVisualContainer) {
                VisualReplicator.setContainerMenu((Container)cont, clone);
            } else {
                VisualReplicator.addToMenu(cont, clone);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeComponent(RADComponent metacomp, ComponentContainer metacont) {
        if (metacomp == null) {
            return;
        }
        Object clone = this.getClonedComponent(metacomp);
        if (clone == null) {
            return;
        }
        if (clone instanceof JMenuBar) {
            Container menuParent;
            Container cont;
            for (cont = menuParent = ((Component)clone).getParent(); cont != null && !(cont instanceof JRootPane); cont = cont.getParent()) {
            }
            if (cont != null) {
                ((JRootPane)cont).setJMenuBar(null);
            } else {
                if (menuParent == null) return;
                menuParent.remove((Component)clone);
            }
        } else if (clone instanceof Component) {
            Container cont;
            Component comp = (Component)clone;
            RADVisualContainer parentCont = metacont instanceof RADVisualContainer ? (RADVisualContainer)metacont : null;
            Container container = cont = parentCont != null ? (Container)this.getClonedComponent(parentCont) : null;
            if (cont == null) {
                if (comp.getParent() != null) {
                    comp.getParent().remove(comp);
                }
            } else {
                Container contDelegate = parentCont.getContainerDelegate(cont);
                LayoutSupportManager laysup = parentCont.getLayoutSupport();
                if (laysup != null) {
                    if (!laysup.removeComponentFromContainer(cont, contDelegate, comp)) {
                        laysup.clearContainer(cont, contDelegate);
                        RADVisualComponent[] metacomps = parentCont.getSubComponents();
                        if (metacomps.length > 0) {
                            Component[] comps = new Component[metacomps.length];
                            for (int i = 0; i < metacomps.length; ++i) {
                                comp = (Component)this.getClonedComponent(metacomps[i]);
                                FakePeerSupport.attachFakePeer(comp);
                                if (comp instanceof Container) {
                                    FakePeerSupport.attachFakePeerRecursively((Container)comp);
                                }
                                comps[i] = comp;
                            }
                            laysup.addComponentsToContainer(cont, contDelegate, comps, 0);
                        }
                    }
                } else {
                    contDelegate.removeAll();
                    RADVisualComponent[] metacomps = parentCont.getSubComponents();
                    for (int i = 0; i < metacomps.length; ++i) {
                        Component component = (Component)this.getClonedComponent(metacomps[i]);
                        FakePeerSupport.attachFakePeer(component);
                        if (!(component instanceof Container)) continue;
                        FakePeerSupport.attachFakePeerRecursively((Container)component);
                    }
                    this.getLayoutBuilder(parentCont.getId()).removeComponentsFromContainer(new Component[]{comp}, new String[]{metacomp.getId()});
                }
            }
            if (comp.getParent() != null) {
                comp.getParent().remove(comp);
            }
        } else if (clone instanceof MenuComponent) {
            MenuComponent menuComp = (MenuComponent)clone;
            MenuContainer menuCont = menuComp.getParent();
            if (menuCont == null) return;
            menuCont.remove(menuComp);
        }
        this.removeMapping(metacomp);
    }

    public void updateComponentProperty(RADProperty property) {
        if (property == null) {
            return;
        }
        RADComponent metacomp = property.getRADComponent();
        Object targetComp = this.getClonedComponent(metacomp, false);
        if (targetComp == null) {
            return;
        }
        if (targetComp instanceof Scrollbar) {
            this.removeComponent(metacomp, null);
            this.addComponent(metacomp);
            return;
        }
        if (targetComp instanceof JComponent && this.getDesignRestrictions() && ("doubleBuffered".equals(property.getName()) && VisualReplicator.hasAwtParent(metacomp) || "debugGraphicsOptions".equals(property.getName()))) {
            return;
        }
        if ("text".equals(property.getName()) && (targetComp instanceof AbstractButton || targetComp instanceof JLabel) && JavaCodeGenerator.isUsingMnemonics(property.getRADComponent())) {
            try {
                String str = (String)property.getRealValue();
                if (targetComp instanceof JLabel) {
                    Mnemonics.setLocalizedText((JLabel)((JLabel)targetComp), (String)str);
                } else {
                    Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)targetComp), (String)str);
                }
                return;
            }
            catch (Exception str) {
                // empty catch block
            }
        }
        boolean buttonGroup = "buttonGroup".equals(property.getName()) && targetComp instanceof AbstractButton;
        Method writeMethod = FormUtils.getPropertyWriteMethod(property, targetComp.getClass());
        if (writeMethod == null && !buttonGroup) {
            return;
        }
        try {
            Object clonedValue;
            Object value = property.getValue();
            RADComponent valueComp = value instanceof RADComponent.ComponentReference ? ((RADComponent.ComponentReference)value).getComponent() : (FormUtils.isRelativeConnectionValue(value) ? ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getRADComponent() : null);
            if (valueComp != null) {
                Object clonedComp = this.getClonedComponent(valueComp);
                if (clonedComp == null) {
                    clonedComp = this.createClone(valueComp);
                }
                clonedValue = value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue ? ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getValueForBean(clonedComp) : clonedComp;
            } else {
                clonedValue = null;
                if (value instanceof FormDesignValue) {
                    clonedValue = ((FormDesignValue)value).getDesignValue(targetComp);
                }
                if (clonedValue == null) {
                    Object defaultFont;
                    Object realValue = property.getRealValue();
                    if (realValue == FormDesignValue.IGNORED_VALUE) {
                        return;
                    }
                    if (realValue instanceof Font && !(realValue instanceof FontUIResource) && (defaultFont = property.getDefaultValue()) instanceof FontUIResource && realValue.equals(defaultFont)) {
                        realValue = defaultFont;
                    }
                    try {
                        clonedValue = FormUtils.cloneObject(realValue, property.getPropertyContext().getFormModel());
                    }
                    catch (CloneNotSupportedException ex) {
                        clonedValue = realValue;
                    }
                }
            }
            if (buttonGroup) {
                DefaultButtonModel buttonModel;
                ButtonGroup group;
                AbstractButton button = (AbstractButton)targetComp;
                ButtonModel model = button.getModel();
                if (model instanceof DefaultButtonModel && (group = (buttonModel = (DefaultButtonModel)model).getGroup()) != null) {
                    group.remove(button);
                }
                if (clonedValue instanceof ButtonGroup) {
                    ((ButtonGroup)clonedValue).add(button);
                }
            } else {
                writeMethod.invoke(targetComp, clonedValue);
            }
            if (targetComp instanceof Component) {
                ((Component)targetComp).invalidate();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(VisualReplicator.class.getName()).log(Level.INFO, null, ex);
        }
    }

    public void updateBinding(MetaBinding newBinding) {
        if (newBinding != null && this.bindingSupport != null) {
            Object target;
            RADComponent metaTarget = newBinding.getTarget();
            Object object = target = this.isConverted(metaTarget) ? metaTarget.getBeanInstance() : this.getClonedComponent(metaTarget);
            if (target != null) {
                Object source;
                RADComponent metaSource = newBinding.getSource();
                Object object2 = source = this.isConverted(metaSource) ? metaSource.getBeanInstance() : this.getClonedComponent(metaSource);
                if (source == null) {
                    source = newBinding.getSource().getBeanInstance();
                }
                this.getBindingReplicator().addBinding(newBinding, source, target, false);
            }
        }
    }

    private Object cloneComponent(RADComponent metacomp, List<RADProperty> relativeProperties) throws Exception {
        RADProperty prop;
        Object clone = null;
        Object compClone = null;
        for (ViewConverter converter : this.converters) {
            ViewConverter.Convert convert = converter.convert(metacomp.getBeanInstance(), metacomp == this.getTopMetaComponent(), this.getDesignRestrictions());
            if (convert == null) continue;
            clone = convert.getConverted();
            compClone = convert.getEnclosed();
            List<RADProperty> relProps = relativeProperties;
            Object target = compClone != null ? compClone : clone;
            do {
                Iterator<RADProperty> applyProperties = target instanceof Window ? metacomp.getBeanPropertiesIterator(new FormProperty.Filter(){

                    @Override
                    public boolean accept(FormProperty property) {
                        return !"visible".equals(property.getName());
                    }
                }, false) : Arrays.asList(metacomp.getKnownBeanProperties()).iterator();
                FormUtils.copyPropertiesToBean(applyProperties, target, relProps);
                if (target != clone && target instanceof RootPaneContainer) {
                    target = clone;
                    relProps = null;
                    continue;
                }
                target = null;
            } while (target != null);
            break;
        }
        if (clone == null) {
            clone = metacomp.cloneBeanInstance(relativeProperties);
        }
        if (clone == null) {
            return null;
        }
        if (compClone == null) {
            compClone = clone;
        }
        this.idToClone.put(metacomp.getId(), compClone);
        this.cloneToId.put(compClone, metacomp.getId());
        if (compClone instanceof DesignMode) {
            ((DesignMode)compClone).setDesignTime(this.getDesignRestrictions());
        }
        if (metacomp instanceof RADVisualContainer) {
            RADVisualContainer metacont = (RADVisualContainer)metacomp;
            Container cont = (Container)compClone;
            Container contDelegate = metacont.getContainerDelegate(cont);
            if (metacont.getContainerMenu() != null) {
                Object menu = this.cloneComponent(metacont.getContainerMenu(), relativeProperties);
                VisualReplicator.setContainerMenu(cont, menu);
            }
            RADVisualComponent[] metacomps = metacont.getSubComponents();
            Component[] comps = new Component[metacomps.length];
            String[] compIds = new String[metacomps.length];
            for (int i = 0; i < metacomps.length; ++i) {
                RADVisualComponent sub = metacomps[i];
                Component subClone = (Component)this.getClonedComponent(sub);
                if (subClone == null) {
                    subClone = (Component)this.cloneComponent(sub, relativeProperties);
                }
                comps[i] = subClone;
                compIds[i] = sub.getId();
            }
            if (metacont.isMenuTypeComponent()) {
                for (Component comp : comps) {
                    VisualReplicator.addToMenu(cont, comp);
                }
            } else {
                LayoutSupportManager laysup = metacont.getLayoutSupport();
                if (laysup != null) {
                    this.handleDefaultLayout(metacont, contDelegate);
                    laysup.setLayoutToContainer(cont, contDelegate);
                    if (comps.length > 0) {
                        VisualReplicator.updateLayeredPane(cont, metacomps, comps);
                        laysup.addComponentsToContainer(cont, contDelegate, comps, 0);
                    }
                    laysup.arrangeContainer(cont, contDelegate);
                } else {
                    VisualReplicator.updateLayeredPane(cont, metacomps, comps);
                    this.setupContainerLayout(metacont, comps, compIds);
                }
            }
        } else if (metacomp instanceof RADMenuComponent) {
            RADComponent[] metacomps = ((RADMenuComponent)metacomp).getSubBeans();
            for (int i = 0; i < metacomps.length; ++i) {
                RADComponent sub = metacomps[i];
                Object menuItem = this.getClonedComponent(sub);
                if (menuItem == null) {
                    menuItem = this.cloneComponent((RADMenuItemComponent)sub, relativeProperties);
                }
                VisualReplicator.addToMenu(compClone, menuItem);
            }
        }
        if (clone instanceof Component && this.getDesignRestrictions()) {
            Component comp = (Component)clone;
            FakePeerSupport.attachFakePeer(comp);
            if (clone instanceof Container) {
                FakePeerSupport.attachFakePeerRecursively((Container)clone);
            }
            if (clone instanceof JComponent) {
                if (VisualReplicator.hasAwtParent(metacomp)) {
                    VisualReplicator.setDoubleBufferedRecursively((JComponent)clone, false);
                }
                ((JComponent)clone).setDebugGraphicsOptions(-1);
            }
            VisualReplicator.disableFocusing((Component)clone);
            if (clone instanceof JInternalFrame) {
                ((JInternalFrame)clone).getGlassPane().setVisible(false);
            } else if (clone instanceof JEditorPane && ((JEditorPane)clone).getDocument() instanceof PlainDocument) {
                comp.setPreferredSize(BeanSupport.getDefaultPreferredSize(JEditorPane.class));
            }
        }
        if ((clone instanceof AbstractButton || clone instanceof JLabel) && JavaCodeGenerator.isUsingMnemonics(metacomp) && (prop = metacomp.getBeanProperty("text")) != null && prop.isChanged()) {
            try {
                String str = (String)prop.getRealValue();
                if (clone instanceof JLabel) {
                    Mnemonics.setLocalizedText((JLabel)((JLabel)clone), (String)str);
                } else {
                    Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)clone), (String)str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clone;
    }

    private boolean isConverted(RADComponent metacomp) {
        Object comp = this.getClonedComponent(metacomp);
        return comp != null && !metacomp.getBeanClass().isAssignableFrom(comp.getClass());
    }

    private void setupContainerLayout(RADVisualContainer metacont, Component[] comps, String[] compIds) {
        SwingLayoutBuilder layoutBuilder = this.getLayoutBuilder(metacont.getId());
        Throwable th = null;
        try {
            layoutBuilder.setupContainerLayout(comps, compIds);
            Component comp = (Component)this.getClonedComponent(metacont);
            ((Component)metacont.getBeanInstance()).setPreferredSize(comp.getPreferredSize());
        }
        catch (Exception ex) {
            th = ex;
        }
        catch (Error err) {
            th = err;
        }
        if (th != null) {
            ErrorManager.getDefault().notify(th);
            this.getFormModel().forceUndoOfCompoundEdit();
        }
    }

    private void handleDefaultLayout(RADVisualContainer metacont, Container cont) {
        if (!metacont.hasDedicatedLayoutSupport() && !this.defaultLayouts.containsKey(cont)) {
            this.defaultLayouts.put(cont, cont.getLayout());
        }
        if (metacont.hasDefaultLayout() && this.defaultLayouts.containsKey(cont)) {
            LayoutManager defaultLayout = this.defaultLayouts.get(cont);
            if (cont.getLayout() != defaultLayout) {
                cont.setLayout(defaultLayout);
            }
        }
    }

    private static void disableFocusing(Component comp) {
        comp.setFocusable(false);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int n = cont.getComponentCount();
            for (int i = 0; i < n; ++i) {
                VisualReplicator.disableFocusing(cont.getComponent(i));
            }
        }
    }

    private static void setContainerMenu(Container cont, Object menu) {
        if (cont instanceof RootPaneContainer) {
            if (menu instanceof JMenuBar) {
                ((RootPaneContainer)((Object)cont)).getRootPane().setJMenuBar((JMenuBar)menu);
            }
        } else if (cont instanceof JRootPane) {
            if (menu instanceof JMenuBar) {
                ((JRootPane)cont).setJMenuBar((JMenuBar)menu);
            }
        } else if (cont instanceof Frame && menu instanceof MenuBar) {
            ((Frame)cont).setMenuBar((MenuBar)menu);
        }
    }

    private static void addToMenu(Object menu, Object menuItem) {
        if (menu instanceof JMenuBar) {
            ((JMenuBar)menu).add((JMenu)menuItem);
        } else if (menu instanceof JMenu) {
            if (menuItem instanceof JMenuItem) {
                ((JMenu)menu).add((JMenuItem)menuItem);
            } else {
                ((JMenu)menu).addSeparator();
            }
        } else if (menu instanceof MenuBar) {
            ((MenuBar)menu).add((Menu)menuItem);
        } else if (menu instanceof Menu) {
            if (menuItem instanceof MenuItem) {
                ((Menu)menu).add((MenuItem)menuItem);
            } else {
                ((Menu)menu).addSeparator();
            }
        }
    }

    private static Class convertMenuClassToSwing(Class menuClass) {
        if (MenuBar.class.isAssignableFrom(menuClass)) {
            return JMenuBar.class;
        }
        if (PopupMenu.class.isAssignableFrom(menuClass)) {
            return JPopupMenu.class;
        }
        if (Menu.class.isAssignableFrom(menuClass)) {
            return JMenu.class;
        }
        if (CheckboxMenuItem.class.isAssignableFrom(menuClass)) {
            return JCheckBoxMenuItem.class;
        }
        if (MenuItem.class.isAssignableFrom(menuClass)) {
            return JMenuItem.class;
        }
        return menuClass;
    }

    private static boolean hasAwtParent(RADComponent metacomp) {
        for (RADComponent parent = metacomp.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            Class<? extends Object> beanClass = parent.getBeanClass();
            if (!Component.class.isAssignableFrom(beanClass) || JComponent.class.isAssignableFrom(beanClass) || RootPaneContainer.class.isAssignableFrom(beanClass)) continue;
            return true;
        }
        return false;
    }

    private static void setDoubleBufferedRecursively(JComponent component, boolean value) {
        component.setDoubleBuffered(value);
        Component[] subcomps = component.getComponents();
        for (int i = 0; i < subcomps.length; ++i) {
            if (!(subcomps[i] instanceof JComponent)) continue;
            VisualReplicator.setDoubleBufferedRecursively((JComponent)subcomps[i], value);
        }
    }

    private void copyRelativeProperties(List<RADProperty> relativeProperties) {
        for (int i = 0; i < relativeProperties.size(); ++i) {
            RADProperty property = relativeProperties.get(i);
            try {
                Object value = property.getValue();
                RADComponent valueComp = value instanceof RADComponent.ComponentReference ? ((RADComponent.ComponentReference)value).getComponent() : (FormUtils.isRelativeConnectionValue(value) ? ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getRADComponent() : null);
                if (valueComp == null) continue;
                Object clonedComp = this.getClonedComponent(valueComp);
                if (clonedComp == null) {
                    clonedComp = this.cloneComponent(valueComp, relativeProperties);
                }
                Object clonedValue = value instanceof RADConnectionPropertyEditor.RADConnectionDesignValue ? ((RADConnectionPropertyEditor.RADConnectionDesignValue)value).getValueForBean(clonedComp) : clonedComp;
                Object targetComp = this.getClonedComponent(property.getRADComponent());
                Method writeMethod = FormUtils.getPropertyWriteMethod(property, targetComp.getClass());
                if (writeMethod != null) {
                    writeMethod.invoke(targetComp, clonedValue);
                    continue;
                }
                if (!(clonedValue instanceof ButtonGroup) || !(targetComp instanceof AbstractButton)) continue;
                ((ButtonGroup)clonedValue).remove((AbstractButton)targetComp);
                ((ButtonGroup)clonedValue).add((AbstractButton)targetComp);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void removeMapping(RADComponent metacomp) {
        Object comp = this.idToClone.remove(metacomp.getId());
        if (comp != null) {
            this.cloneToId.remove(comp);
            if (comp instanceof Container) {
                this.defaultLayouts.remove((Container)comp);
            }
        }
        if (metacomp instanceof ComponentContainer) {
            this.layoutBuilders.remove(metacomp.getId());
            RADComponent[] subcomps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
            for (int i = 0; i < subcomps.length; ++i) {
                this.removeMapping(subcomps[i]);
            }
        }
    }

    private static boolean canUseRootPaneFromWindow(RootPaneContainer window) {
        if (Boolean.getBoolean(KEEP_ROOTPANE)) {
            return false;
        }
        JRootPane rootPane = window.getRootPane();
        return rootPane == null || !Boolean.TRUE.equals(rootPane.getClientProperty(KEEP_ROOTPANE));
    }

    private static void transferRootPane(JFrame frame, JRootPane otherRootPane) {
        try {
            Method m = JFrame.class.getDeclaredMethod("setRootPane", JRootPane.class);
            m.setAccessible(true);
            m.invoke((Object)frame, otherRootPane);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ConvertResult
    implements ViewConverter.Convert {
        private Object converted;
        private Object enclosed;

        ConvertResult(Object converted, Object enclosed) {
            this.converted = converted;
            this.enclosed = enclosed;
        }

        @Override
        public Object getConverted() {
            return this.converted;
        }

        @Override
        public Object getEnclosed() {
            return this.enclosed;
        }
    }

    public static class DefaultConverter
    implements ViewConverter {
        @Override
        public ViewConverter.Convert convert(Object component, boolean root, boolean designRestrictions) {
            Class<?> compClass = component.getClass();
            boolean basicSwing = compClass.getName().startsWith("javax.swing.");
            Class convClass = null;
            if (designRestrictions) {
                if (RootPaneContainer.class.isAssignableFrom(compClass) && Window.class.isAssignableFrom(compClass)) {
                    if (basicSwing || !VisualReplicator.canUseRootPaneFromWindow((RootPaneContainer)component)) {
                        convClass = JRootPane.class;
                    }
                } else if (Frame.class.isAssignableFrom(compClass)) {
                    convClass = JRootPane.class;
                } else if (Window.class.isAssignableFrom(compClass) || compClass.getName().equals("javax.swing.JApplet") || compClass.getName().equals("java.applet.Applet")) {
                    convClass = Panel.class;
                } else if (MenuComponent.class.isAssignableFrom(compClass)) {
                    convClass = VisualReplicator.convertMenuClassToSwing(compClass);
                }
            } else if (root) {
                if (RootPaneContainer.class.isAssignableFrom(compClass) || JComponent.class.isAssignableFrom(compClass)) {
                    if (!JFrame.class.isAssignableFrom(compClass) || ((JFrame)component).isDisplayable()) {
                        convClass = JFrame.class;
                    }
                } else if (Component.class.isAssignableFrom(compClass) && (!Frame.class.isAssignableFrom(compClass) || ((Frame)component).isDisplayable())) {
                    convClass = Frame.class;
                }
            }
            if (convClass == null) {
                return null;
            }
            try {
                Component converted = (Component)CreationFactory.createDefaultInstance(convClass);
                Component enclosed = null;
                if (converted instanceof JFrame) {
                    if (RootPaneContainer.class.isAssignableFrom(compClass)) {
                        if (!basicSwing) {
                            enclosed = (Component)CreationFactory.createDefaultInstance(compClass);
                            VisualReplicator.transferRootPane((JFrame)converted, ((RootPaneContainer)((Object)enclosed)).getRootPane());
                        }
                    } else if (JComponent.class.isAssignableFrom(compClass)) {
                        enclosed = (Component)CreationFactory.createDefaultInstance(compClass);
                        ((JFrame)converted).getContentPane().add(enclosed);
                    }
                } else if (converted instanceof JRootPane) {
                    Container contentCont = (Container)CreationFactory.createDefaultInstance(RootPaneContainer.class.isAssignableFrom(compClass) ? JPanel.class : Panel.class);
                    ((JRootPane)converted).setContentPane(contentCont);
                } else if (MenuItem.class.isAssignableFrom(compClass)) {
                    ((JMenuItem)converted).setText(((MenuItem)component).getLabel());
                    ((JMenuItem)converted).setFont(((MenuItem)component).getFont());
                }
                return new ConvertResult(converted, enclosed);
            }
            catch (Exception ex) {
                Logger.getLogger(VisualReplicator.class.getName()).log(Level.INFO, null, ex);
                return null;
            }
        }

        @Override
        public boolean canVisualize(Class componentClass) {
            return false;
        }
    }
}

