/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;

@NodeInfo
public final class OptimizedIndirectCallNode
extends IndirectCallNode {
    @CompilerDirectives.CompilationFinal
    private Class<? extends Throwable> exceptionProfile;

    OptimizedIndirectCallNode() {
    }

    public Object call(CallTarget target, Object ... arguments) {
        try {
            OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
            return optimizedTarget.callIndirect((Node)this, arguments);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    private RuntimeException handleException(Throwable t) {
        Throwable profiledT = this.profileExceptionType(t);
        OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo((Node)this, null, profiledT, null);
        throw OptimizedCallTarget.rethrow(profiledT);
    }

    private <T extends Throwable> T profileExceptionType(T value) {
        Class<? extends Throwable> clazz = this.exceptionProfile;
        if (clazz != Throwable.class) {
            if (clazz != null && value.getClass() == clazz) {
                if (CompilerDirectives.inInterpreter()) {
                    return value;
                }
                return (T)((Throwable)CompilerDirectives.castExact(value, clazz));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptionProfile = clazz == null ? value.getClass() : Throwable.class;
        }
        return value;
    }
}

