/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.nodejs.editor;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.nodejs.editor.Bundle;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsDataProvider;
import org.netbeans.modules.javascript2.nodejs.editor.NodeJsUtils;
import org.openide.filesystems.FileObject;

public class NodeJsElement
implements ElementHandle {
    private final String name;
    private final ElementKind kind;
    private final String documentation;
    private final String template;
    private final FileObject fo;

    public NodeJsElement(FileObject fo, String name, String documentation, ElementKind kind) {
        this(fo, name, documentation, null, kind);
    }

    public NodeJsElement(FileObject fo, String name, String documentation, String template, ElementKind kind) {
        this.name = name;
        this.kind = kind;
        this.documentation = documentation;
        this.template = template;
        this.fo = fo;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public String getMimeType() {
        return "";
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return "";
    }

    public ElementKind getKind() {
        return this.kind;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle handle) {
        return false;
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return OffsetRange.NONE;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getTemplate() {
        return this.template;
    }

    public static class NodeJsLocalModuleElement
    extends NodeJsElement {
        public NodeJsLocalModuleElement(FileObject fo, String name) {
            super(fo, name, null, ElementKind.MODULE);
        }

        @Override
        public String getDocumentation() {
            StringBuilder sb = new StringBuilder();
            if (this.getFileObject() != null) {
                sb.append(NodeJsDataProvider.getDefault(this.getFileObject()).getDocForLocalModule(this.getFileObject()));
                sb.append("<br/><br/>");
            }
            sb.append(Bundle.NodeJsLocalModuleElement_lbl_location(NodeJsUtils.writeFilePathForDocWindow(this.getFileObject())));
            return sb.toString();
        }
    }

    public static class NodeJsModuleElement
    extends NodeJsElement {
        public NodeJsModuleElement(FileObject fo, String name) {
            super(fo, name, null, ElementKind.MODULE);
        }

        @Override
        public String getDocumentation() {
            FileObject fo = this.getFileObject();
            return fo == null ? null : NodeJsDataProvider.getDefault(fo).getDocForModule(this.getName());
        }
    }

    public static class NodeJsFileElement
    extends NodeJsElement {
        public NodeJsFileElement(FileObject file) {
            super(file, file.getNameExt(), null, ElementKind.FILE);
        }

        @Override
        public String getDocumentation() {
            return super.getDocumentation();
        }

        @Override
        public FileObject getFileObject() {
            return super.getFileObject();
        }

        @Override
        public String getMimeType() {
            return this.getFileObject().getMIMEType();
        }

        @Override
        public String getName() {
            FileObject fo = this.getFileObject();
            return fo.isFolder() ? fo.getNameExt() : fo.getName();
        }

        @Override
        public boolean signatureEquals(ElementHandle handle) {
            return this.getFileObject().equals(handle.getFileObject());
        }
    }
}

