/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class OutlineComboBox
extends JComboBox {
    private JList popupList;
    private boolean keepPopupVisible = false;
    private Set<Object> expandedItems = new HashSet<Object>();
    private boolean areExpandables;
    private static int expansionHandleWidth;

    public OutlineComboBox() {
        this.setRenderer(new OutlineComboBoxRenderer());
    }

    public void setItems(Object[] items) {
        this.expandedItems.clear();
        this.areExpandables = false;
        for (Object o : items) {
            if (!(o instanceof Expandable)) continue;
            this.areExpandables = true;
            break;
        }
        this.setModel(new OutlineComboBoxModel(items));
    }

    private void setKeepPopupVisible(boolean keepPopupVisible) {
        this.keepPopupVisible = keepPopupVisible;
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (v || !this.keepPopupVisible) {
            super.setPopupVisible(v);
        }
    }

    private static Icon getExpandedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    private static Icon getCollapsedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    private static int getExpansionHandleWidth() {
        if (expansionHandleWidth == 0) {
            expansionHandleWidth = OutlineComboBox.getExpandedIcon().getIconWidth();
        }
        return expansionHandleWidth;
    }

    private class OutlineComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private ShiftBorder sborder;

        public OutlineComboBoxRenderer() {
            this.setOpaque(true);
            this.sborder = new ShiftBorder(this.getBorder());
            this.setBorder(this.sborder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int shift;
            OutlineComboBox.this.popupList = list;
            if (value instanceof Expandable) {
                Expandable exp = (Expandable)value;
                if (exp.isExpanded()) {
                    this.setIcon(OutlineComboBox.getExpandedIcon());
                } else {
                    this.setIcon(OutlineComboBox.getCollapsedIcon());
                }
            } else {
                this.setIcon(null);
            }
            String text = value instanceof PopupMenuItem ? ((PopupMenuItem)value).toPopupMenuString() : value.toString();
            this.setText(text);
            int itgap = this.getIconTextGap();
            int n = shift = OutlineComboBox.this.areExpandables ? 1 : 0;
            if (OutlineComboBox.this.expandedItems.contains(value)) {
                ++shift;
            }
            if (value instanceof Expandable) {
                --shift;
            }
            this.sborder.setShift(shift * (OutlineComboBox.getExpansionHandleWidth() + itgap));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        private class ShiftBorder
        implements Border {
            private Border b;
            private int shift;
            private Insets NO_INSETS = new Insets(0, 0, 0, 0);

            public ShiftBorder(Border b) {
                this.b = b;
            }

            public void setShift(int shift) {
                this.shift = shift;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (this.b != null) {
                    this.b.paintBorder(c, g, x, y, width, height);
                }
            }

            @Override
            public Insets getBorderInsets(Component c) {
                Insets in = this.b == null ? this.NO_INSETS : this.b.getBorderInsets(c);
                if (this.shift != 0) {
                    in = new Insets(in.top, this.shift + in.left, in.bottom, in.right);
                }
                return in;
            }

            @Override
            public boolean isBorderOpaque() {
                if (this.b == null) {
                    return false;
                }
                return this.b.isBorderOpaque();
            }
        }
    }

    public static interface Expandable {
        public Object[] getItems();

        public boolean isExpanded();

        public void setExpanded(boolean var1);
    }

    private class OutlineComboBoxModel
    extends DefaultComboBoxModel {
        public OutlineComboBoxModel(Object[] items) {
            super(items);
        }

        @Override
        public void setSelectedItem(Object item) {
            if (item instanceof Expandable) {
                Expandable exp;
                exp.setExpanded(!(exp = (Expandable)item).isExpanded());
                if (OutlineComboBox.this.popupList != null) {
                    OutlineComboBox.this.setKeepPopupVisible(true);
                    OutlineComboBox.this.popupList.repaint();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OutlineComboBox.this.setKeepPopupVisible(false);
                        }
                    });
                }
                this.addRemoveSubItems(exp);
            } else {
                super.setSelectedItem(item);
            }
        }

        private void addRemoveSubItems(Expandable exp) {
            int index = this.getIndexOf(exp);
            if (exp.isExpanded()) {
                for (Object item : exp.getItems()) {
                    this.insertElementAt(item, ++index);
                    OutlineComboBox.this.expandedItems.add(item);
                }
            } else {
                ++index;
                for (Object item : exp.getItems()) {
                    this.removeElementAt(index);
                    OutlineComboBox.this.expandedItems.remove(item);
                }
            }
        }
    }

    public static interface PopupMenuItem {
        public String toPopupMenuString();
    }
}

