/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseUpgradeSourceBase;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpgradeDatabaseDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="databaseUpgradeSourceDetails")
    private final DatabaseUpgradeSourceBase databaseUpgradeSourceDetails;

    @Deprecated
    @ConstructorProperties(value={"action", "databaseUpgradeSourceDetails"})
    public UpgradeDatabaseDetails(Action action, DatabaseUpgradeSourceBase databaseUpgradeSourceDetails) {
        this.action = action;
        this.databaseUpgradeSourceDetails = databaseUpgradeSourceDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Action getAction() {
        return this.action;
    }

    public DatabaseUpgradeSourceBase getDatabaseUpgradeSourceDetails() {
        return this.databaseUpgradeSourceDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpgradeDatabaseDetails(");
        sb.append("super=").append(super.toString());
        sb.append("action=").append(String.valueOf((Object)this.action));
        sb.append(", databaseUpgradeSourceDetails=").append(String.valueOf((Object)this.databaseUpgradeSourceDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpgradeDatabaseDetails)) {
            return false;
        }
        UpgradeDatabaseDetails other = (UpgradeDatabaseDetails)((Object)o);
        return Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.databaseUpgradeSourceDetails, (Object)other.databaseUpgradeSourceDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.databaseUpgradeSourceDetails == null ? 43 : this.databaseUpgradeSourceDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Precheck("PRECHECK"),
        Upgrade("UPGRADE"),
        Rollback("ROLLBACK");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="databaseUpgradeSourceDetails")
        private DatabaseUpgradeSourceBase databaseUpgradeSourceDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder databaseUpgradeSourceDetails(DatabaseUpgradeSourceBase databaseUpgradeSourceDetails) {
            this.databaseUpgradeSourceDetails = databaseUpgradeSourceDetails;
            this.__explicitlySet__.add("databaseUpgradeSourceDetails");
            return this;
        }

        public UpgradeDatabaseDetails build() {
            UpgradeDatabaseDetails model = new UpgradeDatabaseDetails(this.action, this.databaseUpgradeSourceDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpgradeDatabaseDetails model) {
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("databaseUpgradeSourceDetails")) {
                this.databaseUpgradeSourceDetails(model.getDatabaseUpgradeSourceDetails());
            }
            return this;
        }
    }
}

