/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.regexp;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.TreeNode;
import org.netbeans.modules.i18n.regexp.TreeNodeRoot;

public class Parser {
    private String regexp;
    private String[] tokenNames;
    private int maxTokenLength;

    public static TreeNodeRoot parse(String regexp) throws IllegalArgumentException, ParseException {
        return Parser.parse(regexp, null);
    }

    public static TreeNodeRoot parse(String regexp, String[] tokenNames) throws IllegalArgumentException, ParseException {
        Parser parser = new Parser(regexp);
        if (tokenNames != null && tokenNames.length != 0) {
            parser.setTokenNames(tokenNames);
        }
        return parser.parse();
    }

    Parser(String regexp) {
        if (regexp == null) {
            throw new IllegalArgumentException();
        }
        this.regexp = regexp;
    }

    private void setTokenNames(String[] tokenNames) {
        if (tokenNames != null && tokenNames.length != 0) {
            this.tokenNames = tokenNames;
            this.maxTokenLength = tokenNames[0].length();
            for (int i = 1; i < tokenNames.length; ++i) {
                if (tokenNames[i].length() <= this.maxTokenLength) continue;
                this.maxTokenLength = tokenNames[i].length();
            }
        } else {
            this.tokenNames = null;
            this.maxTokenLength = 0;
        }
    }

    TreeNodeRoot parse() throws ParseException {
        TreeNode multiRegexpNode = null;
        int begin = 0;
        int end = this.regexp.length();
        boolean initialPart = false;
        boolean finalPart = false;
        if (begin == end) {
            return null;
        }
        if (this.regexp.charAt(0) == '^') {
            initialPart = true;
            ++begin;
        }
        if (end == begin + 1 && this.regexp.charAt(begin) == '$') {
            finalPart = true;
            --end;
        }
        if (begin != end) {
            multiRegexpNode = this.parseMultiRegexp(begin, end);
            if (multiRegexpNode == null) {
                this.throwParseException(begin);
            }
            if (multiRegexpNode.end == end - 1 && this.regexp.charAt(end - 1) == '$') {
                finalPart = true;
                --end;
            }
            if (multiRegexpNode.end != end) {
                this.throwParseException(begin);
            }
        }
        String attribs = null;
        if (initialPart || finalPart) {
            StringBuilder buf = new StringBuilder(2);
            if (initialPart) {
                buf.append('^');
            }
            if (finalPart) {
                buf.append('$');
            }
            attribs = buf.toString();
        }
        TreeNodeRoot result = new TreeNodeRoot(this.regexp, attribs);
        if (multiRegexpNode != null) {
            result.add(multiRegexpNode);
        }
        return result;
    }

    private void throwParseException(int position) throws ParseException {
        throw new ParseException(this.regexp, position);
    }

    private TreeNode parseMultiRegexp(int start, int end) throws ParseException {
        if (start == end) {
            return null;
        }
        TreeNode regexpSequenceNode = this.parseRegexpSequence(start, end);
        if (regexpSequenceNode == null) {
            return null;
        }
        ArrayList<TreeNode> alternatives = new ArrayList<TreeNode>(4);
        alternatives.add(regexpSequenceNode);
        while (regexpSequenceNode.end != end && this.regexp.charAt(regexpSequenceNode.end) == '|') {
            int from = regexpSequenceNode.end + 1;
            regexpSequenceNode = this.parseRegexpSequence(from, end);
            if (regexpSequenceNode == null) {
                this.throwParseException(from);
            }
            alternatives.add(regexpSequenceNode);
        }
        TreeNode result = new TreeNode(1, start, regexpSequenceNode.end);
        for (TreeNode alt : alternatives) {
            result.add(alt);
        }
        return result;
    }

    private TreeNode parseRegexpSequence(int start, int end) throws ParseException {
        TreeNode qRegexpNode;
        if (start == end) {
            return null;
        }
        ArrayList<TreeNode> sequence = null;
        TreeNode lastChildNode = null;
        int from = start;
        while ((qRegexpNode = this.parseQRegexp(from, end)) != null) {
            if (sequence == null) {
                sequence = new ArrayList<TreeNode>(4);
            }
            sequence.add(qRegexpNode);
            lastChildNode = qRegexpNode;
            if (qRegexpNode.end == end) break;
            from = qRegexpNode.end;
        }
        if (sequence == null) {
            return null;
        }
        TreeNode result = new TreeNode(2, start, lastChildNode.end);
        for (TreeNode seqPart : sequence) {
            result.add(seqPart);
        }
        return result;
    }

    private TreeNode parseQRegexp(int start, int end) throws ParseException {
        TreeNode result;
        if (start == end) {
            return null;
        }
        TreeNode singleRegexpNode = this.parseSingleRegexp(start, end);
        if (singleRegexpNode == null) {
            return null;
        }
        if (singleRegexpNode.end == end) {
            TreeNode result2 = new TreeNode(3, start, singleRegexpNode.end);
            result2.add(singleRegexpNode);
            return result2;
        }
        TreeNode quantifierNode = this.parseQuantifier(singleRegexpNode.end, end);
        if (quantifierNode == null) {
            result = new TreeNode(3, start, singleRegexpNode.end);
            result.add(singleRegexpNode);
        } else {
            result = new TreeNode(3, start, quantifierNode.end);
            result.add(singleRegexpNode);
            result.add(quantifierNode);
        }
        return result;
    }

    private TreeNode parseSingleRegexp(int start, int end) throws ParseException {
        TreeNode result;
        if (start == end) {
            return null;
        }
        char ch = this.regexp.charAt(start);
        block0 : switch (ch) {
            case '.': {
                result = new TreeNode(6, start, start + 1, Character.valueOf(ch));
                break;
            }
            case '[': {
                TreeNode setNode = this.parseSet(start, end);
                assert (setNode != null);
                return setNode;
            }
            case '(': {
                TreeNode subexprNode = this.parseSubexpr(start, end);
                assert (subexprNode != null);
                return subexprNode;
            }
            case '\\': {
                if (end == start + 1) {
                    this.throwParseException(end);
                }
                char ch2 = this.regexp.charAt(start + 1);
                switch (ch2) {
                    case 'B': 
                    case 'b': {
                        result = new TreeNode(6, start, start + 2, Character.valueOf(ch2));
                        break block0;
                    }
                    case 'u': {
                        Integer unicode = this.parseUnicode(start + 2, end);
                        if (unicode == null) {
                            this.throwParseException(start + 2);
                        }
                        result = new TreeNode(7, start, start + 6, unicode);
                        break block0;
                    }
                }
                result = new TreeNode(8, start, start + 2, Character.valueOf(switch (ch2) {
                    case 't' -> '\t';
                    case 'n' -> '\n';
                    case 'r' -> '\r';
                    case 'f' -> '\f';
                    default -> ch2;
                }));
                break;
            }
            case '{': {
                String tokenName = this.getTokenName(start, end);
                if (tokenName != null) {
                    result = new TreeNode(13, start, start + tokenName.length() + 2, tokenName);
                    break;
                }
            }
            default: {
                if ("^$|*+?)]{}".indexOf(ch) != -1) {
                    return null;
                }
                result = new TreeNode(8, start, start + 1, Character.valueOf(ch));
            }
        }
        return result;
    }

    private TreeNode parseQuantifier(int start, int end) throws ParseException {
        TreeNode numberNode1;
        if (start == end) {
            return null;
        }
        TreeNode result = null;
        char ch = this.regexp.charAt(start);
        switch (ch) {
            case '*': 
            case '+': 
            case '?': {
                result = new TreeNode(4, start, start + 1, Character.valueOf(ch));
                return result;
            }
            case '{': {
                break;
            }
            default: {
                return null;
            }
        }
        if (end - start == 1) {
            this.throwParseException(start + 1);
        }
        if ((numberNode1 = this.parseNumber(start + 1, end)) == null) {
            if (this.getTokenName(start, end) != null) {
                return null;
            }
            this.throwParseException(start + 1);
        }
        if (numberNode1.end == end) {
            this.throwParseException(numberNode1.end);
        }
        switch (this.regexp.charAt(numberNode1.end)) {
            case '}': {
                result = new TreeNode(4, start, numberNode1.end + 1, "{n}");
                result.add(numberNode1);
                return result;
            }
            case ',': {
                break;
            }
            default: {
                this.throwParseException(numberNode1.end);
            }
        }
        if (numberNode1.end + 1 == end) {
            this.throwParseException(numberNode1.end + 1);
        }
        if (this.regexp.charAt(numberNode1.end + 1) == '}') {
            result = new TreeNode(4, start, numberNode1.end + 2, "{n,}");
            result.add(numberNode1);
            return result;
        }
        TreeNode numberNode2 = this.parseNumber(numberNode1.end + 1, end);
        if (numberNode2 == null) {
            this.throwParseException(numberNode1.end + 1);
        }
        if (numberNode2.end == end || this.regexp.charAt(numberNode2.end) != '}') {
            this.throwParseException(numberNode2.end);
        }
        int num1 = (Integer)numberNode1.getAttribs();
        int num2 = (Integer)numberNode2.getAttribs();
        if (num2 < num1) {
            this.throwParseException(numberNode2.start);
        }
        result = new TreeNode(4, start, numberNode2.end + 1, "{n,n}");
        result.add(numberNode1);
        result.add(numberNode2);
        return result;
    }

    private TreeNode parseNumber(int start, int end) throws ParseException {
        int number;
        if (start == end) {
            return null;
        }
        char[] chars = this.regexp.substring(start, end).toCharArray();
        int endIndex = chars.length;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') continue;
            endIndex = i;
            break;
        }
        if (endIndex == 0) {
            return null;
        }
        if (endIndex > 3) {
            this.throwParseException(start);
        }
        if (endIndex == 1) {
            number = chars[0] - 48;
        } else {
            try {
                number = Integer.parseInt(this.regexp.substring(start, start + endIndex));
            }
            catch (NumberFormatException ex) {
                throw new AssertionError();
            }
        }
        TreeNode result = new TreeNode(5, start, start + endIndex, number);
        return result;
    }

    private String getTokenName(int start, int end) {
        if (this.tokenNames == null) {
            return null;
        }
        int checkAreaLength = Math.min(end - start, this.maxTokenLength + 2);
        String substring = this.regexp.substring(start, start + checkAreaLength);
        if (substring.charAt(0) != '{') {
            return null;
        }
        int rightBoundaryIndex = substring.indexOf(125, 1);
        if (rightBoundaryIndex == -1) {
            return null;
        }
        String tokenName = substring.substring(1, rightBoundaryIndex);
        for (int i = 0; i < this.tokenNames.length; ++i) {
            if (!tokenName.equals(this.tokenNames[i])) continue;
            return tokenName;
        }
        return null;
    }

    private Integer parseUnicode(int start, int end) throws ParseException {
        Integer integer;
        if (start == end) {
            return null;
        }
        if (end - start < 4) {
            this.throwParseException(start);
        }
        char[] chars = this.regexp.substring(start, start + 4).toCharArray();
        for (int i = 0; i < 4; ++i) {
            char ch = chars[i];
            if ("01234567890abcdefABCDEF".indexOf(ch) != -1) continue;
            if (i == 0) {
                return null;
            }
            this.throwParseException(start);
        }
        try {
            integer = Integer.valueOf(this.regexp.substring(start, start + 4), 16);
        }
        catch (NumberFormatException ex) {
            throw new AssertionError();
        }
        return integer;
    }

    private TreeNode parseSubexpr(int start, int end) throws ParseException {
        TreeNode multiRegexpNode;
        if (start == end) {
            return null;
        }
        if (this.regexp.charAt(start) != '(') {
            return null;
        }
        if (end == start + 1) {
            this.throwParseException(start + 1);
        }
        if ((multiRegexpNode = this.parseMultiRegexp(start + 1, end)) == null) {
            this.throwParseException(start + 1);
        }
        if (multiRegexpNode.end == end || this.regexp.charAt(multiRegexpNode.end) != ')') {
            this.throwParseException(multiRegexpNode.end);
        }
        TreeNode result = new TreeNode(9, start, multiRegexpNode.end + 1);
        result.add(multiRegexpNode);
        return result;
    }

    private TreeNode parseSet(int start, int end) throws ParseException {
        String specials;
        String setString;
        int endIndex;
        if (start == end) {
            return null;
        }
        if (this.regexp.charAt(start) != '[') {
            return null;
        }
        if (end == start + 1) {
            this.throwParseException(start + 1);
        }
        if ((endIndex = (setString = this.regexp.substring(start, end)).indexOf(93, 1 + (specials = this.getSpecials(setString)).length())) == -1) {
            this.throwParseException(start);
        } else {
            ++endIndex;
        }
        setString = this.regexp.substring(start, endIndex += start);
        int setLength = setString.length();
        if (setLength >= 5 && setString.charAt(1) == ':' && setString.charAt(setLength - 2) == ':') {
            String charClassName = setString.substring(2, setLength - 2);
            if (this.isPosixCharClass(charClassName)) {
                TreeNode result = new TreeNode(10, start, endIndex, charClassName);
                return result;
            }
            this.throwParseException(start + 2);
        }
        TreeNode result = new TreeNode(11, start, endIndex, specials);
        int from = start + 1 + specials.length();
        int to = endIndex - 1;
        while (from != to) {
            TreeNode rangeNode = this.parseRangeOrChar(from, to);
            if (rangeNode == null) {
                this.throwParseException(from);
            }
            result.add(rangeNode);
            from = rangeNode.end;
        }
        return result;
    }

    private TreeNode parseRangeOrChar(int start, int end) throws ParseException {
        int char2;
        Object charObject;
        if (start == end) {
            return null;
        }
        TreeNode rangeCharNode1 = this.parseRangeChar(start, end);
        if (rangeCharNode1 == null) {
            return null;
        }
        if (rangeCharNode1.end == end || this.regexp.charAt(rangeCharNode1.end) != '-') {
            return rangeCharNode1;
        }
        TreeNode rangeCharNode2 = this.parseRangeChar(rangeCharNode1.end + 1, end);
        if (rangeCharNode2 == null) {
            this.throwParseException(rangeCharNode1.end + 1);
        }
        int char1 = (charObject = rangeCharNode1.getAttribs()) instanceof Character ? Character.getNumericValue(((Character)charObject).charValue()) : (Integer)charObject;
        charObject = rangeCharNode2.getAttribs();
        int n = char2 = charObject instanceof Character ? Character.getNumericValue(((Character)charObject).charValue()) : (Integer)charObject;
        if (char1 >= char2) {
            this.throwParseException(rangeCharNode1.end + 1);
        }
        TreeNode result = new TreeNode(12, start, rangeCharNode2.end);
        result.add(rangeCharNode1);
        result.add(rangeCharNode2);
        return result;
    }

    private TreeNode parseRangeChar(int start, int end) throws ParseException {
        TreeNode result;
        if (start == end) {
            return null;
        }
        char ch = this.regexp.charAt(start);
        switch (ch) {
            case '-': 
            case ']': {
                return null;
            }
            case '\\': {
                char parsedChar;
                if (end == start + 1) {
                    this.throwParseException(start + 1);
                }
                char ch2 = this.regexp.charAt(start + 1);
                switch (ch2) {
                    case 'u': {
                        Integer unicode = this.parseUnicode(start + 2, end);
                        if (unicode == null) {
                            this.throwParseException(start + 2);
                        }
                        int codeValue = unicode;
                        assert (codeValue >= 0);
                        if (codeValue <= 127) {
                            this.throwParseException(start + 2);
                        }
                        return new TreeNode(7, start, start + 6, unicode);
                    }
                    case '-': 
                    case ']': {
                        this.throwParseException(start + 2);
                    }
                    case 't': {
                        parsedChar = '\t';
                        break;
                    }
                    case 'n': {
                        parsedChar = '\n';
                        break;
                    }
                    case 'r': {
                        parsedChar = '\r';
                        break;
                    }
                    case 'f': {
                        parsedChar = '\f';
                        break;
                    }
                    default: {
                        parsedChar = ch2;
                    }
                }
                result = new TreeNode(8, start, start + 2, Character.valueOf(parsedChar));
                break;
            }
            default: {
                result = new TreeNode(8, start, start + 1, Character.valueOf(ch));
            }
        }
        return result;
    }

    private String getSpecials(String setRegexp) {
        int index = 1;
        int maxIndex = 3;
        if (setRegexp.length() < 5) {
            maxIndex = setRegexp.length() - 2;
        }
        StringBuilder buf = new StringBuilder(maxIndex - index + 1);
        char ch = setRegexp.charAt(index);
        if (ch == '^') {
            buf.append(ch);
            if (index == maxIndex) {
                return buf.toString();
            }
            ch = setRegexp.charAt(++index);
        }
        if (ch == ']') {
            buf.append(ch);
            if (index == maxIndex) {
                return buf.toString();
            }
            ch = setRegexp.charAt(++index);
        }
        if (ch == '-') {
            buf.append(ch);
        }
        return buf.toString();
    }

    private boolean isPosixCharClass(String name) {
        if (name.equals("xdigit")) {
            return true;
        }
        if (name.length() != 5) {
            return false;
        }
        String classNames = "alnum alpha blank cntrl digit graph lower print punct space upper";
        StringTokenizer tokenizer = new StringTokenizer(classNames, " ");
        while (tokenizer.hasMoreTokens()) {
            if (!name.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }
}

