/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.caret;

import java.awt.Point;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.CaretTransaction;
import org.netbeans.api.editor.caret.FilterBypassImpl;

public final class CaretMoveContext {
    private CaretTransaction transaction;

    CaretMoveContext(CaretTransaction transactionContext) {
        this.transaction = transactionContext;
    }

    @NonNull
    public List<CaretInfo> getOriginalCarets() {
        return this.transaction.getOriginalCarets();
    }

    @NonNull
    public CaretInfo getOriginalLastCaret() {
        List<CaretInfo> origCarets = this.getOriginalCarets();
        return origCarets.get(origCarets.size() - 1);
    }

    @NonNull
    public List<CaretInfo> getOriginalSortedCarets() {
        return this.transaction.getOriginalSortedCarets();
    }

    public boolean setDot(@NonNull CaretInfo caret, @NonNull Position dotPos, @NonNull Position.Bias dotBias) {
        NavigationFilter naviFilter = this.transaction.getCaret().getNavigationFilterNoDefault(this.transaction.getOrigin());
        if (naviFilter != null) {
            FilterBypassImpl fbi = new FilterBypassImpl(this.transaction, caret, this.transaction.getDocument());
            naviFilter.setDot(fbi, dotPos.getOffset(), Position.Bias.Forward);
            return fbi.getResult();
        }
        return this.setDotAndMark(caret, dotPos, dotBias, dotPos, dotBias);
    }

    public boolean moveDot(@NonNull CaretInfo caret, @NonNull Position dotPos, @NonNull Position.Bias dotBias) {
        NavigationFilter naviFilter = this.transaction.getCaret().getNavigationFilterNoDefault(this.transaction.getOrigin());
        if (naviFilter != null) {
            FilterBypassImpl fbi = new FilterBypassImpl(this.transaction, caret, this.transaction.getDocument());
            naviFilter.moveDot(fbi, dotPos.getOffset(), Position.Bias.Forward);
            return fbi.getResult();
        }
        return this.transaction.moveDot(caret.getCaretItem(), dotPos, dotBias);
    }

    public boolean setDotAndMark(@NonNull CaretInfo caret, @NonNull Position dotPos, @NonNull Position.Bias dotBias, @NonNull Position markPos, @NonNull Position.Bias markBias) {
        return this.transaction.setDotAndMark(caret.getCaretItem(), dotPos, dotBias, markPos, markBias);
    }

    public boolean setMagicCaretPosition(@NonNull CaretInfo caret, Point p) {
        return this.transaction.setMagicCaretPosition(caret.getCaretItem(), p);
    }

    @NonNull
    public JTextComponent getComponent() {
        return this.transaction.getComponent();
    }

    public Document getDocument() {
        return this.getComponent().getDocument();
    }
}

