/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjavac.services;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.function.Consumer;
import org.netbeans.lib.nbjavac.services.CancelService;
import org.netbeans.lib.nbjavac.services.NBTreeMaker;

public class NBParserFactory
extends ParserFactory {
    private final ScannerFactory scannerFactory;
    private final NBTreeMaker make;
    private final CancelService cancelService;

    public static void preRegister(Context context) {
        context.put(parserFactoryKey, new Context.Factory<ParserFactory>(){

            @Override
            public ParserFactory make(Context c) {
                return new NBParserFactory(c);
            }
        });
    }

    protected NBParserFactory(Context context) {
        super(context);
        this.scannerFactory = ScannerFactory.instance(context);
        this.make = (NBTreeMaker)NBTreeMaker.instance(context);
        this.cancelService = CancelService.instance(context);
    }

    @Override
    public JavacParser newParser(CharSequence input, boolean keepDocComments, boolean keepEndPos, boolean keepLineMap, boolean parseModuleInfo) {
        Scanner lexer = this.scannerFactory.newScanner(input, keepDocComments);
        return new NBJavacParser(this, lexer, keepDocComments, keepLineMap, keepEndPos, parseModuleInfo, this.cancelService);
    }

    public static class NBJavacParser
    extends JavacParser {
        private final NBTreeMaker make;
        private final CancelService cancelService;

        public NBJavacParser(NBParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, boolean keepEndPos, boolean parseModuleInfo, CancelService cancelService) {
            super(fac, S, keepDocComments, keepLineMap, keepEndPos, parseModuleInfo);
            this.make = fac.make;
            this.cancelService = cancelService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JCTree.JCCompilationUnit parseCompilationUnit() {
            JCTree.JCCompilationUnit unit;
            JCTree.JCPackageDecl[] pack = new JCTree.JCPackageDecl[1];
            Consumer<JCTree.JCPackageDecl> prevCallback = this.make.setPackageCreatedCallback(p -> {
                pack[0] = p;
            });
            try {
                unit = super.parseCompilationUnit();
            }
            finally {
                this.make.setPackageCreatedCallback(prevCallback);
            }
            if (!((List)unit.getTypeDecls()).isEmpty() && ((JCTree)((List)unit.getTypeDecls()).get(0)).getKind() == Tree.Kind.CLASS) {
                JCTree.JCClassDecl firstClass = (JCTree.JCClassDecl)((List)unit.getTypeDecls()).get(0);
                if ((firstClass.mods.flags & 0x80000L) != 0L) {
                    if (pack[0] != null) {
                        unit.defs = unit.defs.prepend(pack[0]);
                    }
                    List<JCTree> defs = unit.defs;
                    int newPos = 0;
                    while (defs.nonEmpty() && !((JCTree)defs.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        newPos = Math.max(newPos, this.getEndPos((JCTree)defs.head));
                        defs = defs.tail;
                    }
                    firstClass.pos = newPos;
                }
            }
            return unit;
        }

        @Override
        protected JavacParser.AbstractEndPosTable newEndPosTable(boolean keepEndPositions) {
            JavacParser.AbstractEndPosTable res = super.newEndPosTable(keepEndPositions);
            if (keepEndPositions) {
                return new EndPosTableImpl(this.S, this, (JavacParser.SimpleEndPosTable)res);
            }
            return res;
        }

        @Override
        protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.classDeclaration(mods, dc);
        }

        @Override
        protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.interfaceDeclaration(mods, dc);
        }

        @Override
        protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.enumDeclaration(mods, dc);
        }

        @Override
        protected JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, boolean isRecord, Tokens.Comment dc) {
            if (this.cancelService != null) {
                this.cancelService.abortIfCanceled();
            }
            return super.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, isRecord, dc);
        }

        @Override
        public int getEndPos(JCTree jctree) {
            return TreeInfo.getEndPos(jctree, this.endPosTable);
        }

        @Override
        public JCTree.JCStatement parseSimpleStatement() {
            JCTree.JCStatement result = super.parseSimpleStatement();
            if (result instanceof JCTree.JCEnhancedForLoop) {
                JCTree.JCEnhancedForLoop tree = (JCTree.JCEnhancedForLoop)result;
                if (this.getEndPos(tree.var) == -1) {
                    ((EndPosTableImpl)this.endPosTable).setEnd(tree.var, this.getEndPos(tree.var.vartype));
                }
            }
            return result;
        }

        public final class EndPosTableImpl
        extends JavacParser.AbstractEndPosTable {
            private final JavacParser.SimpleEndPosTable delegate;

            private EndPosTableImpl(Lexer lexer, JavacParser parser, JavacParser.SimpleEndPosTable delegate) {
                this.delegate = delegate;
            }

            public void resetErrorEndPos() {
                this.errorEndPos = this.delegate.errorEndPos = -1;
            }

            public <T extends JCTree> T storeEnd(T tree, int endpos) {
                if (endpos >= 0) {
                    return (T)this.delegate.storeEnd(tree, endpos);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setEnd(JCTree tree, int endpos) {
                if (endpos >= 0) {
                    int oldErrorEndPos = this.delegate.errorEndPos;
                    try {
                        this.delegate.errorEndPos = -1;
                        this.delegate.storeEnd(tree, endpos);
                    }
                    finally {
                        this.delegate.errorEndPos = oldErrorEndPos;
                    }
                }
            }

            @Override
            public void setErrorEndPos(int errPos) {
                this.delegate.setErrorEndPos(errPos);
                this.errorEndPos = this.delegate.errorEndPos;
            }

            @Override
            public int getEndPos(JCTree jctree) {
                return this.delegate.getEndPos(jctree);
            }

            @Override
            public int replaceTree(JCTree jctree, JCTree jctree1) {
                return this.delegate.replaceTree(jctree, jctree1);
            }
        }
    }
}

