/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;

public final class FileBasedURLMapper
extends URLMapper {
    private static final Logger LOG = Logger.getLogger(FileBasedURLMapper.class.getName());

    public final URL getURL(FileObject fo, int type) {
        if (type == 2) {
            return null;
        }
        try {
            if (fo instanceof BaseFileObj) {
                BaseFileObj bfo = (BaseFileObj)fo;
                return FileBasedURLMapper.fileToURL(bfo.getFileName().getFile(), fo);
            }
            if (fo instanceof RootObj) {
                RootObj rfo = (RootObj)fo;
                return this.getURL((FileObject)rfo.getRealRoot(), type);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public final FileObject[] getFileObjects(URL url) {
        File file;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        if (url.getPath().equals("//") || url.getPath().equals("////")) {
            return null;
        }
        try {
            file = FileUtil.normalizeFile((File)BaseUtilities.toFile((URI)url.toURI()));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            LOG.log(Level.INFO, "URL=" + url, e);
            return null;
        }
        return new FileObject[]{FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.ToFileObject)};
    }

    private static URL fileToURL(File file, FileObject fo) throws MalformedURLException {
        URL retVal = FileBasedURLMapper.toURI(file, fo.isFolder()).toURL();
        if (fo.isFolder()) {
            String urlDef = retVal.toExternalForm();
            String pathSeparator = "/";
            if (!urlDef.endsWith("/")) {
                retVal = new URL(urlDef + "/");
            }
        }
        return retVal;
    }

    private static URI toURI(File file, boolean isDirectory) {
        return FileBasedURLMapper.toURI(file.getAbsolutePath(), isDirectory, File.separatorChar);
    }

    static URI toURI(String path, boolean isDirectory, char separator) {
        String sp = FileBasedURLMapper.slashify(path, isDirectory, separator);
        try {
            return new URI("file", null, sp, null);
        }
        catch (URISyntaxException x) {
            try {
                return new URI("file", null, "//" + sp, null);
            }
            catch (URISyntaxException ex) {
                throw new Error(x);
            }
        }
    }

    private static String slashify(String p, boolean isDirectory, char separatorChar) {
        if (separatorChar != '/') {
            p = ((String)p).replace(separatorChar, '/');
        }
        if (!((String)p).startsWith("/")) {
            p = "/" + (String)p;
        }
        if (!((String)p).endsWith("/") && isDirectory) {
            p = (String)p + "/";
        }
        return p;
    }
}

