/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class DiffStreamSource
extends StreamSource {
    private final File baseFile;
    private final String propertyName;
    private final String revision;
    private final String title;
    private String mimeType;
    private boolean initialized;
    private File remoteFile;
    private MultiDiffPanel.Property propertyValue;
    private Boolean canWriteBaseFile;

    public DiffStreamSource(File baseFile, String propertyName, String revision, String title) {
        this.baseFile = Utilities.isMac() || Utilities.isWindows() ? FileUtil.normalizeFile((File)baseFile) : baseFile;
        this.propertyName = propertyName;
        this.revision = revision;
        this.title = title;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException e) {
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.propertyName != null) {
            if (this.propertyValue != null) {
                return this.propertyValue.toReader();
            }
            return null;
        }
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] conflicts) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return this.propertyName == null && "LOCAL".equals(this.revision) && this.isPrimary() && this.isBaseFileWritable();
    }

    private boolean isBaseFileWritable() {
        if (this.canWriteBaseFile == null) {
            FileObject fo = FileUtil.toFileObject((File)this.baseFile);
            this.canWriteBaseFile = fo != null && fo.canWrite();
        }
        return this.canWriteBaseFile;
    }

    private boolean isPrimary() {
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        if (fo != null) {
            try {
                DataObject dao = DataObject.find((FileObject)fo);
                return fo.equals(dao.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException e) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.propertyName != null || this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject remoteFo = FileUtil.toFileObject((File)this.remoteFile);
        if (remoteFo == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{remoteFo});
    }

    synchronized void init() throws IOException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.propertyValue != null || this.remoteFile != null || this.revision == null) {
            return;
        }
        if (this.propertyName != null) {
            this.initProperty();
            return;
        }
        if (this.baseFile.isDirectory()) {
            this.mimeType = "content/unknown";
            return;
        }
        this.mimeType = SvnUtils.getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                File tempFolder = Utils.getTempFolder();
                Set allFiles = Utils.getAllDataObjectFiles((File)this.baseFile);
                for (File file : allFiles) {
                    boolean isBase = file.equals(this.baseFile);
                    try {
                        File rf = VersionsCache.getInstance().getFileRevision(file, this.revision);
                        if (rf == null) {
                            this.remoteFile = null;
                            return;
                        }
                        File newRemoteFile = new File(tempFolder, file.getName());
                        newRemoteFile.deleteOnExit();
                        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(newRemoteFile), (InputStream)new FileInputStream(rf));
                        if (!isBase) continue;
                        this.remoteFile = newRemoteFile;
                        Utils.associateEncoding((File)file, (File)newRemoteFile);
                    }
                    catch (Exception e) {
                        if (SvnClientExceptionHandler.isTargetDirectory(e.getMessage()) || e.getCause() != null && SvnClientExceptionHandler.isTargetDirectory(e.getCause().getMessage())) {
                            this.mimeType = "content/unknown";
                            return;
                        }
                        if (!isBase) continue;
                        throw e;
                    }
                }
            }
            if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
                this.mimeType = SvnUtils.getMimeType(this.remoteFile);
            }
        }
        catch (Exception e) {
            throw new IOException("Can not load remote file for " + this.baseFile, e);
        }
        FileObject fo = FileUtil.toFileObject((File)this.baseFile);
        this.canWriteBaseFile = fo != null && fo.canWrite();
    }

    private void initProperty() throws IOException {
        PropertiesClient client = new PropertiesClient(this.baseFile);
        if ("BASE".equals(this.revision)) {
            byte[] value = client.getBaseProperties(true).get(this.propertyName);
            this.propertyValue = value != null ? new MultiDiffPanel.Property(value) : null;
        } else if ("LOCAL".equals(this.revision)) {
            byte[] value = client.getProperties().get(this.propertyName);
            this.propertyValue = value != null ? new MultiDiffPanel.Property(value) : null;
        }
        this.mimeType = this.propertyValue != null ? this.propertyValue.getMIME() : "content/unknown";
    }
}

