/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.updater.Localization;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class ModuleDeactivator {
    public static final String TO_UNINSTALL = "to_uninstall.txt";
    public static final String TO_DISABLE = "to_disable.txt";
    public static final String TO_ENABLE = "to_enable.txt";
    public static final String CONFIG = "config";
    public static final String MODULES = "Modules";
    private final UpdatingContext context;
    private static String ENABLE_TAG = "<param name=\"enabled\">true</param>";
    private static String DISABLE_TAG = "<param name=\"enabled\">false</param>";

    ModuleDeactivator(UpdatingContext context) {
        this.context = context;
    }

    public void delete() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        this.context.setLabel(Localization.getBrandedString("CTL_DeletingFiles"));
        HashSet<File> allFiles = new HashSet<File>();
        for (File cluster : UpdateTracking.clusters(true)) {
            boolean modified = allFiles.addAll(ModuleDeactivator.readFilesMarkedForDeleteInCluster(cluster));
            modified = allFiles.add(ModuleDeactivator.getControlFileForMarkedForDelete(cluster)) || modified;
            modified = allFiles.add(ModuleDeactivator.getDeactivateLater(cluster)) || modified;
            if (!modified) continue;
            UpdaterDispatcher.touchLastModified(cluster);
        }
        this.context.setProgressRange(0L, allFiles.size());
        int i = 0;
        for (File f : allFiles) {
            ModuleDeactivator.doDelete(f);
            this.context.setProgressValue(i++);
        }
    }

    public void enableDisable(boolean enable) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        this.context.setLabel(enable ? Localization.getBrandedString("CTL_EnablingFiles") : Localization.getBrandedString("CTL_DisablingFiles"));
        HashSet<File> allControlFiles = new HashSet<File>();
        for (File cluster : UpdateTracking.clusters(true)) {
            allControlFiles.addAll(ModuleDeactivator.readFilesMarkedForEnableDisableInCluster(cluster, enable));
            ModuleDeactivator.doDelete(ModuleDeactivator.getControlFileForMarkedForEnableDisable(cluster, enable));
            if (enable) continue;
            ModuleDeactivator.doDelete(ModuleDeactivator.getDeactivateLater(cluster));
        }
        this.context.setProgressRange(0L, allControlFiles.size());
        int i = 0;
        for (File f : allControlFiles) {
            ModuleDeactivator.doEnableDisable(f, enable);
            this.context.setProgressValue(i++);
        }
    }

    public static boolean hasModulesForDelete(File updateDir) {
        File deactivateDir = new File(updateDir, "deactivate");
        return deactivateDir.exists() && deactivateDir.isDirectory() && Arrays.asList(deactivateDir.list()).contains(TO_UNINSTALL);
    }

    public static boolean hasModulesForDisable(File updateDir) {
        File deactivateDir = new File(updateDir, "deactivate");
        return deactivateDir.exists() && deactivateDir.isDirectory() && Arrays.asList(deactivateDir.list()).contains(TO_DISABLE);
    }

    public static boolean hasModulesForEnable(File updateDir) {
        File deactivateDir = new File(updateDir, "deactivate");
        return deactivateDir.exists() && deactivateDir.isDirectory() && Arrays.asList(deactivateDir.list()).contains(TO_ENABLE);
    }

    public static File getDeactivateLater(File cluster) {
        File file = new File(cluster, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + "deactivate_later.txt");
        return file;
    }

    public static File getControlFileForMarkedForDelete(File cluster) {
        File file = new File(cluster, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + TO_UNINSTALL);
        return file;
    }

    public static File getControlFileForMarkedForEnableDisable(File cluster, boolean enable) {
        String fileName = enable ? TO_ENABLE : TO_DISABLE;
        File file = new File(cluster, "update" + UpdateTracking.FILE_SEPARATOR + "deactivate" + UpdateTracking.FILE_SEPARATOR + fileName);
        return file;
    }

    public static void writeStringToFile(String content, File file) {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(content);
                XMLUtil.LOG.info("File " + file + " modified.");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException ioe) {
            XMLUtil.LOG.log(Level.SEVERE, "Cannot write " + file, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(File file) {
        StringBuffer fileData = null;
        BufferedReader reader = null;
        try {
            try {
                int numRead;
                fileData = new StringBuffer();
                reader = new BufferedReader(new FileReader(file));
                char[] buf = new char[1024];
                while ((numRead = reader.read(buf)) != -1) {
                    String readData = String.valueOf(buf, 0, numRead);
                    fileData.append(readData);
                    buf = new char[1024];
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ioe) {
            XMLUtil.LOG.log(Level.SEVERE, "Cannot read " + file, ioe);
        }
        return fileData == null ? "" : fileData.toString();
    }

    private static void doDelete(File f) {
        assert (f != null) : "Invalid file " + f + " for delete.";
        if (!f.exists()) {
            return;
        }
        XMLUtil.LOG.info("Deleting file: " + f);
        if (!f.delete()) {
            f.deleteOnExit();
            XMLUtil.LOG.info("File " + f + " cannot be deleted. Will be delete later on exit.");
        } else {
            XMLUtil.LOG.info("File " + f + " deleted.");
        }
        for (f = f.getParentFile(); f != null && ModuleDeactivator.doDeleteEmptyDirectory(f); f = f.getParentFile()) {
        }
    }

    private static boolean doDeleteEmptyDirectory(File d) {
        boolean res;
        assert (d != null) : d + " cannot be null";
        if (d.isDirectory()) {
            File f;
            List<File> files = Arrays.asList(d.listFiles());
            if (files.size() == 1 && ".lastModified".endsWith((f = files.get(0)).getName())) {
                if (f.delete()) {
                    d.delete();
                }
                XMLUtil.LOG.info("File " + f + " deleted.");
            }
            res = d.delete();
            XMLUtil.LOG.info("Directory " + d + " deleted.");
        } else {
            res = d.delete();
            XMLUtil.LOG.info("File " + d + " deleted.");
        }
        return res;
    }

    private static Set<File> readFilesMarkedForDeleteInCluster(File cluster) {
        File mark4deleteFile = ModuleDeactivator.getControlFileForMarkedForDelete(cluster);
        if (!mark4deleteFile.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> toDelete = new HashSet<File>();
        String content = ModuleDeactivator.readStringFromFile(mark4deleteFile);
        StringTokenizer tokenizer = new StringTokenizer(content, UpdateTracking.PATH_SEPARATOR);
        while (tokenizer.hasMoreElements()) {
            String filePath = tokenizer.nextToken();
            File f = new File(filePath);
            if (!f.exists()) continue;
            toDelete.add(f);
        }
        return toDelete;
    }

    private static Set<File> readFilesMarkedForEnableDisableInCluster(File cluster, boolean enable) {
        File mark4disableFile = ModuleDeactivator.getControlFileForMarkedForEnableDisable(cluster, enable);
        if (!mark4disableFile.exists()) {
            return Collections.emptySet();
        }
        HashSet<File> toDisable = new HashSet<File>();
        String content = ModuleDeactivator.readStringFromFile(mark4disableFile);
        StringTokenizer tokenizer = new StringTokenizer(content, UpdateTracking.PATH_SEPARATOR);
        while (tokenizer.hasMoreElements()) {
            String filePath = tokenizer.nextToken();
            File f = new File(filePath);
            if (!f.exists()) continue;
            toDisable.add(f);
        }
        return toDisable;
    }

    private static void doEnableDisable(File f, boolean enable) {
        String expected = enable ? DISABLE_TAG : ENABLE_TAG;
        String target = enable ? ENABLE_TAG : DISABLE_TAG;
        Object content = ModuleDeactivator.readStringFromFile(f);
        if (!((String)content).contains(target)) {
            int pos = ((String)content).indexOf(expected);
            assert (pos != -1) : expected + " must be contained in " + (String)content;
            int shift = expected.length();
            String pre = ((String)content).substring(0, pos);
            String post = ((String)content).substring(pos + shift);
            content = pre + target + post;
        }
        File configDir = new File(new File(UpdateTracking.getUserDir(), CONFIG), MODULES);
        configDir.mkdirs();
        File dest = new File(configDir, f.getName());
        ModuleDeactivator.writeStringToFile((String)content, dest);
    }
}

