/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ContainerListener;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class ContainerOperator<T extends Container>
extends ComponentOperator
implements Timeoutable,
Outputable {
    private static final long WAIT_SUBCOMPONENT_TIMEOUT = 60000L;
    private ComponentSearcher searcher;
    private Timeouts timeouts;
    private TestOut output;

    public ContainerOperator(Container b) {
        super(b);
        this.searcher = new ComponentSearcher(b);
        this.searcher.setOutput(TestOut.getNullOutput());
    }

    public ContainerOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((Container)cont.waitSubComponent(new ContainerFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public ContainerOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ContainerOperator(ContainerOperator cont, int index) {
        this((Container)ContainerOperator.waitComponent(cont, (ComponentChooser)new ContainerFinder(), index));
        this.copyEnvironment(cont);
    }

    public ContainerOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static Container findContainer(Container cont, ComponentChooser chooser, int index) {
        return (Container)ContainerOperator.findComponent(cont, new ContainerFinder(chooser), index);
    }

    public static Container findContainer(Container cont, ComponentChooser chooser) {
        return ContainerOperator.findContainer(cont, chooser, 0);
    }

    public static Container findContainer(Container cont, int index) {
        return ContainerOperator.findContainer(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th Container instance"), index);
    }

    public static Container findContainer(Container cont) {
        return ContainerOperator.findContainer(cont, 0);
    }

    public static Container findContainerUnder(Component comp, ComponentChooser chooser) {
        return new ComponentOperator(comp).getContainer(new ContainerFinder(chooser));
    }

    public static Container findContainerUnder(Component comp) {
        return ContainerOperator.findContainerUnder(comp, ComponentSearcher.getTrueChooser("Container"));
    }

    public static Container waitContainer(Container cont, ComponentChooser chooser, int index) {
        return (Container)ContainerOperator.waitComponent(cont, (ComponentChooser)new ContainerFinder(chooser), index);
    }

    public static Container waitContainer(Container cont, ComponentChooser chooser) {
        return ContainerOperator.waitContainer(cont, chooser, 0);
    }

    public static Container waitContainer(Container cont, int index) {
        return ContainerOperator.waitContainer(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th Container instance"), index);
    }

    public static Container waitContainer(Container cont) {
        return ContainerOperator.waitContainer(cont, 0);
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    public Component findSubComponent(ComponentChooser chooser, int index) {
        this.getOutput().printLine("Looking for \"" + chooser.getDescription() + "\" subcomponent");
        return this.searcher.findComponent(chooser, index);
    }

    public Component findSubComponent(ComponentChooser chooser) {
        return this.findSubComponent(chooser, 0);
    }

    public Component waitSubComponent(final ComponentChooser chooser, final int index) {
        this.getOutput().printLine("Waiting for \"" + chooser.getDescription() + "\" subcomponent");
        final ComponentSearcher searcher = new ComponentSearcher((Container)this.getSource());
        searcher.setOutput(this.getOutput().createErrorOutput());
        Waiter waiter = new Waiter(new Waitable(){

            @Override
            public Object actionProduced(Object obj) {
                return searcher.findComponent(chooser, index);
            }

            @Override
            public String getDescription() {
                return "Wait for \"" + chooser.getDescription() + "\" subcomponent to be displayed";
            }
        });
        waiter.setTimeoutsToCloneOf(this.getTimeouts(), "ComponentOperator.WaitComponentTimeout");
        waiter.setOutput(this.getOutput());
        try {
            return (Component)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting for \"" + chooser.getDescription() + "\" component has been interrupted", e);
        }
    }

    public Component waitSubComponent(ComponentChooser chooser) {
        return this.waitSubComponent(chooser, 0);
    }

    public ComponentOperator createSubOperator(ComponentChooser chooser, int index) {
        return ContainerOperator.createOperator(this.waitSubComponent(chooser, index));
    }

    public ComponentOperator createSubOperator(ComponentChooser chooser) {
        return this.createSubOperator(chooser, 0);
    }

    public Component add(final Component component) {
        return (Component)this.runMapping(new Operator.MapAction("add"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).add(component);
            }
        });
    }

    public Component add(final Component component, final int i) {
        return (Component)this.runMapping(new Operator.MapAction("add"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).add(component, i);
            }
        });
    }

    public void add(final Component component, final Object object) {
        this.runMapping(new Operator.MapVoidAction("add"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).add(component, object);
            }
        });
    }

    public void add(final Component component, final Object object, final int i) {
        this.runMapping(new Operator.MapVoidAction("add"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).add(component, object, i);
            }
        });
    }

    public Component add(final String string, final Component component) {
        return (Component)this.runMapping(new Operator.MapAction("add"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).add(string, component);
            }
        });
    }

    public void addContainerListener(final ContainerListener containerListener) {
        this.runMapping(new Operator.MapVoidAction("addContainerListener"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).addContainerListener(containerListener);
            }
        });
    }

    public Component findComponentAt(final int i, final int i1) {
        return (Component)this.runMapping(new Operator.MapAction("findComponentAt"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).findComponentAt(i, i1);
            }
        });
    }

    public Component findComponentAt(final Point point) {
        return (Component)this.runMapping(new Operator.MapAction("findComponentAt"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).findComponentAt(point);
            }
        });
    }

    public Component getComponent(final int i) {
        return (Component)this.runMapping(new Operator.MapAction("getComponent"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).getComponent(i);
            }
        });
    }

    public int getComponentCount() {
        return this.runMapping(new Operator.MapIntegerAction("getComponentCount"){

            @Override
            public int map() {
                return ((Container)ContainerOperator.this.getSource()).getComponentCount();
            }
        });
    }

    public Component[] getComponents() {
        return (Component[])this.runMapping(new Operator.MapAction("getComponents"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).getComponents();
            }
        });
    }

    public Insets getInsets() {
        return (Insets)this.runMapping(new Operator.MapAction("getInsets"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).getInsets();
            }
        });
    }

    public LayoutManager getLayout() {
        return (LayoutManager)this.runMapping(new Operator.MapAction("getLayout"){

            @Override
            public Object map() {
                return ((Container)ContainerOperator.this.getSource()).getLayout();
            }
        });
    }

    public boolean isAncestorOf(final Component component) {
        return this.runMapping(new Operator.MapBooleanAction("isAncestorOf"){

            @Override
            public boolean map() {
                return ((Container)ContainerOperator.this.getSource()).isAncestorOf(component);
            }
        });
    }

    public void paintComponents(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("paintComponents"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).paintComponents(graphics);
            }
        });
    }

    public void printComponents(final Graphics graphics) {
        this.runMapping(new Operator.MapVoidAction("printComponents"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).printComponents(graphics);
            }
        });
    }

    public void remove(final int i) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).remove(i);
            }
        });
    }

    public void remove(final Component component) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).remove(component);
            }
        });
    }

    public void removeAll() {
        this.runMapping(new Operator.MapVoidAction("removeAll"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).removeAll();
            }
        });
    }

    public void removeContainerListener(final ContainerListener containerListener) {
        this.runMapping(new Operator.MapVoidAction("removeContainerListener"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).removeContainerListener(containerListener);
            }
        });
    }

    public void setLayout(final LayoutManager layoutManager) {
        this.runMapping(new Operator.MapVoidAction("setLayout"){

            @Override
            public void map() {
                ((Container)ContainerOperator.this.getSource()).setLayout(layoutManager);
            }
        });
    }

    static {
        Timeouts.initDefault("ComponentOperator.WaitComponentTimeout", 60000L);
    }

    public static class ContainerFinder
    extends Operator.Finder {
        public ContainerFinder(ComponentChooser sf) {
            super(Container.class, sf);
        }

        public ContainerFinder() {
            super(Container.class);
        }
    }
}

