/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.CachedObject;
import org.keycloak.models.cache.infinispan.LazyModel;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedClient;
import org.keycloak.models.utils.RoleUtils;

public class ClientAdapter
implements ClientModel,
CachedObject {
    private final LazyModel<ClientModel> modelSupplier;
    protected RealmCacheSession cacheSession;
    protected RealmModel cachedRealm;
    protected ClientModel updated;
    protected CachedClient cached;
    protected boolean invalidated;

    public ClientAdapter(RealmModel cachedRealm, CachedClient cached, RealmCacheSession cacheSession) {
        this.cachedRealm = cachedRealm;
        this.cacheSession = cacheSession;
        this.cached = cached;
        this.modelSupplier = new LazyModel<ClientModel>(this::getClient);
    }

    private void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerClientInvalidation(this.cached.getId(), this.cached.getClientId(), this.cachedRealm.getId());
            this.updated = this.modelSupplier.get();
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getClientDelegate().getClientById(this.cachedRealm, this.cached.getId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    public void updateClient() {
        if (this.updated != null) {
            this.updated.updateClient();
        }
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public Set<String> getWebOrigins() {
        if (this.isUpdated()) {
            return this.updated.getWebOrigins();
        }
        return this.cached.getWebOrigins();
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.getDelegateForUpdate();
        this.updated.setWebOrigins(webOrigins);
    }

    public void addClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        this.cacheSession.addClientScopes(this.getRealm(), this, Collections.singleton(clientScope), defaultScope);
    }

    public void addClientScopes(Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        this.cacheSession.addClientScopes(this.getRealm(), this, clientScopes, defaultScope);
    }

    public void removeClientScope(ClientScopeModel clientScope) {
        this.cacheSession.removeClientScope(this.getRealm(), this, clientScope);
    }

    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope) {
        return this.cacheSession.getClientScopes(this.getRealm(), this, defaultScope);
    }

    public void addWebOrigin(String webOrigin) {
        this.getDelegateForUpdate();
        this.updated.addWebOrigin(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getDelegateForUpdate();
        this.updated.removeWebOrigin(webOrigin);
    }

    public Set<String> getRedirectUris() {
        if (this.isUpdated()) {
            return this.updated.getRedirectUris();
        }
        return this.cached.getRedirectUris();
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.getDelegateForUpdate();
        this.updated.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.getDelegateForUpdate();
        this.updated.addRedirectUri(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getDelegateForUpdate();
        this.updated.removeRedirectUri(redirectUri);
    }

    public boolean isEnabled() {
        if (this.isUpdated()) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public boolean isAlwaysDisplayInConsole() {
        if (this.isUpdated()) {
            return this.updated.isAlwaysDisplayInConsole();
        }
        return this.cached.isAlwaysDisplayInConsole();
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        this.getDelegateForUpdate();
        this.updated.setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public String getClientAuthenticatorType() {
        if (this.isUpdated()) {
            return this.updated.getClientAuthenticatorType();
        }
        return this.cached.getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.getDelegateForUpdate();
        this.updated.setClientAuthenticatorType(clientAuthenticatorType);
    }

    public boolean validateSecret(String secret) {
        return MessageDigest.isEqual(secret.getBytes(), this.getSecret().getBytes());
    }

    public String getSecret() {
        if (this.isUpdated()) {
            return this.updated.getSecret();
        }
        return this.cached.getSecret();
    }

    public void setSecret(String secret) {
        this.getDelegateForUpdate();
        this.updated.setSecret(secret);
    }

    public String getRegistrationToken() {
        if (this.isUpdated()) {
            return this.updated.getRegistrationToken();
        }
        return this.cached.getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationToken(registrationToken);
    }

    public boolean isPublicClient() {
        if (this.isUpdated()) {
            return this.updated.isPublicClient();
        }
        return this.cached.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getDelegateForUpdate();
        this.updated.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        if (this.isUpdated()) {
            return this.updated.isPublicClient();
        }
        return this.cached.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.getDelegateForUpdate();
        this.updated.setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        if (this.isUpdated()) {
            return this.updated.isFullScopeAllowed();
        }
        return this.cached.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getDelegateForUpdate();
        this.updated.setFullScopeAllowed(value);
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        if (this.isUpdated()) {
            return this.updated.getScopeMappingsStream();
        }
        return this.cached.getScope().stream().map(id -> this.cacheSession.getRoleById(this.cachedRealm, (String)id));
    }

    public void addScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.deleteScopeMapping(role);
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getScopeMappingsStream().filter(r -> RoleUtils.isRealmRole((RoleModel)r, (RealmModel)this.cachedRealm));
    }

    public RealmModel getRealm() {
        return this.cachedRealm;
    }

    public int getNotBefore() {
        if (this.isUpdated()) {
            return this.updated.getNotBefore();
        }
        return this.cached.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updated.setNotBefore(notBefore);
    }

    public String getProtocol() {
        if (this.isUpdated()) {
            return this.updated.getProtocol();
        }
        return this.cached.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getDelegateForUpdate();
        this.updated.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getAttribute(String name) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name);
        }
        return this.cached.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        if (this.isUpdated()) {
            return this.updated.getAttributes();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.cached.getAttributes());
        return copy;
    }

    public void setAuthenticationFlowBindingOverride(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setAuthenticationFlowBindingOverride(name, value);
    }

    public void removeAuthenticationFlowBindingOverride(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticationFlowBindingOverride(name);
    }

    public String getAuthenticationFlowBindingOverride(String name) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationFlowBindingOverride(name);
        }
        return this.cached.getAuthFlowBindings().get(name);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationFlowBindingOverrides();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.cached.getAuthFlowBindings());
        return copy;
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        if (this.isUpdated()) {
            return this.updated.getProtocolMappersStream();
        }
        return this.cached.getProtocolMappers(this.cacheSession.session, this.modelSupplier);
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addProtocolMapper(model);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeProtocolMapper(mapping);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateProtocolMapper(mapping);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return this.cached.getProtocolMapperById(this.cacheSession.session, this.modelSupplier, id);
    }

    public List<ProtocolMapperModel> getProtocolMapperByType(String type) {
        return this.cached.getProtocolMapperByType(this.cacheSession.session, this.modelSupplier, type);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return this.cached.getProtocolMapperByName(this.cacheSession.session, this.modelSupplier, protocol, name);
    }

    public String getClientId() {
        if (this.isUpdated()) {
            return this.updated.getClientId();
        }
        return this.cached.getClientId();
    }

    public void setClientId(String clientId) {
        this.getDelegateForUpdate();
        this.updated.setClientId(clientId);
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public boolean isSurrogateAuthRequired() {
        if (this.isUpdated()) {
            return this.updated.isSurrogateAuthRequired();
        }
        return this.cached.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.getDelegateForUpdate();
        this.updated.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        if (this.isUpdated()) {
            return this.updated.getManagementUrl();
        }
        return this.cached.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.getDelegateForUpdate();
        this.updated.setManagementUrl(url);
    }

    public String getRootUrl() {
        if (this.isUpdated()) {
            return this.updated.getRootUrl();
        }
        return this.cached.getRootUrl();
    }

    public void setRootUrl(String url) {
        this.getDelegateForUpdate();
        this.updated.setRootUrl(url);
    }

    public String getBaseUrl() {
        if (this.isUpdated()) {
            return this.updated.getBaseUrl();
        }
        return this.cached.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.getDelegateForUpdate();
        this.updated.setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        if (this.isUpdated()) {
            return this.updated.isBearerOnly();
        }
        return this.cached.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.getDelegateForUpdate();
        this.updated.setBearerOnly(only);
    }

    public boolean isConsentRequired() {
        if (this.isUpdated()) {
            return this.updated.isConsentRequired();
        }
        return this.cached.isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.getDelegateForUpdate();
        this.updated.setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        if (this.isUpdated()) {
            return this.updated.isStandardFlowEnabled();
        }
        return this.cached.isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.getDelegateForUpdate();
        this.updated.setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        if (this.isUpdated()) {
            return this.updated.isImplicitFlowEnabled();
        }
        return this.cached.isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.getDelegateForUpdate();
        this.updated.setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isDirectAccessGrantsEnabled();
        }
        return this.cached.isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.getDelegateForUpdate();
        this.updated.setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isServiceAccountsEnabled();
        }
        return this.cached.isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.getDelegateForUpdate();
        this.updated.setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public RoleModel getRole(String name) {
        return this.cacheSession.getClientRole(this, name);
    }

    public RoleModel addRole(String name) {
        return this.cacheSession.addClientRole(this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.cacheSession.addClientRole(this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.cacheSession.removeRole(role);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.cacheSession.getClientRolesStream(this);
    }

    public Stream<RoleModel> getRolesStream(Integer first, Integer max) {
        return this.cacheSession.getClientRolesStream(this, first, max);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.cacheSession.searchForClientRolesStream(this, search, first, max);
    }

    public int getNodeReRegistrationTimeout() {
        if (this.isUpdated()) {
            return this.updated.getNodeReRegistrationTimeout();
        }
        return this.cached.getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.getDelegateForUpdate();
        this.updated.setNodeReRegistrationTimeout(timeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        if (this.isUpdated()) {
            return this.updated.getRegisteredNodes();
        }
        return this.cached.getRegisteredNodes();
    }

    public void registerNode(String nodeHost, int registrationTime) {
        this.getDelegateForUpdate();
        this.updated.registerNode(nodeHost, registrationTime);
    }

    public void unregisterNode(String nodeHost) {
        this.getDelegateForUpdate();
        this.updated.unregisterNode(nodeHost);
    }

    public boolean hasDirectScope(RoleModel role) {
        if (this.isUpdated()) {
            return this.updated.hasDirectScope(role);
        }
        if (this.cached.getScope().contains(role.getId())) {
            return true;
        }
        return this.getRolesStream().anyMatch(r -> Objects.equals(r, role));
    }

    public boolean hasScope(RoleModel role) {
        if (this.isUpdated()) {
            return this.updated.hasScope(role);
        }
        if (this.cached.isFullScopeAllowed() || this.cached.getScope().contains(role.getId())) {
            return true;
        }
        if (RoleUtils.hasRole(this.getScopeMappingsStream(), (RoleModel)role)) {
            return true;
        }
        return RoleUtils.hasRole(this.getRolesStream(), (RoleModel)role);
    }

    private ClientModel getClient() {
        return this.cacheSession.getClientDelegate().getClientById(this.cachedRealm, this.cached.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getClientId(), System.identityHashCode(this));
    }
}

