/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;

public class RemoteHostAttribute
implements ExchangeAttribute {
    public static final String REMOTE_HOST_NAME_SHORT = "%h";
    public static final String REMOTE_HOST = "%{REMOTE_HOST}";
    public static final ExchangeAttribute INSTANCE = new RemoteHostAttribute();

    private RemoteHostAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        SocketAddress remoteAddr = exchange.request().remoteAddress();
        if (remoteAddr == null) {
            return null;
        }
        return remoteAddr.host();
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote host", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote host";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteHostAttribute.REMOTE_HOST) || token.equals(RemoteHostAttribute.REMOTE_HOST_NAME_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

