/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.Objects;

public final class ConstructorDescImpl
implements ConstructorDesc {
    private final ClassDesc owner;
    private final MethodTypeDesc type;
    private final int hashCode;

    public ConstructorDescImpl(ClassDesc owner, MethodTypeDesc type) {
        if (!ConstantDescs.CD_void.equals(type.returnType())) {
            throw new IllegalArgumentException("Constructor descriptor must have a return type of void");
        }
        this.owner = owner;
        this.type = type;
        this.hashCode = Objects.hash(owner, "<init>", type);
    }

    @Override
    public ClassDesc owner() {
        return this.owner;
    }

    @Override
    public String name() {
        return "<init>";
    }

    @Override
    public MethodTypeDesc type() {
        return this.type;
    }

    public boolean equals(Object obj) {
        ConstructorDescImpl other;
        return obj instanceof ConstructorDescImpl && this.equals(other = (ConstructorDescImpl)obj);
    }

    public boolean equals(ConstructorDescImpl other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.owner.equals(other.owner) && this.type.equals(other.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append("Constructor[");
        Util.descName(b, this.owner);
        b.append("#<init>");
        b.append(this.type.descriptorString());
        return b.append(']');
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

