/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.SamlSecureClientUrisExecutor;

public class SamlSecureClientUrisExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "saml-secure-client-uris";

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new SamlSecureClientUrisExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Executor that enforces all URLs defined in the SAML client are https (TLS enabled). It also enforces that wildcard redirect URIs are not used (configurable).";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("allow-wildcard-redirects").type("boolean").label("Allow wildcard valid redirect URIs").helpText("Whether wildcard valid redirect URIs are allowed to be configured in the client.").add().build();
    }
}

