/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.keycloak.Token;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.models.DefaultActionTokenKey;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectValueModel;
import org.keycloak.services.Urls;

public class DefaultActionToken
extends DefaultActionTokenKey
implements SingleUseObjectValueModel {
    public static final String JSON_FIELD_AUTHENTICATION_SESSION_ID = "asid";
    public static final String JSON_FIELD_EMAIL = "eml";
    @JsonProperty(value="asid")
    private String compoundAuthenticationSessionId;
    @JsonProperty(value="eml")
    private String email;
    public static final TokenVerifier.Predicate<DefaultActionTokenKey> ACTION_TOKEN_BASIC_CHECKS = t -> {
        if (t.getActionVerificationNonce() == null) {
            throw new VerificationException("Nonce not present.");
        }
        return true;
    };

    public DefaultActionToken() {
        super(null, null, 0, null);
    }

    protected DefaultActionToken(String userId, String actionId, int absoluteExpirationInSecs, UUID actionVerificationNonce) {
        super(userId, actionId, absoluteExpirationInSecs, actionVerificationNonce);
    }

    protected DefaultActionToken(String userId, String actionId, int absoluteExpirationInSecs, UUID actionVerificationNonce, String compoundAuthenticationSessionId) {
        super(userId, actionId, absoluteExpirationInSecs, actionVerificationNonce);
        this.setCompoundAuthenticationSessionId(compoundAuthenticationSessionId);
    }

    public String getCompoundAuthenticationSessionId() {
        return this.compoundAuthenticationSessionId;
    }

    public void setCompoundAuthenticationSessionId(String compoundAuthenticationSessionId) {
        this.compoundAuthenticationSessionId = compoundAuthenticationSessionId;
    }

    @JsonIgnore
    public Map<String, String> getNotes() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.getCompoundAuthenticationSessionId() != null) {
            res.put(JSON_FIELD_AUTHENTICATION_SESSION_ID, this.getCompoundAuthenticationSessionId());
        }
        return res;
    }

    public String getNote(String name) {
        Object res = this.getOtherClaims().get(name);
        return res instanceof String ? (String)res : null;
    }

    public final String setNote(String name, String value) {
        Object res = value == null ? this.getOtherClaims().remove(name) : this.getOtherClaims().put(name, value);
        return res instanceof String ? (String)res : null;
    }

    public final String removeNote(String name) {
        Object res = this.getOtherClaims().remove(name);
        return res instanceof String ? (String)res : null;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public String serialize(KeycloakSession session, RealmModel realm, UriInfo uri) {
        String issuerUri = DefaultActionToken.getIssuer(realm, uri);
        this.issuedNow().id(UUID.randomUUID().toString()).issuer(issuerUri).audience(new String[]{issuerUri});
        return session.tokens().encode((Token)this);
    }

    private static String getIssuer(RealmModel realm, UriInfo uri) {
        return Urls.realmIssuer(uri.getBaseUri(), realm.getName());
    }
}

