/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.spi;

import java.sql.SQLException;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.NullnessUtil;

public class TemplatedViolatedConstraintNameExtractor
implements ViolatedConstraintNameExtractor {
    private final Function<SQLException, String> extractConstraintName;

    public TemplatedViolatedConstraintNameExtractor(Function<SQLException, String> extractConstraintName) {
        this.extractConstraintName = extractConstraintName;
    }

    @Override
    public @Nullable String extractConstraintName(SQLException sqle) {
        try {
            String constraintName = null;
            do {
                constraintName = this.extractConstraintName.apply(sqle);
                if (sqle.getNextException() == null || sqle.getNextException() == sqle) break;
                sqle = NullnessUtil.castNonNull(sqle.getNextException());
            } while (constraintName == null);
            return constraintName;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static @Nullable String extractUsingTemplate(String templateStart, String templateEnd, String message) {
        int end;
        int templateStartPosition = message.indexOf(templateStart);
        if (templateStartPosition < 0) {
            return null;
        }
        int start = templateStartPosition + templateStart.length();
        int n = end = templateEnd.equals("\n") ? -1 : message.indexOf(templateEnd, start);
        if (end < 0) {
            end = message.length();
        }
        return message.substring(start, end);
    }
}

