/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.hibernate.boot.model.naming.Identifier;

public class NamingHelper {
    public static final NamingHelper INSTANCE = new NamingHelper();
    private final String charset;
    private static final int[] S = new int[]{7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21};
    private static final int[] K = new int[64];

    public static NamingHelper withCharset(String charset) {
        return new NamingHelper(charset);
    }

    public NamingHelper() {
        this(null);
    }

    private NamingHelper(String charset) {
        this.charset = charset;
    }

    public String generateHashedFkName(String prefix, Identifier tableName, Identifier referencedTableName, List<Identifier> columnNames) {
        return this.generateHashedFkName(prefix, tableName, referencedTableName, columnNames == null || columnNames.isEmpty() ? new Identifier[]{} : columnNames.toArray(new Identifier[0]));
    }

    public String generateHashedFkName(String prefix, Identifier tableName, Identifier referencedTableName, Identifier ... columnNames) {
        StringBuilder text = new StringBuilder().append("table`").append(tableName).append("`").append("references`").append(referencedTableName).append("`");
        Identifier[] alphabeticalColumns = (Identifier[])columnNames.clone();
        Arrays.sort(alphabeticalColumns, Comparator.comparing(Identifier::getCanonicalName));
        for (Identifier columnName : alphabeticalColumns) {
            assert (columnName != null);
            text.append("column`").append(columnName).append("`");
        }
        return prefix + this.hashedName(text.toString());
    }

    public String generateHashedConstraintName(String prefix, Identifier tableName, Identifier ... columnNames) {
        StringBuilder text = new StringBuilder("table`" + String.valueOf(tableName) + "`");
        Identifier[] alphabeticalColumns = (Identifier[])columnNames.clone();
        Arrays.sort(alphabeticalColumns, Comparator.comparing(Identifier::getCanonicalName));
        for (Identifier columnName : alphabeticalColumns) {
            assert (columnName != null);
            text.append("column`").append(columnName).append("`");
        }
        return prefix + this.hashedName(text.toString());
    }

    public String generateHashedConstraintName(String prefix, Identifier tableName, List<Identifier> columnNames) {
        Identifier[] columnNamesArray = new Identifier[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            columnNamesArray[i] = columnNames.get(i);
        }
        return this.generateHashedConstraintName(prefix, tableName, columnNamesArray);
    }

    public String hashedName(String name) {
        byte[] bytes;
        try {
            bytes = this.charset == null ? name.getBytes() : name.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException(uee);
        }
        byte[] digest = NamingHelper.hash(NamingHelper.pad(bytes));
        return new BigInteger(1, digest).toString(35);
    }

    public static byte[] hash(byte[] message) {
        int a0 = 1732584193;
        int b0 = -271733879;
        int c0 = -1732584194;
        int d0 = 271733878;
        for (int i = 0; i < message.length / 64; ++i) {
            int[] M = new int[16];
            for (int j = 0; j < 16; ++j) {
                M[j] = message[i * 64 + j * 4] & 0xFF | (message[i * 64 + j * 4 + 1] & 0xFF) << 8 | (message[i * 64 + j * 4 + 2] & 0xFF) << 16 | (message[i * 64 + j * 4 + 3] & 0xFF) << 24;
            }
            int A = a0;
            int B = b0;
            int C = c0;
            int D = d0;
            for (int j = 0; j < 64; ++j) {
                int g;
                int F;
                if (j < 16) {
                    F = B & C | ~B & D;
                    g = j;
                } else if (j < 32) {
                    F = D & B | ~D & C;
                    g = (5 * j + 1) % 16;
                } else if (j < 48) {
                    F = B ^ C ^ D;
                    g = (3 * j + 5) % 16;
                } else {
                    F = C ^ (B | ~D);
                    g = 7 * j % 16;
                }
                int temp = D;
                D = C;
                C = B;
                B += Integer.rotateLeft(A + F + K[j] + M[g], S[j]);
                A = temp;
            }
            a0 += A;
            b0 += B;
            c0 += C;
            d0 += D;
        }
        byte[] digest = new byte[16];
        NamingHelper.encodeInt(digest, 0, a0);
        NamingHelper.encodeInt(digest, 4, b0);
        NamingHelper.encodeInt(digest, 8, c0);
        NamingHelper.encodeInt(digest, 12, d0);
        return digest;
    }

    private static void encodeInt(byte[] output, int offset, int value) {
        output[offset] = (byte)(value & 0xFF);
        output[offset + 1] = (byte)(value >>> 8 & 0xFF);
        output[offset + 2] = (byte)(value >>> 16 & 0xFF);
        output[offset + 3] = (byte)(value >>> 24 & 0xFF);
    }

    private static byte[] pad(byte[] input) {
        int originalLength = input.length;
        int numPaddingBytes = (56 - (originalLength + 1) % 64 + 64) % 64;
        byte[] padded = new byte[originalLength + 1 + numPaddingBytes + 8];
        System.arraycopy(input, 0, padded, 0, originalLength);
        padded[originalLength] = -128;
        long bitLength = (long)originalLength * 8L;
        for (int i = 0; i < 8; ++i) {
            padded[padded.length - 8 + i] = (byte)(bitLength >>> 8 * i & 0xFFL);
        }
        return padded;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            NamingHelper.K[i] = (int)(4.294967296E9 * Math.abs(Math.sin(i + 1)));
        }
    }
}

