/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.time.Duration;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.policy.AgePasswordPolicyProviderFactory;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class AgePasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordGenericMessage";
    public static final Logger logger = Logger.getLogger(AgePasswordPolicyProvider.class);
    private final KeycloakSession session;

    public AgePasswordPolicyProvider(KeycloakSession session) {
        this.session = session;
    }

    public PolicyError validate(String user, String password) {
        return null;
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        PasswordPolicy policy = this.session.getContext().getRealm().getPasswordPolicy();
        int passwordAgePolicyValue = (Integer)policy.getPolicyConfig("passwordAge");
        if (passwordAgePolicyValue != -1) {
            if (user.credentialManager().getStoredCredentialsByTypeStream("password").map(PasswordCredentialModel::createFromCredentialModel).anyMatch(passwordCredential -> {
                PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, passwordCredential.getPasswordCredentialData().getAlgorithm());
                return hash != null && hash.verify(password, passwordCredential);
            })) {
                return new PolicyError(ERROR_MESSAGE, new Object[]{passwordAgePolicyValue});
            }
            long passwordMaxAgeMillis = Time.currentTimeMillis() - Duration.ofDays(passwordAgePolicyValue).toMillis();
            if (passwordAgePolicyValue > 0 && user.credentialManager().getStoredCredentialsByTypeStream("password-history").filter(credentialModel -> credentialModel.getCreatedDate() > passwordMaxAgeMillis).map(PasswordCredentialModel::createFromCredentialModel).anyMatch(passwordCredential -> {
                PasswordHashProvider hash = (PasswordHashProvider)this.session.getProvider(PasswordHashProvider.class, passwordCredential.getPasswordCredentialData().getAlgorithm());
                return hash.verify(password, passwordCredential);
            })) {
                return new PolicyError(ERROR_MESSAGE, new Object[]{passwordAgePolicyValue});
            }
        }
        return null;
    }

    public Object parseConfig(String value) {
        return this.parseInteger(value, AgePasswordPolicyProviderFactory.DEFAULT_AGE_DAYS);
    }

    public void close() {
    }
}

