/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.kawa.format.Printable;
import gnu.lists.Consumer;
import gnu.lists.Pair;
import gnu.mapping.CallContext;
import gnu.mapping.Procedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class Macro
extends Syntax
implements Printable,
Externalizable {
    public Object expander;
    Object instance;
    public static final int HYGIENIC = 1;
    public static final int SKIP_SCAN_FORM = 2;
    private int flags = 1;
    ScopeExp capturedScope;

    public final void setFlags(int flags) {
        this.flags = flags;
    }

    public final boolean isHygienic() {
        return (this.flags & 1) != 0;
    }

    public final void setHygienic(boolean hygienic) {
        this.flags = hygienic ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public ScopeExp getCapturedScope() {
        if (this.capturedScope == null) {
            if (this.instance instanceof ModuleExp) {
                this.capturedScope = (ModuleExp)this.instance;
            } else if (this.instance instanceof Class) {
                this.capturedScope = ModuleManager.findWithClass((Class)this.instance).getModuleExp();
            } else if (this.instance != null) {
                this.capturedScope = ModuleInfo.findFromInstance(this.instance).getModuleExp();
            }
        }
        return this.capturedScope;
    }

    public void setCapturedScope(ScopeExp scope) {
        this.capturedScope = scope;
    }

    public static Macro make(Declaration decl) {
        Macro mac = new Macro(decl.getSymbol());
        decl.setSyntax();
        mac.capturedScope = decl.context;
        return mac;
    }

    public static Macro makeNonHygienic(Object name, Procedure expander) {
        Macro mac = new Macro(name, expander);
        mac.setHygienic(false);
        return mac;
    }

    public static Macro makeNonHygienic(Object name, Procedure expander, Object instance) {
        Macro mac = new Macro(name, expander);
        mac.setHygienic(false);
        mac.instance = instance;
        return mac;
    }

    public static Macro makeSkipScanForm(Object name, Procedure expander, Object instance) {
        Macro mac = new Macro(name, expander);
        mac.flags = 3;
        mac.instance = instance;
        return mac;
    }

    public static Macro make(Object name, Procedure expander) {
        return new Macro(name, expander);
    }

    public static Macro make(Object name, Procedure expander, Object instance) {
        Macro mac = new Macro(name, expander);
        mac.instance = instance;
        return mac;
    }

    public Macro() {
    }

    public Macro(Macro old) {
        this.name = old.name;
        this.expander = old.expander;
        this.flags = old.flags;
    }

    public Macro(Object name, Procedure expander) {
        super(name);
        this.expander = expander instanceof Expression ? expander : new QuoteExp(expander);
    }

    public Macro(Object name) {
        super(name);
    }

    @Override
    public Expression rewriteForm(Pair form, Translator tr) {
        return tr.rewrite(this.expand(form, tr), 'N');
    }

    public String toString() {
        return "#<macro " + this.getName() + ">";
    }

    @Override
    public void print(Consumer out) {
        out.write("#<macro ");
        out.write(this.getName());
        out.write(62);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object rewriteIfNeeded() {
        Object exp = this.expander;
        if (exp instanceof LangExp) {
            Expression rule;
            Object[] lval = (Object[])((LangExp)exp).getLangValue();
            Object p = lval[0];
            Translator xtr = (Translator)lval[1];
            ScopeExp scope = (ScopeExp)lval[2];
            Macro savedMacro = xtr.currentMacroDefinition;
            Compilation savedComp = Compilation.getCurrent();
            xtr.currentMacroDefinition = this;
            Compilation.setCurrent(xtr);
            ScopeExp savedScope = xtr.setPushCurrentScope(scope);
            try {
                rule = xtr.rewrite_car((Pair)p, false);
            }
            finally {
                xtr.setPopCurrentScope(savedScope);
                xtr.currentMacroDefinition = savedMacro;
                Compilation.setCurrent(savedComp);
            }
            if (rule instanceof LambdaExp) {
                ((LambdaExp)rule).setFlag(256);
            }
            this.expander = exp = rule;
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object expand(Object form, Translator tr) {
        Object savedMacroMark = tr.currentMacroMark;
        tr.currentMacroMark = new Object();
        try {
            Object result;
            Procedure pr;
            Object exp = this.expander;
            if (exp instanceof Procedure && !(exp instanceof Expression)) {
                pr = (Procedure)exp;
            } else {
                exp = this.rewriteIfNeeded();
                if (!(exp instanceof Expression)) {
                    Macro savedMacro = tr.currentMacroDefinition;
                    tr.currentMacroDefinition = this;
                    try {
                        this.expander = exp = tr.rewrite(exp);
                    }
                    finally {
                        tr.currentMacroDefinition = savedMacro;
                    }
                }
                pr = (Procedure)((Expression)exp).eval(tr.getGlobalEnvironment());
            }
            if (!this.isHygienic()) {
                int nargs = Translator.listLength(form = Quote.quote(form, tr)) - 1;
                if (nargs < 0) {
                    ErrorExp errorExp = tr.syntaxError("invalid macro argument list to " + String.valueOf(this));
                    return errorExp;
                }
                CallContext ctx = CallContext.getInstance();
                ctx.setupApply(pr);
                form = ((Pair)form).getCdr();
                for (int i = 0; i < nargs; ++i) {
                    Pair pair = (Pair)form;
                    Object arg = pair.getCar();
                    if (arg instanceof Keyword && i + 1 < nargs) {
                        String key = ((Keyword)arg).getName();
                        pair = (Pair)pair.getCdr();
                        ctx.addKey(key, pair.getCar());
                        ++i;
                    } else {
                        ctx.add(arg);
                    }
                    form = pair.getCdr();
                }
                result = ctx.runUntilValue();
            } else {
                result = pr.apply1(form);
            }
            Object object2 = result;
            return object2;
        }
        catch (Throwable ex) {
            String msg = "evaluating syntax transformer '" + this.getName() + "' threw " + String.valueOf(ex);
            tr.getMessages().error('e', msg, ex);
            ErrorExp errorExp = new ErrorExp(msg);
            return errorExp;
        }
        finally {
            tr.currentMacroMark = savedMacroMark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanForm(Pair st, ScopeExp defs, Translator tr) {
        if ((this.flags & 2) != 0) {
            super.scanForm(st, defs, tr);
            return;
        }
        Syntax saveSyntax = tr.currentSyntax;
        try {
            tr.currentSyntax = this;
            Object x = this.expand(st, tr);
            tr.scanForm(x, defs);
        }
        finally {
            tr.currentSyntax = saveSyntax;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getName());
        out.writeObject(((QuoteExp)this.expander).getValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setName((String)in.readObject());
        this.expander = new QuoteExp(in.readObject());
    }
}

