/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.cbutil.CBArray;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class Special {
    private static Logger log = Logger.getLogger(Special.class.getName());

    private Special() {
    }

    public static DXAttributes getAdditionSet(RDN newRDN, Attributes oldSet, Attributes newSet) throws NamingException {
        DXAttributes changes = new DXAttributes();
        NamingEnumeration<? extends Attribute> testAtts = newSet.getAll();
        while (testAtts.hasMore()) {
            DXAttribute adds;
            Attribute testVal = testAtts.next();
            Attribute oldVal = oldSet.get(testVal.getID());
            if (Special.emptyAtt(testVal)) continue;
            if (oldVal == null) {
                changes.put(testVal);
                continue;
            }
            if (Special.emptyAtt(oldVal)) {
                changes.put(testVal);
                continue;
            }
            if (Special.attributesEqual(oldVal, testVal) || (adds = Special.getDiff(oldVal, testVal)) == null) continue;
            changes.put(adds);
        }
        return changes;
    }

    public static DXAttribute getDiff(Attribute baseAtt, Attribute changeAtt) {
        try {
            NamingEnumeration<?> changeVals = changeAtt.getAll();
            DXNamingEnumeration baseVals = new DXNamingEnumeration(baseAtt.getAll());
            DXAttribute mods = new DXAttribute(baseAtt.getID());
            while (changeVals.hasMoreElements()) {
                Object o = changeVals.nextElement();
                if (baseVals.contains(o)) continue;
                mods.add(o);
            }
            return mods.size() > 0 ? mods : null;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unexpected Error in Special.java: ", e);
            return null;
        }
    }

    public static DXAttributes getReplacementSet(RDN newRDN, Attributes oldSet, Attributes newSet) throws NamingException {
        DXAttributes changes = new DXAttributes();
        NamingEnumeration<? extends Attribute> testAtts = newSet.getAll();
        while (testAtts.hasMore()) {
            Attribute testAtt = testAtts.next();
            String ID2 = testAtt.getID();
            Attribute oldAtt = oldSet.get(ID2);
            if (newRDN != null && newRDN.contains(ID2)) {
                String namingValue = newRDN.getRawVal(ID2);
                if (oldAtt != null) {
                    testAtt = new DXAttribute(testAtt);
                    oldAtt = new DXAttribute(oldAtt);
                    testAtt.remove(namingValue);
                    oldAtt.remove(namingValue);
                    System.out.println("and finally we end up with: \n new: " + testAtt.toString() + "\n old: " + oldAtt.toString());
                }
            }
            if (!Special.attributesEqual(oldAtt, testAtt) || Special.emptyAtt(testAtt)) continue;
            changes.put(testAtt);
        }
        return changes;
    }

    public static DXAttributes getDeletionSet(RDN newRDN, Attributes oldSet, Attributes newSet) throws NamingException {
        DXAttributes changes = new DXAttributes();
        NamingEnumeration<? extends Attribute> oldAtts = oldSet.getAll();
        while (oldAtts.hasMore()) {
            Attribute oldAtt = oldAtts.next();
            Object val = oldAtt.get();
            if ("".equals(val)) {
                val = null;
            }
            if (val == null) continue;
            String ID2 = oldAtt.getID();
            if (newRDN != null && newRDN.contains(ID2)) continue;
            Attribute newAtt = newSet.get(ID2);
            if (newAtt != null && Special.emptyAtt(newAtt)) {
                newAtt = null;
            }
            if (newAtt == null) {
                changes.put(new DXAttribute(oldAtt.getID(), null));
                continue;
            }
            if (Special.attributesEqual(newAtt, oldAtt)) continue;
            changes.put(Special.getDiff(newAtt, oldAtt));
        }
        return changes;
    }

    public static boolean emptyAtt(Attribute att) {
        return DXAttribute.isEmpty(att);
    }

    private static boolean attributesEqual(Attribute a, Attribute b) throws NamingException {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() == 0 && b.size() == 0) {
            return true;
        }
        if (a.size() == 0 || b.size() == 0) {
            return false;
        }
        if (a.get() == null && b.get() == null) {
            return true;
        }
        if (a.get() == null || b.get() == null) {
            return false;
        }
        if (!a.getID().equals(b.getID())) {
            return false;
        }
        try {
            Object[] A = CBArray.enumerationToArray(a.getAll());
            Object[] B = CBArray.enumerationToArray(b.getAll());
            return CBArray.isUnorderedEqual(A, B);
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Naming Exception testing attributes " + a.getID() + " & " + b.getID() + " in DXAttributes:attributesEqual()", e);
            return false;
        }
    }
}

