/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.config.PropertiesProvider;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalOptions {
    private static final String PROXY_PORT_DEFAULT = "80";
    @Nullable
    private String dsn;
    @Nullable
    private String environment;
    @Nullable
    private String release;
    @Nullable
    private String dist;
    @Nullable
    private String serverName;
    @Nullable
    private Boolean enableUncaughtExceptionHandler;
    @Nullable
    private Boolean debug;
    @Nullable
    private Boolean enableDeduplication;
    @Nullable
    private Boolean enableTracing;
    @Nullable
    private Double tracesSampleRate;
    @Nullable
    private Double profilesSampleRate;
    @Nullable
    private SentryOptions.RequestSize maxRequestBodySize;
    @NotNull
    private final @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    @Nullable
    private SentryOptions.Proxy proxy;
    @NotNull
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    @Nullable
    private List<String> tracePropagationTargets = null;
    @NotNull
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    @Nullable
    private String proguardUuid;
    @Nullable
    private Long idleTimeout;
    @NotNull
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    @Nullable
    private Boolean printUncaughtStackTrace;
    @Nullable
    private Boolean sendClientReports;
    @NotNull
    private Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    @Nullable
    private Boolean enabled;
    @Nullable
    private Boolean enablePrettySerializationOutput;
    @Nullable
    private List<String> ignoredCheckIns;
    @Nullable
    private Boolean sendModules;
    @Nullable
    private Boolean enableBackpressureHandling;
    @Nullable
    private SentryOptions.Cron cron;

    @NotNull
    public static ExternalOptions from(@NotNull PropertiesProvider propertiesProvider, @NotNull ILogger logger) {
        ExternalOptions options2 = new ExternalOptions();
        options2.setDsn(propertiesProvider.getProperty("dsn"));
        options2.setEnvironment(propertiesProvider.getProperty("environment"));
        options2.setRelease(propertiesProvider.getProperty("release"));
        options2.setDist(propertiesProvider.getProperty("dist"));
        options2.setServerName(propertiesProvider.getProperty("servername"));
        options2.setEnableUncaughtExceptionHandler(propertiesProvider.getBooleanProperty("uncaught.handler.enabled"));
        options2.setPrintUncaughtStackTrace(propertiesProvider.getBooleanProperty("uncaught.handler.print-stacktrace"));
        options2.setEnableTracing(propertiesProvider.getBooleanProperty("enable-tracing"));
        options2.setTracesSampleRate(propertiesProvider.getDoubleProperty("traces-sample-rate"));
        options2.setProfilesSampleRate(propertiesProvider.getDoubleProperty("profiles-sample-rate"));
        options2.setDebug(propertiesProvider.getBooleanProperty("debug"));
        options2.setEnableDeduplication(propertiesProvider.getBooleanProperty("enable-deduplication"));
        options2.setSendClientReports(propertiesProvider.getBooleanProperty("send-client-reports"));
        String maxRequestBodySize = propertiesProvider.getProperty("max-request-body-size");
        if (maxRequestBodySize != null) {
            options2.setMaxRequestBodySize(SentryOptions.RequestSize.valueOf(maxRequestBodySize.toUpperCase(Locale.ROOT)));
        }
        Map<String, String> tags = propertiesProvider.getMap("tags");
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            options2.setTag(tag.getKey(), tag.getValue());
        }
        String proxyHost = propertiesProvider.getProperty("proxy.host");
        String proxyUser = propertiesProvider.getProperty("proxy.user");
        String proxyPass = propertiesProvider.getProperty("proxy.pass");
        String proxyPort = propertiesProvider.getProperty("proxy.port", PROXY_PORT_DEFAULT);
        if (proxyHost != null) {
            options2.setProxy(new SentryOptions.Proxy(proxyHost, proxyPort, proxyUser, proxyPass));
        }
        for (String string : propertiesProvider.getList("in-app-includes")) {
            options2.addInAppInclude(string);
        }
        for (String string : propertiesProvider.getList("in-app-excludes")) {
            options2.addInAppExclude(string);
        }
        List<String> tracePropagationTargets = null;
        if (propertiesProvider.getProperty("trace-propagation-targets") != null) {
            tracePropagationTargets = propertiesProvider.getList("trace-propagation-targets");
        }
        if (tracePropagationTargets == null && propertiesProvider.getProperty("tracing-origins") != null) {
            tracePropagationTargets = propertiesProvider.getList("tracing-origins");
        }
        if (tracePropagationTargets != null) {
            for (String tracePropagationTarget : tracePropagationTargets) {
                options2.addTracePropagationTarget(tracePropagationTarget);
            }
        }
        for (String contextTag : propertiesProvider.getList("context-tags")) {
            options2.addContextTag(contextTag);
        }
        options2.setProguardUuid(propertiesProvider.getProperty("proguard-uuid"));
        for (String bundleId : propertiesProvider.getList("bundle-ids")) {
            options2.addBundleId(bundleId);
        }
        options2.setIdleTimeout(propertiesProvider.getLongProperty("idle-timeout"));
        options2.setEnabled(propertiesProvider.getBooleanProperty("enabled"));
        options2.setEnablePrettySerializationOutput(propertiesProvider.getBooleanProperty("enable-pretty-serialization-output"));
        options2.setSendModules(propertiesProvider.getBooleanProperty("send-modules"));
        options2.setIgnoredCheckIns(propertiesProvider.getList("ignored-checkins"));
        options2.setEnableBackpressureHandling(propertiesProvider.getBooleanProperty("enable-backpressure-handling"));
        for (String ignoredExceptionType : propertiesProvider.getList("ignored-exceptions-for-type")) {
            try {
                Class<?> clazz = Class.forName(ignoredExceptionType);
                if (Throwable.class.isAssignableFrom(clazz)) {
                    options2.addIgnoredExceptionForType(clazz);
                    continue;
                }
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s does not extend Throwable", ignoredExceptionType, ignoredExceptionType);
            }
            catch (ClassNotFoundException e) {
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s class is not found", ignoredExceptionType, ignoredExceptionType);
            }
        }
        Long l = propertiesProvider.getLongProperty("cron.default-checkin-margin");
        Long cronDefaultMaxRuntime = propertiesProvider.getLongProperty("cron.default-max-runtime");
        String cronDefaultTimezone = propertiesProvider.getProperty("cron.default-timezone");
        Long cronDefaultFailureIssueThreshold = propertiesProvider.getLongProperty("cron.default-failure-issue-threshold");
        Long cronDefaultRecoveryThreshold = propertiesProvider.getLongProperty("cron.default-recovery-threshold");
        if (l != null || cronDefaultMaxRuntime != null || cronDefaultTimezone != null || cronDefaultFailureIssueThreshold != null || cronDefaultRecoveryThreshold != null) {
            SentryOptions.Cron cron = new SentryOptions.Cron();
            cron.setDefaultCheckinMargin(l);
            cron.setDefaultMaxRuntime(cronDefaultMaxRuntime);
            cron.setDefaultTimezone(cronDefaultTimezone);
            cron.setDefaultFailureIssueThreshold(cronDefaultFailureIssueThreshold);
            cron.setDefaultRecoveryThreshold(cronDefaultRecoveryThreshold);
            options2.setCron(cron);
        }
        return options2;
    }

    @Nullable
    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(@Nullable String dsn) {
        this.dsn = dsn;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    @Nullable
    public Boolean getEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public void setEnableUncaughtExceptionHandler(@Nullable Boolean enableUncaughtExceptionHandler) {
        this.enableUncaughtExceptionHandler = enableUncaughtExceptionHandler;
    }

    @Deprecated
    @Nullable
    public List<String> getTracingOrigins() {
        return this.tracePropagationTargets;
    }

    @Nullable
    public List<String> getTracePropagationTargets() {
        return this.tracePropagationTargets;
    }

    @Nullable
    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(@Nullable Boolean debug) {
        this.debug = debug;
    }

    @Nullable
    public Boolean getEnableDeduplication() {
        return this.enableDeduplication;
    }

    public void setEnableDeduplication(@Nullable Boolean enableDeduplication) {
        this.enableDeduplication = enableDeduplication;
    }

    @Nullable
    public Boolean getEnableTracing() {
        return this.enableTracing;
    }

    public void setEnableTracing(@Nullable Boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    @Nullable
    public Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    public void setTracesSampleRate(@Nullable Double tracesSampleRate) {
        this.tracesSampleRate = tracesSampleRate;
    }

    @Nullable
    public Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    public void setProfilesSampleRate(@Nullable Double profilesSampleRate) {
        this.profilesSampleRate = profilesSampleRate;
    }

    @Nullable
    public SentryOptions.RequestSize getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public void setMaxRequestBodySize(@Nullable SentryOptions.RequestSize maxRequestBodySize) {
        this.maxRequestBodySize = maxRequestBodySize;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Nullable
    public SentryOptions.Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable SentryOptions.Proxy proxy) {
        this.proxy = proxy;
    }

    @NotNull
    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    @NotNull
    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    @NotNull
    public List<String> getContextTags() {
        return this.contextTags;
    }

    @Nullable
    public String getProguardUuid() {
        return this.proguardUuid;
    }

    public void setProguardUuid(@Nullable String proguardUuid) {
        this.proguardUuid = proguardUuid;
    }

    @NotNull
    public Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    public void addInAppInclude(@NotNull String include) {
        this.inAppIncludes.add(include);
    }

    public void addInAppExclude(@NotNull String exclude) {
        this.inAppExcludes.add(exclude);
    }

    @Deprecated
    public void addTracingOrigin(@NotNull String tracingOrigin) {
        this.addTracePropagationTarget(tracingOrigin);
    }

    public void addTracePropagationTarget(@NotNull String tracePropagationTarget) {
        if (this.tracePropagationTargets == null) {
            this.tracePropagationTargets = new CopyOnWriteArrayList<String>();
        }
        if (!tracePropagationTarget.isEmpty()) {
            this.tracePropagationTargets.add(tracePropagationTarget);
        }
    }

    public void addContextTag(@NotNull String contextTag) {
        this.contextTags.add(contextTag);
    }

    public void addIgnoredExceptionForType(@NotNull Class<? extends Throwable> exceptionType) {
        this.ignoredExceptionsForType.add(exceptionType);
    }

    public void setTag(@NotNull String key, @NotNull String value2) {
        this.tags.put(key, value2);
    }

    @Nullable
    public Boolean getPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    public void setPrintUncaughtStackTrace(@Nullable Boolean printUncaughtStackTrace) {
        this.printUncaughtStackTrace = printUncaughtStackTrace;
    }

    @Nullable
    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(@Nullable Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Nullable
    public Boolean getSendClientReports() {
        return this.sendClientReports;
    }

    public void setSendClientReports(@Nullable Boolean sendClientReports) {
        this.sendClientReports = sendClientReports;
    }

    @NotNull
    public Set<String> getBundleIds() {
        return this.bundleIds;
    }

    public void addBundleId(@NotNull String bundleId) {
        this.bundleIds.add(bundleId);
    }

    @Nullable
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(@Nullable Boolean enabled2) {
        this.enabled = enabled2;
    }

    @Nullable
    public Boolean isEnablePrettySerializationOutput() {
        return this.enablePrettySerializationOutput;
    }

    public void setEnablePrettySerializationOutput(@Nullable Boolean enablePrettySerializationOutput) {
        this.enablePrettySerializationOutput = enablePrettySerializationOutput;
    }

    @Nullable
    public Boolean isSendModules() {
        return this.sendModules;
    }

    public void setSendModules(@Nullable Boolean sendModules) {
        this.sendModules = sendModules;
    }

    @ApiStatus.Experimental
    public void setIgnoredCheckIns(@Nullable List<String> ignoredCheckIns) {
        this.ignoredCheckIns = ignoredCheckIns;
    }

    @ApiStatus.Experimental
    @Nullable
    public List<String> getIgnoredCheckIns() {
        return this.ignoredCheckIns;
    }

    @ApiStatus.Experimental
    public void setEnableBackpressureHandling(@Nullable Boolean enableBackpressureHandling) {
        this.enableBackpressureHandling = enableBackpressureHandling;
    }

    @ApiStatus.Experimental
    @Nullable
    public Boolean isEnableBackpressureHandling() {
        return this.enableBackpressureHandling;
    }

    @ApiStatus.Experimental
    @Nullable
    public SentryOptions.Cron getCron() {
        return this.cron;
    }

    @ApiStatus.Experimental
    public void setCron(@Nullable SentryOptions.Cron cron) {
        this.cron = cron;
    }
}

