/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;

public class SelectFromMavenProjectsDialog
extends DialogWrapper {
    private final SimpleTree myTree;
    private final NodeSelector mySelector;

    public SelectFromMavenProjectsDialog(Project project, @NlsContexts.DialogTitle String title, MavenProjectsStructure.MavenStructureDisplayMode displayMode) {
        this(project, title, displayMode, null);
    }

    public SelectFromMavenProjectsDialog(Project project, @NlsContexts.DialogTitle String title, MavenProjectsStructure.MavenStructureDisplayMode displayMode, @Nullable NodeSelector selector) {
        super(project, false);
        this.mySelector = selector;
        this.setTitle(title);
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(1);
        MavenProjectsStructure treeStructure = new MavenProjectsStructure(project, displayMode, MavenProjectsManager.getInstance(project), MavenTasksManager.getInstance(project), MavenShortcutsManager.getInstance(project), MavenProjectsNavigator.getInstance(project), this.myTree);
        treeStructure.update();
        if (this.mySelector != null) {
            final SimpleNode[] selection = new SimpleNode[]{null};
            treeStructure.accept(new TreeVisitor(){

                @NotNull
                public TreeVisitor.Action visit(@NotNull TreePath path) {
                    SimpleNode node;
                    if (path == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!SelectFromMavenProjectsDialog.this.mySelector.shouldSelect(node = (SimpleNode)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject())) {
                        TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                        if (action == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return action;
                    }
                    selection[0] = node;
                    TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                    if (action == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return action;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/idea/maven/navigator/SelectFromMavenProjectsDialog$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/idea/maven/navigator/SelectFromMavenProjectsDialog$1";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            });
            if (selection[0] != null) {
                treeStructure.select(selection[0]);
            }
        }
        this.init();
    }

    protected SimpleNode getSelectedNode() {
        return this.myTree.getNodeFor(this.myTree.getSelectionPath());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane.setPreferredSize((Dimension)JBUI.size((int)320, (int)400));
        return pane;
    }

    protected static interface NodeSelector {
        public boolean shouldSelect(SimpleNode var1);
    }
}

