/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.application.options.codeStyle.properties.ValueListPropertyAccessor;
import com.intellij.application.options.codeStyle.properties.VisualGuidesAccessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.extended.EditorConfigIntellijNameUtil;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.editorconfig.language.extensions.EditorConfigOptionDescriptorProvider;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.EditorConfigMutableDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigConstantDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigListDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigNumberDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigOptionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigStringDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigUnionDescriptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/editorconfig/configmanagement/extended/IntellijConfigOptionDescriptorProvider;", "Lorg/editorconfig/language/extensions/EditorConfigOptionDescriptorProvider;", "<init>", "()V", "getOptionDescriptors", "", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigOptionDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "requiresFullSupport", "", "getAllOptions", "getEditorConfigNames", "", "mapper", "Lcom/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper;", "property", "createValueDescriptor", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "createListDescriptor", "childDescriptor", "canBeEmpty", "choicesToDescriptorList", "list", "Lcom/intellij/application/options/codeStyle/properties/CodeStyleChoiceList;", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nIntellijConfigOptionDescriptorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijConfigOptionDescriptorProvider.kt\norg/editorconfig/configmanagement/extended/IntellijConfigOptionDescriptorProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1563#2:93\n1634#2,3:94\n*S KotlinDebug\n*F\n+ 1 IntellijConfigOptionDescriptorProvider.kt\norg/editorconfig/configmanagement/extended/IntellijConfigOptionDescriptorProvider\n*L\n90#1:93\n90#1:94,3\n*E\n"})
public final class IntellijConfigOptionDescriptorProvider
implements EditorConfigOptionDescriptorProvider {
    @Override
    @NotNull
    public List<EditorConfigOptionDescriptor> getOptionDescriptors(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return !Utils.INSTANCE.isFullIntellijSettingsSupport() ? CollectionsKt.emptyList() : this.getAllOptions();
    }

    @Override
    public boolean requiresFullSupport() {
        return Utils.INSTANCE.isFullIntellijSettingsSupport();
    }

    private final List<EditorConfigOptionDescriptor> getAllOptions() {
        List list;
        List $this$getAllOptions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CodeStylePropertiesUtil.collectMappers((CodeStyleSettings)CodeStyle.getDefaultSettings(), arg_0 -> IntellijConfigOptionDescriptorProvider.getAllOptions$lambda$0$1(arg_0 -> IntellijConfigOptionDescriptorProvider.getAllOptions$lambda$0$0($this$getAllOptions_u24lambda_u240, arg_0), arg_0));
        List mappers = CollectionsKt.build((List)list);
        List $this$getAllOptions_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        for (AbstractCodeStylePropertyMapper mapper : mappers) {
            for (String property : mapper.enumProperties()) {
                EditorConfigDescriptor valueDescriptor;
                Intrinsics.checkNotNull((Object)mapper);
                Intrinsics.checkNotNull((Object)property);
                List<String> ecNames = this.getEditorConfigNames(mapper, property);
                if (ecNames.isEmpty() || (valueDescriptor = this.createValueDescriptor(property, mapper)) == null) continue;
                for (String ecName : ecNames) {
                    EditorConfigOptionDescriptor descriptor = new EditorConfigOptionDescriptor(new EditorConfigConstantDescriptor(ecName, mapper.getPropertyDescription(property), null), valueDescriptor, null, null);
                    $this$getAllOptions_u24lambda_u241.add(descriptor);
                }
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final List<String> getEditorConfigNames(AbstractCodeStylePropertyMapper mapper, String property) {
        if (EditorConfigIntellijNameUtil.isIndentProperty(property) && !(mapper instanceof GeneralCodeStylePropertyMapper)) {
            return CollectionsKt.listOf((Object)EditorConfigIntellijNameUtil.getLanguageProperty(mapper, property));
        }
        if (IntellijPropertyKindMap.getPropertyKind(property) == EditorConfigPropertyKind.EDITOR_CONFIG_STANDARD) {
            return CollectionsKt.emptyList();
        }
        List<String> list = EditorConfigIntellijNameUtil.toEditorConfigNames(mapper, property);
        Intrinsics.checkNotNullExpressionValue(list, (String)"toEditorConfigNames(...)");
        return list;
    }

    private final EditorConfigDescriptor createValueDescriptor(String property, AbstractCodeStylePropertyMapper mapper) {
        CodeStylePropertyAccessor accessor = mapper.getAccessor(property);
        return accessor instanceof CodeStyleChoiceList ? (EditorConfigDescriptor)new EditorConfigUnionDescriptor(this.choicesToDescriptorList((CodeStyleChoiceList)accessor), null, null) : (accessor instanceof IntegerAccessor ? (EditorConfigDescriptor)new EditorConfigNumberDescriptor(null, null) : (accessor instanceof ValueListPropertyAccessor ? this.createListDescriptor(new EditorConfigStringDescriptor(null, null, "(^(?!none).*|.{4}.+)"), ((ValueListPropertyAccessor)accessor).isEmptyListAllowed()) : (accessor instanceof ExternalStringAccessor ? (EditorConfigDescriptor)new EditorConfigStringDescriptor(null, null, ".*") : (accessor instanceof VisualGuidesAccessor ? this.createListDescriptor(new EditorConfigNumberDescriptor(null, null), true) : null))));
    }

    private final EditorConfigDescriptor createListDescriptor(EditorConfigDescriptor childDescriptor, boolean canBeEmpty) {
        EditorConfigDescriptor editorConfigDescriptor;
        EditorConfigListDescriptor listDescriptor = new EditorConfigListDescriptor(0, true, CollectionsKt.listOf((Object)childDescriptor), null, null);
        if (canBeEmpty) {
            Object[] objectArray = new EditorConfigMutableDescriptor[]{listDescriptor, new EditorConfigConstantDescriptor("none", null, null)};
            editorConfigDescriptor = new EditorConfigUnionDescriptor(CollectionsKt.listOf((Object[])objectArray), null, null);
        } else {
            editorConfigDescriptor = listDescriptor;
        }
        return editorConfigDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final List<EditorConfigDescriptor> choicesToDescriptorList(CodeStyleChoiceList list) {
        void $this$mapTo$iv$iv;
        List list2 = list.getChoices();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChoices(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new EditorConfigConstantDescriptor((String)it, null, null));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit getAllOptions$lambda$0$0(List $this_buildList, AbstractCodeStylePropertyMapper it) {
        $this_buildList.add(it);
        return Unit.INSTANCE;
    }

    private static final void getAllOptions$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

