/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.enterprise;

import ca.sqlpower.architect.SnapshotCollection;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.architect.enterprise.DomainCategorySnapshot;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.sqlobject.SPObjectSnapshotUpdateListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.sqlobject.UserDefinedSQLTypeSnapshot;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SPObjectSnapshotHierarchyListener
extends AbstractSPListener {
    private static final Logger logger = Logger.getLogger(SPObjectSnapshotHierarchyListener.class);
    private final ArchitectClientSideSession session;
    private int transactionCount = 0;
    private Map<UserDefinedSQLType, PropertyChangeEvent> upstreamTypeChangeEventMap = new HashMap<UserDefinedSQLType, PropertyChangeEvent>();
    private final Map<UserDefinedSQLType, Integer> typesToCleanup = new HashMap<UserDefinedSQLType, Integer>();
    private boolean settingSnapshot = false;
    private final Map<SPObjectSnapshot<?>, SPObjectSnapshotUpdateListener> listenerMap = new HashMap();

    public SPObjectSnapshotHierarchyListener(ArchitectClientSideSession session) {
        this.session = session;
    }

    public void childAdded(SPChildEvent e) {
        if (e.getChild() instanceof SQLTable) {
            SQLTable table = (SQLTable)e.getChild();
            table.addSPListener((SPListener)this);
            for (SQLColumn sqlColumn : table.getChildren(SQLColumn.class)) {
                UserDefinedSQLType upstreamType = sqlColumn.getUserDefinedSQLType().getUpstreamType();
                if (upstreamType != null) {
                    this.reassignType(sqlColumn);
                }
                sqlColumn.getUserDefinedSQLType().addSPListener((SPListener)this);
            }
        } else if (e.getChild() instanceof SQLColumn) {
            SQLColumn sqlColumn = (SQLColumn)e.getChild();
            UserDefinedSQLType upstreamType = sqlColumn.getUserDefinedSQLType().getUpstreamType();
            if (this.session.getWorkspace().getSnapshotCollection().isMagicEnabled() && upstreamType != null) {
                List udtSnapshots = this.session.getWorkspace().getSnapshotCollection().getChildren(UserDefinedSQLTypeSnapshot.class);
                boolean isSnapshot = false;
                for (UserDefinedSQLTypeSnapshot snapshot : udtSnapshots) {
                    if (!upstreamType.equals((Object)snapshot.getSPObject())) continue;
                    isSnapshot = true;
                    snapshot.setSnapshotUseCount(snapshot.getSnapshotUseCount() + 1);
                    if (this.listenerMap.get(snapshot) != null) break;
                    this.addUpdateListener(upstreamType);
                    break;
                }
                if (!isSnapshot && (upstreamType.getParent() == null || upstreamType.getParent() instanceof SnapshotCollection && !upstreamType.getParent().equals((Object)this.session.getWorkspace().getSnapshotCollection()) || upstreamType.getParent() instanceof DomainCategory && upstreamType.getParent().getParent() instanceof SnapshotCollection && !upstreamType.getParent().getParent().equals((Object)this.session.getWorkspace().getSnapshotCollection()))) {
                    this.reassignType(sqlColumn);
                    isSnapshot = true;
                }
                if (!isSnapshot) {
                    UserDefinedSQLType columnProxyType = sqlColumn.getUserDefinedSQLType();
                    SPObjectSnapshotHierarchyListener.createSPObjectSnapshot(columnProxyType, upstreamType, this.session.getWorkspace().getSnapshotCollection(), this);
                    this.addUpdateListener(columnProxyType.getUpstreamType());
                }
            }
            sqlColumn.getUserDefinedSQLType().addSPListener((SPListener)this);
        }
    }

    public void childRemoved(SPChildEvent e) {
        if (e.getChild() instanceof SQLTable) {
            e.getChild().removeSPListener((SPListener)this);
            for (SQLColumn col : e.getChild().getChildren(SQLColumn.class)) {
                col.getUserDefinedSQLType().removeSPListener((SPListener)this);
                if (!this.session.getWorkspace().getSnapshotCollection().isMagicEnabled() || !col.getUserDefinedSQLType().isMagicEnabled()) continue;
                UserDefinedSQLType snapshotType = col.getUserDefinedSQLType().getUpstreamType();
                Integer cleanupCount = this.typesToCleanup.get(snapshotType);
                if (cleanupCount == null) {
                    cleanupCount = 0;
                }
                this.typesToCleanup.put(snapshotType, cleanupCount + 1);
            }
        } else if (e.getChild() instanceof SQLColumn) {
            UserDefinedSQLType colType = ((SQLColumn)e.getChild()).getUserDefinedSQLType();
            colType.removeSPListener((SPListener)this);
            if (this.session.getWorkspace().getSnapshotCollection().isMagicEnabled() && colType.isMagicEnabled()) {
                UserDefinedSQLType snapshotType = colType.getUpstreamType();
                Integer cleanupCount = this.typesToCleanup.get(snapshotType);
                if (cleanupCount == null) {
                    cleanupCount = 0;
                }
                this.typesToCleanup.put(snapshotType, cleanupCount + 1);
            }
        }
    }

    public void propertyChanged(PropertyChangeEvent e) {
        if (e.getSource() instanceof UserDefinedSQLType && e.getPropertyName().equals("upstreamType")) {
            Object oldValue = this.upstreamTypeChangeEventMap.containsKey(e.getSource()) ? this.upstreamTypeChangeEventMap.get(e.getSource()).getOldValue() : e.getOldValue();
            this.upstreamTypeChangeEventMap.put((UserDefinedSQLType)e.getSource(), new PropertyChangeEvent(e.getSource(), e.getPropertyName(), oldValue, e.getNewValue()));
        }
    }

    private void cleanupSnapshot(UserDefinedSQLType typeRemoved) {
        SnapshotCollection collection = this.session.getWorkspace().getSnapshotCollection();
        if (typeRemoved.getParent() == this.session.getSystemWorkspace() || typeRemoved.getParent() instanceof DomainCategory && typeRemoved.getParent().getParent() == this.session.getSystemWorkspace()) {
            return;
        }
        UserDefinedSQLTypeSnapshot udtSnapshot = null;
        for (SPObjectSnapshot<?> snapshot : collection.getSPObjectSnapshots()) {
            if (!snapshot.getSPObject().equals(typeRemoved)) continue;
            udtSnapshot = (UserDefinedSQLTypeSnapshot)snapshot;
            udtSnapshot.setSnapshotUseCount(udtSnapshot.getSnapshotUseCount() - 1);
            if (udtSnapshot.getSnapshotUseCount() <= 0) break;
            return;
        }
        if (udtSnapshot == null) {
            throw new NullPointerException("The type " + typeRemoved + " is a snapshot type but does not have a snapshot object in the project.");
        }
        collection.removeSPObjectSnapshot((SPObjectSnapshot<?>)udtSnapshot);
        SPObjectSnapshot<?> categorySnapshot = null;
        try {
            if (udtSnapshot.isDomainSnapshot()) {
                DomainCategory cat = (DomainCategory)udtSnapshot.getSPObject().getParent();
                cat.removeChild((SPObject)udtSnapshot.getSPObject());
                if (udtSnapshot.getSPObject().getUpstreamType().getUpstreamType() != null) {
                    throw new IllegalStateException("We currently do not support having a domain reference an upstream type of a domain.");
                }
                this.cleanupSnapshot(udtSnapshot.getSPObject().getUpstreamType());
                for (SPObjectSnapshot<?> snapshot : collection.getSPObjectSnapshots()) {
                    if (!snapshot.getSPObject().equals((Object)cat)) continue;
                    categorySnapshot = snapshot;
                    break;
                }
                if (cat.getChildren().size() == 0) {
                    collection.removeChild((SPObject)categorySnapshot);
                    collection.removeChild((SPObject)cat);
                }
            } else if (udtSnapshot.getSPObject().isMagicEnabled()) {
                collection.removeChild((SPObject)udtSnapshot.getSPObject());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        UserDefinedSQLType systemType = this.session.findSystemTypeFromSnapshot((SPObjectSnapshot<?>)udtSnapshot);
        if (systemType != null) {
            SQLPowerUtils.unlistenToHierarchy((SPObject)systemType, (SPListener)((SPListener)this.listenerMap.get(udtSnapshot)));
        } else if (categorySnapshot != null) {
            UserDefinedSQLType systemCategory = this.session.findSystemTypeFromSnapshot(categorySnapshot);
            if (systemCategory != null) {
                SQLPowerUtils.unlistenToHierarchy((SPObject)systemCategory, (SPListener)((SPListener)this.listenerMap.get(udtSnapshot)));
            } else {
                SQLPowerUtils.unlistenToHierarchy((SPObject)this.session.getSystemWorkspace(), (SPListener)((SPListener)this.listenerMap.get(udtSnapshot)));
            }
        } else {
            SQLPowerUtils.unlistenToHierarchy((SPObject)this.session.getSystemWorkspace(), (SPListener)((SPListener)this.listenerMap.get(udtSnapshot)));
        }
    }

    private void addUpdateListener(UserDefinedSQLType upstreamSnapshotType) {
        if (upstreamSnapshotType == null) {
            return;
        }
        SnapshotCollection collection = this.session.getWorkspace().getSnapshotCollection();
        SPObject upstreamTypeParent = upstreamSnapshotType.getParent();
        if (upstreamTypeParent == null || upstreamTypeParent.equals((Object)collection) || upstreamTypeParent instanceof DomainCategory && upstreamTypeParent.getParent().equals((Object)collection)) {
            UserDefinedSQLType systemType;
            SPObjectSnapshot<?> snapshot = null;
            for (SPObjectSnapshot<?> workspaceSnapshot : collection.getSPObjectSnapshots()) {
                if (workspaceSnapshot.getSPObject() != upstreamSnapshotType) continue;
                snapshot = workspaceSnapshot;
                break;
            }
            if ((systemType = this.session.findSystemTypeFromSnapshot(snapshot)) != null) {
                SPObjectSnapshotUpdateListener udtSnapshotListener = new SPObjectSnapshotUpdateListener(snapshot);
                SQLPowerUtils.listenToHierarchy((SPObject)systemType, (SPListener)udtSnapshotListener);
                this.listenerMap.put(snapshot, udtSnapshotListener);
                if (systemType.getParent() instanceof DomainCategory) {
                    DomainCategory category = (DomainCategory)systemType.getParent();
                    for (SPObjectSnapshot<?> categorySnapshot : collection.getSPObjectSnapshots()) {
                        if (!categorySnapshot.getOriginalUUID().equals(category.getUUID())) continue;
                        SPObjectSnapshotUpdateListener categorySnapshotListener = new SPObjectSnapshotUpdateListener(categorySnapshot);
                        category.addSPListener((SPListener)categorySnapshotListener);
                        this.listenerMap.put(categorySnapshot, categorySnapshotListener);
                        break;
                    }
                }
            }
        }
    }

    public static void createSPObjectSnapshot(UserDefinedSQLType typeProxy, UserDefinedSQLType upstreamType, SnapshotCollection collection, SPObjectSnapshotHierarchyListener updateListener) {
        if (!collection.isMagicEnabled() || !typeProxy.isMagicEnabled()) {
            return;
        }
        SPObject upstreamTypeParent = upstreamType.getParent();
        if (!(upstreamTypeParent == null || upstreamTypeParent.equals((Object)collection) || upstreamTypeParent instanceof DomainCategory && upstreamTypeParent.getParent().equals((Object)collection))) {
            UserDefinedSQLTypeSnapshot snapshot;
            boolean snapshotExists = SPObjectSnapshotHierarchyListener.setUpstreamTypeToExistingSnapshot(typeProxy, upstreamType, collection);
            if (snapshotExists) {
                return;
            }
            boolean isDomainSnapshot = upstreamTypeParent instanceof DomainCategory;
            if (upstreamType.getUpstreamType() != null) {
                UserDefinedSQLType upUpStreamType = upstreamType.getUpstreamType();
                boolean isUpstreamDomainSnapshot = upUpStreamType.getParent() instanceof DomainCategory;
                if (isUpstreamDomainSnapshot) {
                    throw new IllegalStateException("We currently don't handle domains that have an upstream type of another domain.");
                }
                UserDefinedSQLTypeSnapshot upstreamSnapshot = null;
                boolean existingSnapshotFound = false;
                for (SPObjectSnapshot<?> workspaceSnapshot : collection.getSPObjectSnapshots()) {
                    if (!workspaceSnapshot.getOriginalUUID().equals(upUpStreamType.getUUID()) || !(workspaceSnapshot instanceof UserDefinedSQLTypeSnapshot)) continue;
                    upstreamSnapshot = (UserDefinedSQLTypeSnapshot)workspaceSnapshot;
                    upstreamSnapshot.setSnapshotUseCount(upstreamSnapshot.getSnapshotUseCount() + 1);
                    existingSnapshotFound = true;
                    break;
                }
                if (!existingSnapshotFound) {
                    upstreamSnapshot = new UserDefinedSQLTypeSnapshot(upUpStreamType, isUpstreamDomainSnapshot);
                    collection.addChild((SPObject)upstreamSnapshot, 0);
                    collection.addChild((SPObject)upstreamSnapshot.getSPObject(), 0);
                    upstreamSnapshot.setSnapshotUseCount(1);
                    if (updateListener != null) {
                        updateListener.addUpdateListener(upstreamSnapshot.getSPObject());
                    }
                }
                snapshot = new UserDefinedSQLTypeSnapshot(upstreamType, isDomainSnapshot, upstreamSnapshot);
            } else {
                snapshot = new UserDefinedSQLTypeSnapshot(upstreamType, isDomainSnapshot);
            }
            collection.addChild((SPObject)snapshot, 0);
            if (upstreamType.getParent() instanceof DomainCategory) {
                DomainCategory parent = (DomainCategory)upstreamType.getParent();
                DomainCategorySnapshot domainSnapshot = new DomainCategorySnapshot(parent);
                collection.addChild((SPObject)domainSnapshot, 0);
                collection.addChild((SPObject)domainSnapshot.getSPObject(), 0);
                domainSnapshot.getSPObject().addChild((SPObject)snapshot.getSPObject(), 0);
            } else {
                collection.addChild((SPObject)snapshot.getSPObject(), 0);
            }
            typeProxy.setUpstreamType(snapshot.getSPObject());
            snapshot.setSnapshotUseCount(1);
        } else if (upstreamTypeParent != null && (upstreamTypeParent.equals((Object)collection) || upstreamTypeParent instanceof DomainCategory && upstreamTypeParent.getParent().equals((Object)collection))) {
            for (SPObjectSnapshot<?> snapshot : collection.getSPObjectSnapshots()) {
                if (!snapshot.getSPObject().equals(upstreamType)) continue;
                UserDefinedSQLTypeSnapshot udtSnapshot = (UserDefinedSQLTypeSnapshot)snapshot;
                udtSnapshot.setSnapshotUseCount(udtSnapshot.getSnapshotUseCount() + 1);
                return;
            }
        }
    }

    private static boolean setUpstreamTypeToExistingSnapshot(UserDefinedSQLType typeProxy, UserDefinedSQLType upstreamType, SnapshotCollection collection) {
        boolean snapshotExists = false;
        List typeSnapshots = collection.getChildren(UserDefinedSQLTypeSnapshot.class);
        for (UserDefinedSQLTypeSnapshot typeSnapshot : typeSnapshots) {
            if (typeSnapshot.isDomainSnapshot() && !(upstreamType.getParent() instanceof DomainCategory) || !upstreamType.getUUID().equals(typeSnapshot.getOriginalUUID())) continue;
            typeProxy.setUpstreamType(typeSnapshot.getSPObject());
            typeSnapshot.setSnapshotUseCount(typeSnapshot.getSnapshotUseCount() + 1);
            snapshotExists = true;
            break;
        }
        return snapshotExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionStarted(TransactionEvent e) {
        if (this.settingSnapshot) {
            logger.debug((Object)"Ignoring begin");
            return;
        }
        logger.debug((Object)("Processing begin (\"" + e.getMessage() + "\")"));
        ++this.transactionCount;
        logger.debug((Object)("Incremented transaction counter to " + this.transactionCount));
        if (this.transactionCount == 1) {
            logger.debug((Object)"Firing snapshot begin");
            try {
                this.settingSnapshot = true;
                ((SPObject)e.getSource()).begin("setting upstream type (snapshot)");
            }
            finally {
                this.settingSnapshot = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnded(TransactionEvent e) {
        if (this.settingSnapshot) {
            logger.debug((Object)"Ignoring commit");
            return;
        }
        logger.debug((Object)("Processing commit (\"" + e.getMessage() + "\")"));
        --this.transactionCount;
        logger.debug((Object)("Decremented transaction counter to " + this.transactionCount));
        if (this.transactionCount == 0) {
            try {
                this.settingSnapshot = true;
                for (Map.Entry<UserDefinedSQLType, PropertyChangeEvent> entry : this.upstreamTypeChangeEventMap.entrySet()) {
                    UserDefinedSQLType newValue = (UserDefinedSQLType)entry.getValue().getNewValue();
                    UserDefinedSQLType source = entry.getKey();
                    UserDefinedSQLType oldValue = (UserDefinedSQLType)entry.getValue().getOldValue();
                    logger.debug((Object)"Replacing upstreamType with snapshot!");
                    SPObjectSnapshotHierarchyListener.createSPObjectSnapshot(source, newValue, this.session.getWorkspace().getSnapshotCollection(), this);
                    if (oldValue != null && this.session.getWorkspace().getSnapshotCollection().isMagicEnabled() && source.isMagicEnabled()) {
                        this.cleanupSnapshot(oldValue);
                    }
                    UserDefinedSQLType columnProxyType = source;
                    this.addUpdateListener(columnProxyType.getUpstreamType());
                }
                this.upstreamTypeChangeEventMap.clear();
                ((SPObject)e.getSource()).commit("snapshot commit");
                logger.debug((Object)"Firing snapshot commit");
            }
            finally {
                this.settingSnapshot = false;
            }
            for (Map.Entry<UserDefinedSQLType, Serializable> entry : this.typesToCleanup.entrySet()) {
                for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                    this.cleanupSnapshot(entry.getKey());
                }
            }
            this.typesToCleanup.clear();
        }
    }

    private void reassignType(SQLColumn column) {
        List snapshots;
        if (!this.session.getWorkspace().getSnapshotCollection().isMagicEnabled()) {
            return;
        }
        UserDefinedSQLType upstreamType = column.getUserDefinedSQLType().getUpstreamType();
        SPObject upstreamTypeParent = upstreamType.getParent();
        UserDefinedSQLTypeSnapshot sourceSnapshot = null;
        DomainCategorySnapshot sourceCategorySnapshot = null;
        String originalUUID = null;
        String originalCategoryUUID = null;
        if (upstreamTypeParent == null) {
            originalUUID = upstreamType.getUUID();
        } else if (upstreamTypeParent instanceof SnapshotCollection) {
            snapshots = upstreamTypeParent.getChildren(UserDefinedSQLTypeSnapshot.class);
            for (UserDefinedSQLTypeSnapshot snapshot : snapshots) {
                if (!upstreamType.equals((Object)snapshot.getSPObject())) continue;
                originalUUID = snapshot.getOriginalUUID();
                sourceSnapshot = snapshot;
                break;
            }
        } else if (upstreamTypeParent instanceof DomainCategory) {
            snapshots = upstreamTypeParent.getParent().getChildren(SPObjectSnapshot.class);
            for (UserDefinedSQLTypeSnapshot snapshot : snapshots) {
                if (upstreamType.equals((Object)snapshot.getSPObject())) {
                    originalUUID = snapshot.getOriginalUUID();
                    sourceSnapshot = snapshot;
                } else if (upstreamTypeParent.equals(snapshot.getSPObject())) {
                    originalCategoryUUID = upstreamTypeParent.getUUID();
                    sourceCategorySnapshot = (DomainCategorySnapshot)snapshot;
                }
                if (sourceSnapshot == null || sourceCategorySnapshot == null) continue;
                break;
            }
        }
        if (originalUUID == null) {
            throw new IllegalStateException("Could not find the UUID of the original type of snapshot '" + upstreamType.getUUID() + "'");
        }
        for (UserDefinedSQLTypeSnapshot snapshot : this.session.getWorkspace().getSnapshotCollection().getChildren(UserDefinedSQLTypeSnapshot.class)) {
            if (!snapshot.getOriginalUUID().equals(originalUUID)) continue;
            column.getUserDefinedSQLType().setUpstreamType(snapshot.getSPObject());
            snapshot.setSnapshotUseCount(snapshot.getSnapshotUseCount() + 1);
            return;
        }
        SnapshotCollection snapshotCollection = this.session.getWorkspace().getSnapshotCollection();
        DomainCategory newCategory = null;
        if (upstreamType.getParent() instanceof DomainCategory) {
            DomainCategory upstreamCategory = (DomainCategory)upstreamType.getParent();
            newCategory = new DomainCategory(upstreamCategory.getName());
            DomainCategorySnapshot categorySnapshot = new DomainCategorySnapshot(newCategory, originalUUID);
            categorySnapshot.setName(sourceCategorySnapshot.getName());
            snapshotCollection.addSPObjectSnapshot((SPObjectSnapshot<?>)categorySnapshot, 0);
            snapshotCollection.addCategorySnapshot(newCategory, 0);
        }
        UserDefinedSQLType newType = new UserDefinedSQLType();
        UserDefinedSQLType.copyProperties((UserDefinedSQLType)newType, (UserDefinedSQLType)upstreamType);
        UserDefinedSQLTypeSnapshot newSnapshot = new UserDefinedSQLTypeSnapshot(newType, originalUUID, sourceSnapshot == null ? false : sourceSnapshot.isDomainSnapshot());
        newSnapshot.setName(sourceSnapshot.getName());
        snapshotCollection.addSPObjectSnapshot((SPObjectSnapshot<?>)newSnapshot, 0);
        if (newCategory != null) {
            newCategory.addChild((SPObject)newType, 0);
        } else {
            snapshotCollection.addUDTSnapshot(newType, 0);
        }
        column.getUserDefinedSQLType().setUpstreamType(newType);
        newSnapshot.setSnapshotUseCount(newSnapshot.getSnapshotUseCount() + 1);
    }
}

