/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.regexeval.Messages;
import org.pentaho.di.trans.steps.regexeval.RegexEvalData;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;

public class RegexEval
extends BaseStep
implements StepInterface {
    private RegexEvalMeta meta;
    private RegexEvalData data;

    public RegexEval(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block20: {
            this.meta = (RegexEvalMeta)smi;
            this.data = (RegexEvalData)sdi;
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                int n = this.data.nrExtraFields = this.meta.isAllowCaptureGroupsFlagSet() ? this.meta.getFieldName().length : 0;
                if (this.meta.getMatcher() != null) {
                    if (this.data.indexOfFieldToEvaluate < 0) {
                        this.data.indexOfFieldToEvaluate = this.data.previousRowMeta.indexOfValue(this.meta.getMatcher());
                        this.data.indexOfMatchResultField = this.data.outputRowMeta.indexOfValue(this.meta.getResultFieldName());
                        if (this.data.nrExtraFields > 0) {
                            this.data.indexOfFirstCaptureGroupField = this.data.outputRowMeta.indexOfValue(this.meta.getFieldName()[0]);
                        }
                        if (this.data.indexOfFieldToEvaluate < 0) {
                            this.logError(Messages.getString("RegexEval.Log.ErrorFindingField") + "[" + this.meta.getMatcher() + "]");
                            throw new KettleStepException(Messages.getString("RegexEval.Exception.CouldnotFindField", this.meta.getMatcher()));
                        }
                        if (this.environmentSubstitute(this.meta.getResultFieldName()) == null) {
                            this.logError(Messages.getString("RegexEval.Log.ErrorResultFieldMissing"));
                            throw new KettleStepException(Messages.getString("RegexEval.Exception.ErrorResultFieldMissing"));
                        }
                    }
                } else {
                    this.log.logError("Error", Messages.getString("RegexEval.Log.ErrorMatcherMissing"), new Object[0]);
                    throw new KettleStepException(Messages.getString("RegexEval.Exception.ErrorMatcherMissing"));
                }
                this.data.conversionRowMeta = this.data.outputRowMeta.clone();
                for (ValueMetaInterface valueMeta : this.data.conversionRowMeta.getValueMetaList()) {
                    valueMeta.setType(2);
                }
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.previousRowMeta.size(); ++i) {
                outputRow[i] = row[i];
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                String fieldValue = this.getInputRowMeta().getString(row, this.data.indexOfFieldToEvaluate);
                if (fieldValue == null) {
                    outputRow[this.data.indexOfMatchResultField] = false;
                    for (int i = 0; i < this.data.nrExtraFields; ++i) {
                        Object convertedValue;
                        ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(this.data.indexOfFirstCaptureGroupField + i);
                        ValueMetaInterface conversionValueMeta = this.data.conversionRowMeta.getValueMeta(this.data.indexOfFirstCaptureGroupField + i);
                        outputRow[this.data.indexOfFirstCaptureGroupField + i] = convertedValue = valueMeta.convertDataFromString(null, conversionValueMeta, this.meta.getFieldNullIf()[i], this.meta.getFieldIfNull()[i], this.meta.getFieldTrimType()[i]);
                    }
                } else {
                    Matcher m = this.data.pattern.matcher(fieldValue);
                    boolean isMatch = m.matches();
                    outputRow[this.data.indexOfMatchResultField] = isMatch;
                    String[] values = new String[this.data.nrExtraFields];
                    for (int i = 0; i < this.data.nrExtraFields; ++i) {
                        Object convertedValue;
                        if (isMatch) {
                            if (this.data.nrExtraFields != m.groupCount()) {
                                this.log.logError("Error", Messages.getString("RegexEval.Log.ErrorCaptureGroupFieldsMismatch", String.valueOf(m.groupCount()), String.valueOf(this.data.nrExtraFields)), new Object[0]);
                                throw new KettleStepException(Messages.getString("RegexEval.Exception.ErrorCaptureGroupFieldsMismatch", String.valueOf(m.groupCount()), String.valueOf(this.data.nrExtraFields)));
                            }
                            values[i] = m.group(i + 1);
                        }
                        ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(this.data.indexOfFirstCaptureGroupField + i);
                        ValueMetaInterface conversionValueMeta = this.data.conversionRowMeta.getValueMeta(this.data.indexOfFirstCaptureGroupField + i);
                        outputRow[this.data.indexOfFirstCaptureGroupField + i] = convertedValue = valueMeta.convertDataFromString(values[i], conversionValueMeta, this.meta.getFieldNullIf()[i], this.meta.getFieldIfNull()[i], this.meta.getFieldTrimType()[i]);
                    }
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(Messages.getString("RegexEval.Log.ReadRow") + " " + this.getInputRowMeta().getString(row));
                }
                this.putRow(this.data.outputRowMeta, outputRow);
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleStepException(Messages.getString("RegexEval.Log.ErrorInStep"), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block20;
                this.putError(this.getInputRowMeta(), outputRow, 1L, errorMessage, null, "REGEX001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RegexEvalMeta)smi;
        this.data = (RegexEvalData)sdi;
        if (super.init(smi, sdi)) {
            StringBuilder options = new StringBuilder();
            if (this.meta.isCaseInsensitiveFlagSet()) {
                options.append("(?i)");
            }
            if (this.meta.isCommentFlagSet()) {
                options.append("(?x)");
            }
            if (this.meta.isDotAllFlagSet()) {
                options.append("(?s)");
            }
            if (this.meta.isMultilineFlagSet()) {
                options.append("(?m)");
            }
            if (this.meta.isUnicodeFlagSet()) {
                options.append("(?u)");
            }
            if (this.meta.isUnixLineEndingsFlagSet()) {
                options.append("(?d)");
            }
            String regularexpression = this.meta.getScript();
            if (this.meta.isUseVariableInterpolationFlagSet()) {
                regularexpression = this.environmentSubstitute(this.meta.getScript());
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("RegexEval.Log.Regexp") + " " + options + regularexpression);
            }
            this.data.pattern = this.meta.isCanonicalEqualityFlagSet() ? Pattern.compile(options + regularexpression, 128) : Pattern.compile(options + regularexpression);
            return true;
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

