/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.denormaliser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserData;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserMeta;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserTargetField;
import org.pentaho.di.trans.steps.denormaliser.Messages;

public class Denormaliser
extends BaseStep
implements StepInterface {
    private DenormaliserMeta meta = (DenormaliserMeta)this.getStepMeta().getStepMetaInterface();
    private DenormaliserData data;

    public Denormaliser(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (DenormaliserData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.data.previous != null) {
                Object[] outputRowData = this.buildResult(this.data.inputRowMeta, this.data.previous);
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int i;
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.keyFieldNr = this.data.inputRowMeta.indexOfValue(this.meta.getKeyField());
            if (this.data.keyFieldNr < 0) {
                this.logError(Messages.getString("Denormaliser.Log.KeyFieldNotFound", this.meta.getKeyField()));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            Hashtable<Integer, Integer> subjects = new Hashtable<Integer, Integer>();
            this.data.fieldNameIndex = new int[this.meta.getDenormaliserTargetField().length];
            for (int i2 = 0; i2 < this.meta.getDenormaliserTargetField().length; ++i2) {
                DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[i2];
                int idx = this.data.inputRowMeta.indexOfValue(field.getFieldName());
                if (idx < 0) {
                    this.logError(Messages.getString("Denormaliser.Log.UnpivotFieldNotFound", field.getFieldName()));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.fieldNameIndex[i2] = idx;
                subjects.put(idx, idx);
                if (this.data.fieldNameIndex[i2] == this.data.keyFieldNr) {
                    this.logError(Messages.getString("Denormaliser.Log.ValueFieldSameAsKeyField", field.getFieldName()));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                String keyValue = this.environmentSubstitute(field.getKeyValue());
                List<Integer> indexes = this.data.keyValue.get(keyValue);
                if (indexes == null) {
                    indexes = new ArrayList<Integer>(2);
                }
                indexes.add(i2);
                this.data.keyValue.put(keyValue, indexes);
            }
            Set subjectSet = subjects.keySet();
            this.data.fieldNrs = subjectSet.toArray(new Integer[subjectSet.size()]);
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (int i3 = 0; i3 < this.meta.getGroupField().length; ++i3) {
                this.data.groupnrs[i3] = this.data.inputRowMeta.indexOfValue(this.meta.getGroupField()[i3]);
                if (this.data.groupnrs[i3] >= 0) continue;
                this.logError(Messages.getString("Denormaliser.Log.GroupingFieldNotFound", this.meta.getGroupField()[i3]));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ArrayList<Integer> removeList = new ArrayList<Integer>();
            removeList.add(this.data.keyFieldNr);
            for (i = 0; i < this.data.fieldNrs.length; ++i) {
                removeList.add(this.data.fieldNrs[i]);
            }
            Collections.sort(removeList);
            this.data.removeNrs = new int[removeList.size()];
            for (i = 0; i < removeList.size(); ++i) {
                this.data.removeNrs[i] = (Integer)removeList.get(i);
            }
            this.data.previous = r;
            this.newGroup();
            this.first = false;
        }
        if (!this.sameGroup(this.data.inputRowMeta, this.data.previous, r)) {
            Object[] outputRowData = this.buildResult(this.data.inputRowMeta, this.data.previous);
            this.putRow(this.data.outputRowMeta, outputRowData);
            this.newGroup();
            this.deNormalise(this.data.inputRowMeta, r);
        } else {
            this.deNormalise(this.data.inputRowMeta, r);
        }
        this.data.previous = r;
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("Denormaliser.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    private Object[] buildResult(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        int i;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        int outputIndex = 0;
        int removeIndex = 0;
        for (i = 0; i < rowMeta.size(); ++i) {
            if (removeIndex < this.data.removeNrs.length && i == this.data.removeNrs[removeIndex]) {
                ++removeIndex;
                continue;
            }
            outputRowData[outputIndex++] = rowData[i];
        }
        for (i = 0; i < this.data.targetResult.length; ++i) {
            Object resultValue = this.data.targetResult[i];
            DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[i];
            switch (field.getTargetAggregationType()) {
                case 2: {
                    long count = this.data.counters[i];
                    Object sum = this.data.sum[i];
                    if (count <= 0L) break;
                    if (sum instanceof Long) {
                        resultValue = (Long)sum / count;
                        break;
                    }
                    if (sum instanceof Double) {
                        resultValue = (Double)sum / (double)count;
                        break;
                    }
                    if (sum instanceof BigDecimal) {
                        resultValue = ((BigDecimal)sum).divide(new BigDecimal(count));
                        break;
                    }
                    resultValue = null;
                    break;
                }
                case 5: {
                    if (resultValue == null) {
                        resultValue = 0L;
                    }
                    if (field.getTargetType() == 5) break;
                    resultValue = this.data.outputRowMeta.getValueMeta(outputIndex).convertData((ValueMetaInterface)new ValueMeta("num_values_aggregation", 5), resultValue);
                    break;
                }
            }
            outputRowData[outputIndex++] = resultValue;
        }
        return outputRowData;
    }

    private boolean sameGroup(RowMetaInterface rowMeta, Object[] previous, Object[] rowData) throws KettleValueException {
        return rowMeta.compare(previous, rowData, this.data.groupnrs) == 0;
    }

    private void newGroup() {
        this.data.targetResult = new Object[this.meta.getDenormaliserTargetFields().length];
        for (int i = 0; i < this.meta.getDenormaliserTargetFields().length; ++i) {
            this.data.targetResult[i] = null;
            this.data.counters[i] = 0L;
            this.data.sum[i] = null;
        }
    }

    private void deNormalise(RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        List<Integer> indexes;
        Object valueData;
        ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.keyFieldNr);
        String key = valueMeta.getCompatibleString(valueData = rowData[this.data.keyFieldNr]);
        if (!Const.isEmpty((String)key) && (indexes = this.data.keyValue.get(key)) != null) {
            for (int i = 0; i < indexes.size(); ++i) {
                Integer keyNr = indexes.get(i);
                if (keyNr == null) continue;
                int idx = keyNr;
                DenormaliserTargetField field = this.meta.getDenormaliserTargetField()[idx];
                ValueMetaInterface sourceMeta = rowMeta.getValueMeta(this.data.fieldNameIndex[idx]);
                Object sourceData = rowData[this.data.fieldNameIndex[idx]];
                ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(this.data.inputRowMeta.size() - this.data.removeNrs.length + idx);
                Object prevTargetData = this.data.targetResult[idx];
                switch (field.getTargetAggregationType()) {
                    case 1: {
                        Object targetData = targetMeta.convertData(sourceMeta, sourceData);
                        if (prevTargetData != null) {
                            prevTargetData = ValueDataUtil.plus((ValueMetaInterface)targetMeta, (Object)prevTargetData, (ValueMetaInterface)targetMeta, (Object)targetData);
                            break;
                        }
                        prevTargetData = targetData;
                        break;
                    }
                    case 3: {
                        if (sourceMeta.compare(sourceData, targetMeta, prevTargetData) >= 0) break;
                        prevTargetData = targetMeta.convertData(sourceMeta, sourceData);
                        break;
                    }
                    case 4: {
                        if (sourceMeta.compare(sourceData, targetMeta, prevTargetData) <= 0) break;
                        prevTargetData = targetMeta.convertData(sourceMeta, sourceData);
                        break;
                    }
                    case 5: {
                        int n = idx;
                        long l = this.data.counters[n] + 1L;
                        this.data.counters[n] = l;
                        prevTargetData = l;
                        break;
                    }
                    case 2: {
                        Object targetData = targetMeta.convertData(sourceMeta, sourceData);
                        if (sourceMeta.isNull(sourceData)) break;
                        int n = idx;
                        long l = this.data.counters[n];
                        this.data.counters[n] = l + 1L;
                        prevTargetData = l;
                        if (this.data.sum[idx] == null) {
                            this.data.sum[idx] = targetData;
                            break;
                        }
                        this.data.sum[idx] = ValueDataUtil.plus((ValueMetaInterface)targetMeta, (Object)this.data.sum[idx], (ValueMetaInterface)targetMeta, (Object)targetData);
                        break;
                    }
                    default: {
                        Object targetData = targetMeta.convertData(sourceMeta, sourceData);
                        prevTargetData = targetMeta.convertData(sourceMeta, sourceData);
                    }
                }
                this.data.targetResult[idx] = prevTargetData;
            }
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DenormaliserMeta)smi;
        this.data = (DenormaliserData)sdi;
        if (super.init(smi, sdi)) {
            this.data.counters = new long[this.meta.getDenormaliserTargetField().length];
            this.data.sum = new Object[this.meta.getDenormaliserTargetField().length];
            return true;
        }
        return false;
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

