-- File: FramerCtrl.vhd
-- Generated by MyHDL 1.0dev
-- Date: Mon Feb 15 21:03:52 2016



package pck_FramerCtrl is

attribute enum_encoding: string;

    type t_enum_t_State_1 is (
    SEARCH,
    CONFIRM,
    SYNC
);
attribute enum_encoding of t_enum_t_State_1: type is "001 010 100";

end package pck_FramerCtrl;

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_10.all;

use work.pck_FramerCtrl.all;

entity FramerCtrl is
    port (
        SOF: out std_logic;
        state: inout t_enum_t_State_1;
        syncFlag: in std_logic;
        clk: in std_logic;
        reset_n: in std_logic
    );
end entity FramerCtrl;
-- Framing control FSM.
-- 
-- SOF -- start-of-frame output bit
-- state -- FramerState output
-- syncFlag -- sync pattern found indication input
-- clk -- clock input
-- reset_n -- active low reset

architecture MyHDL of FramerCtrl is



signal index: unsigned(7 downto 0);

begin





FRAMERCTRL_FSM: process (clk, reset_n) is
begin
    if (reset_n = '0') then
        SOF <= '0';
        index <= to_unsigned(0, 8);
        state <= SEARCH;
    elsif rising_edge(clk) then
        index <= ((index + 1) mod 8);
        SOF <= '0';
        case state is
            when SEARCH =>
                index <= to_unsigned(1, 8);
                if bool(syncFlag) then
                    state <= CONFIRM;
                end if;
            when CONFIRM =>
                if (index = 0) then
                    if bool(syncFlag) then
                        state <= SYNC;
                    else
                        state <= SEARCH;
                    end if;
                end if;
            when SYNC =>
                if (index = 0) then
                    if (not bool(syncFlag)) then
                        state <= SEARCH;
                    end if;
                end if;
                SOF <= stdl(signed(resize(index, 9)) = (8 - 1));
            when others =>
                assert False report "End of Simulation" severity Failure;
        end case;
    end if;
end process FRAMERCTRL_FSM;

end architecture MyHDL;
