/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.python;

import java.util.Collection;
import java.util.List;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectPropertyProvider;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonType;
import org.graalvm.visualvm.heapviewer.utils.HeapOperations;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.Value;

final class PythonObjectProperties {
    PythonObjectProperties() {
    }

    public static class ReferencesProvider
    extends TruffleObjectPropertyProvider.References<PythonObject, PythonType, PythonHeapFragment, PythonLanguage> {
        public ReferencesProvider() {
            super(Bundle.PythonObjectProperties_References(), PythonLanguage.instance(), false);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("python_") && !viewID.endsWith("_attributes");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            return node instanceof PythonNodes.PythonNode && !(node instanceof PythonNodes.PythonObjectFieldNode);
        }

        @Override
        protected HeapViewerNode createObjectReferenceNode(PythonObject object, String type, FieldValue field) {
            return new PythonNodes.PythonObjectReferenceNode(object, type, field);
        }

        @Override
        protected HeapViewerNode createForeignReferenceNode(Instance instance, FieldValue field, Heap heap) {
            List references = instance.getReferences();
            for (Value reference : references) {
                instance = reference.getDefiningInstance();
                if (!((PythonLanguage)((Object)this.getLanguage())).isLanguageObject(instance)) continue;
                PythonObject robj = ((PythonLanguage)((Object)this.getLanguage())).createObject(instance);
                return new PythonNodes.PythonObjectAttributeReferenceNode(robj, robj.getType(), field);
            }
            return super.createForeignReferenceNode(instance, field, heap);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(PythonObject object) throws InterruptedException {
            HeapOperations.initializeReferences((Heap)object.getInstance().getJavaClass().getHeap());
            return object.getReferences();
        }
    }

    public static class ItemsProvider
    extends TruffleObjectPropertyProvider.Fields<PythonObject, PythonType, PythonHeapFragment, PythonLanguage> {
        public ItemsProvider() {
            super(Bundle.PythonObjectProperties_Items(), PythonLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("python_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            if (node instanceof PythonNodes.PythonNode && !(node instanceof PythonNodes.PythonObjectReferenceNode) && !(node instanceof PythonNodes.PythonObjectAttributeReferenceNode)) {
                PythonObject pyobject;
                TruffleObject object = (TruffleObject)HeapViewerNode.getValue((HeapViewerNode)node, TruffleObject.DATA_TYPE, (Heap)heap);
                PythonObject pythonObject = pyobject = object instanceof PythonObject ? (PythonObject)object : null;
                if (pyobject != null) {
                    return !this.getPropertyItems(pyobject).isEmpty();
                }
            }
            return false;
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(PythonObject object, String type, FieldValue field) {
            return new PythonNodes.PythonObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(PythonObject object) {
            return object.getItems();
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("com.oracle.graal.python.runtime.datatype.") || className.startsWith("com.oracle.truffle.api.strings.");
        }

        @Override
        protected String getMergedPropertiesKey() {
            return null;
        }
    }

    public static class AttributesProvider
    extends TruffleObjectPropertyProvider.Fields<PythonObject, PythonType, PythonHeapFragment, PythonLanguage> {
        public AttributesProvider() {
            super(Bundle.PythonObjectProperties_Properties(), PythonLanguage.instance(), true);
        }

        @Override
        public boolean supportsView(Heap heap, String viewID) {
            return viewID.startsWith("python_") && !viewID.endsWith("_references");
        }

        @Override
        public boolean supportsNode(HeapViewerNode node, Heap heap, String viewID) {
            if (node instanceof PythonNodes.PythonNode && !(node instanceof PythonNodes.PythonObjectReferenceNode) && !(node instanceof PythonNodes.PythonObjectAttributeReferenceNode)) {
                PythonObject pyobject;
                TruffleObject object = (TruffleObject)HeapViewerNode.getValue((HeapViewerNode)node, TruffleObject.DATA_TYPE, (Heap)heap);
                PythonObject pythonObject = pyobject = object instanceof PythonObject ? (PythonObject)object : null;
                if (pyobject != null) {
                    return !this.getPropertyItems(pyobject).isEmpty();
                }
            }
            return false;
        }

        @Override
        protected HeapViewerNode createObjectFieldNode(PythonObject object, String type, FieldValue field) {
            return new PythonNodes.PythonObjectFieldNode(object, type, field);
        }

        @Override
        protected Collection<FieldValue> getPropertyItems(PythonObject object) {
            return object.getAttributes();
        }

        @Override
        protected boolean includeInstance(Instance instance) {
            String className = instance.getJavaClass().getName();
            return className.startsWith("java.lang.") || className.startsWith("java.math.") || className.startsWith("com.oracle.graal.python.runtime.datatype.") || className.startsWith("com.oracle.truffle.api.strings.");
        }
    }
}

