/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.updateprovider.DownloadListener;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Utilities;

public final class AutoupdateCatalogCache {
    private final File cacheDir = Places.getCacheSubdirectory((String)"catalogcache");
    private static AutoupdateCatalogCache INSTANCE;
    private static final Logger err;

    private AutoupdateCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists()) : "Cache directory " + this.cacheDir + " exists.";
        this.getLicenseDir().mkdirs();
        err.log(Level.FINE, "getCacheDirectory: {0}", this.cacheDir.getPath());
    }

    public static synchronized AutoupdateCatalogCache getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AutoupdateCatalogCache();
        }
        return INSTANCE;
    }

    private synchronized File getCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists()) : "Cache directory " + this.cacheDir + " must exist.";
        return this.cacheDir;
    }

    public URL writeCatalogToCache(String string, URL uRL) throws IOException {
        URL uRL2;
        block3: {
            uRL2 = null;
            File file = this.getCatalogCache();
            assert (file != null && file.exists()) : "Cache directory must exist.";
            File file2 = new File(file, string);
            this.copy(uRL, file2, false);
            try {
                uRL2 = Utilities.toURI((File)file2).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getCatalogURL(String string) {
        File file = this.getCatalogCache();
        File file2 = new File(file, string);
        String string2 = this.getLock(file2);
        synchronized (string2) {
            if (file2.exists()) {
                URL uRL;
                block7: {
                    if (file2.length() == 0L) {
                        err.log(Level.INFO, "Cache file {0} exists and of zero size", file2);
                        return null;
                    }
                    uRL = null;
                    try {
                        uRL = Utilities.toURI((File)file2).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        if ($assertionsDisabled) break block7;
                        throw new AssertionError((Object)malformedURLException);
                    }
                }
                return uRL;
            }
            return null;
        }
    }

    private File getLicenseDir() {
        return new File(this.getCatalogCache(), "licenses");
    }

    private File getLicenseFile(String string) {
        return new File(this.getLicenseDir(), string);
    }

    public String getLicense(String string) {
        return this.getLicense(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicense(String string, URL uRL) {
        File file = this.getLicenseFile(string);
        String string2 = string.intern();
        synchronized (string2) {
            if (!file.exists()) {
                if (uRL == null) {
                    return null;
                }
                try {
                    this.copy(uRL, file, true);
                }
                catch (IOException iOException) {
                    err.log(Level.INFO, "Can`t store license from " + uRL + " to " + file, iOException);
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                        file.createNewFile();
                        file.deleteOnExit();
                    }
                    catch (IOException iOException2) {
                        err.log(Level.INFO, "Can`t create empty license file", iOException2);
                    }
                }
            }
            return this.readLicenseFile(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLicense(String string, String string2) {
        File file = this.getLicenseFile(string);
        String string3 = string.intern();
        synchronized (string3) {
            if (file.exists() || string2 == null) {
                return;
            }
            this.writeToFile(string2, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLicenseFile(String string) {
        File file = this.getLicenseFile(string);
        FileInputStream fileInputStream = null;
        String string2 = string.intern();
        synchronized (string2) {
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[8192];
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = fileInputStream.read(byArray)) != -1) {
                    stringBuilder.append(new String(byArray, 0, n, "utf-8"));
                }
                String string3 = stringBuilder.toString();
                return string3;
            }
            catch (IOException iOException) {
                err.log(Level.INFO, "Can`t read license from file " + file, iOException);
                String string4 = null;
                return string4;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException3) {
                        err.log(Level.INFO, "Can`t read close input stream for " + file, iOException3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String string, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes("utf-8"));
        }
        catch (IOException iOException) {
            err.log(Level.INFO, "Can`t write to " + file, iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    err.log(Level.INFO, "Can`t output stream for " + file, iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URL uRL, File file, boolean bl) throws IOException {
        err.log(Level.FINE, "Processing URL: {0}", uRL);
        String string = "";
        while (string.length() < 3) {
            string = string + file.getName();
        }
        File file2 = Files.createTempFile(file.getParentFile().toPath(), string, null, new FileAttribute[0]).toFile();
        file2.deleteOnExit();
        DownloadListener downloadListener = new DownloadListener(uRL, file2, bl);
        NetworkAccess.Task task = NetworkAccess.createNetworkAccessTask(uRL, AutoupdateSettings.getOpenConnectionTimeout(), downloadListener, true);
        task.waitFinished();
        downloadListener.notifyException();
        String string2 = this.getLock(file);
        synchronized (string2) {
            this.updateCachedFile(file, file2);
            assert (file.exists()) : "Cache " + file + " exists.";
            err.log(Level.FINER, "Cache file {0} was wrote from original URL {1}", new Object[]{file, uRL});
            if (file.exists() && file.length() == 0L) {
                err.log(Level.INFO, "Written cache size is zero bytes");
            }
        }
    }

    public String getLock(File file) {
        return file.getAbsolutePath().intern();
    }

    public String getLock(URL uRL) throws IOException {
        try {
            return this.getLock(Utilities.toFile((URI)uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
    }

    private void updateCachedFile(File file, File file2) {
        if (file.exists() && !file.delete()) {
            block8: {
                err.log(Level.INFO, "Cannot delete cache {0}", file);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)interruptedException);
                }
            }
            file.delete();
        }
        if (file2.length() == 0L) {
            err.log(Level.INFO, "Temp cache size is zero bytes");
        }
        if (!file2.renameTo(file)) {
            err.log(Level.INFO, "Cannot rename temp {0} to cache {1}", new Object[]{file2, file});
            err.log(Level.INFO, "Trying to copy {0} to cache {1}", new Object[]{file2, file});
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileInputStream fileInputStream = new FileInputStream(file2);
                FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                fileOutputStream.close();
                fileInputStream.close();
                file2.delete();
            }
            catch (IOException iOException) {
                err.log(Level.INFO, "Cannot even copy: {0}", iOException.getMessage());
                err.log(Level.FINE, null, iOException);
            }
        }
        if (file.exists() && file.length() == 0L) {
            err.log(Level.INFO, "Final cache size is zero bytes");
        }
    }

    static {
        err = Logger.getLogger(AutoupdateCatalogCache.class.getName());
    }
}

