/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.core.ui.components.DisplayArea;
import org.graalvm.visualvm.core.ui.components.JExtendedSplitPane;
import org.graalvm.visualvm.uisupport.UISupport;

public final class DataViewComponent
extends JPanel {
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    private boolean isMasterViewResizable;
    private JPanel masterPanel;
    private JPanel detailsPanel;
    private JExtendedSplitPane detailsTopHorizontalSplitter;
    private JExtendedSplitPane detailsBottomHorizontalSplitter;
    private JExtendedSplitPane detailsVerticalSplitter;
    private DisplayArea masterArea;
    private DisplayArea detailsTopLeftArea;
    private DisplayArea detailsTopRightArea;
    private DisplayArea detailsBottomLeftArea;
    private DisplayArea detailsBottomRightArea;
    private static final Color BACKGROUND_COLOR;
    private static final Color HIGHLIGHT_BACKGROUND;

    public DataViewComponent(MasterView masterView, MasterViewConfiguration masterAreaConfiguration) {
        this.initComponents();
        this.createMasterView(masterView);
        this.configureMasterView(masterAreaConfiguration);
    }

    private void configureMasterView(MasterViewConfiguration masterViewConfiguration) {
        this.setMasterViewResizable(masterViewConfiguration.isMasterViewResizable());
    }

    public void configureDetailsView(DetailsViewConfiguration detailsViewConfiguration) {
        double verticalDividerLocation;
        double verticalDividerResizeWeight;
        double bottomHorizontalDividerLocation;
        double bottomHorizontalDividerResizeWeight;
        double topHorizontalDividerLocation;
        double topHorizontalDividerResizeWeight = detailsViewConfiguration.getTopHorizontalDividerResizeWeight();
        if (topHorizontalDividerResizeWeight != -1.0) {
            this.detailsTopHorizontalSplitter.setResizeWeight(topHorizontalDividerResizeWeight);
        }
        if ((topHorizontalDividerLocation = detailsViewConfiguration.getTopHorizontalDividerLocation()) != -1.0) {
            this.detailsTopHorizontalSplitter.setDividerLocation(topHorizontalDividerLocation);
        }
        if ((bottomHorizontalDividerResizeWeight = detailsViewConfiguration.getBottomHorizontalDividerResizeWeight()) != -1.0) {
            this.detailsBottomHorizontalSplitter.setResizeWeight(bottomHorizontalDividerResizeWeight);
        }
        if ((bottomHorizontalDividerLocation = detailsViewConfiguration.getBottomHorizontalDividerLocation()) != -1.0) {
            this.detailsBottomHorizontalSplitter.setDividerLocation(bottomHorizontalDividerLocation);
        }
        if ((verticalDividerResizeWeight = detailsViewConfiguration.getVerticalDividerResizeWeight()) != -1.0) {
            this.detailsVerticalSplitter.setResizeWeight(verticalDividerResizeWeight);
        }
        if ((verticalDividerLocation = detailsViewConfiguration.getVerticalDividerLocation()) != -1.0) {
            this.detailsVerticalSplitter.setDividerLocation(verticalDividerLocation);
        }
    }

    public void showDetailsArea(int location) {
        DisplayArea displayArea = this.getDisplayArea(location);
        if (displayArea != null) {
            displayArea.setVisible(true);
        }
    }

    public void hideDetailsArea(int location) {
        DisplayArea displayArea = this.getDisplayArea(location);
        if (displayArea != null) {
            displayArea.setVisible(false);
        }
    }

    public boolean isDetailsAreaShown(int location) {
        DisplayArea displayArea = this.getDisplayArea(location);
        return displayArea != null ? displayArea.isVisible() : false;
    }

    public void configureDetailsArea(DetailsAreaConfiguration detailsAreaConfiguration, int location) {
        DisplayArea displayArea = this.getDisplayArea(location);
        if (displayArea != null) {
            displayArea.setCaption(detailsAreaConfiguration.getName());
            displayArea.setClosable(detailsAreaConfiguration.isClosable());
        }
    }

    private void createMasterView(MasterView masterView) {
        this.masterPanel.setVisible(true);
        JComponent[] options = new JComponent[]{this.detailsTopLeftArea.getPresenter(), this.detailsTopRightArea.getPresenter(), this.detailsBottomLeftArea.getPresenter(), this.detailsBottomRightArea.getPresenter()};
        this.masterArea.addTab(new DisplayArea.Tab(masterView.getName(), masterView.getDescription(), 0, masterView.getView(), options));
    }

    public void addDetailsView(DetailsView detailsView, int location) {
        DisplayArea displayArea = this.getDisplayArea(location);
        if (displayArea != null) {
            if ("".equals(displayArea.getCaption())) {
                displayArea.setCaption(detailsView.getTab().getName());
            }
            displayArea.addTab(detailsView.getTab());
            this.revalidate();
            this.repaint();
        }
    }

    public void removeDetailsView(DetailsView detailsView) {
        DisplayArea displayArea = this.getDisplayArea(detailsView.getTab());
        if (displayArea != null) {
            displayArea.removeTab(detailsView.getTab());
        }
    }

    public boolean containsDetailsView(DetailsView detailsView) {
        return this.getDisplayArea(detailsView.getTab()) != null;
    }

    public void selectDetailsView(DetailsView detailsView) {
        DisplayArea displayArea = this.getDisplayArea(detailsView.getTab());
        if (displayArea != null) {
            displayArea.setSelectedTab(detailsView.getTab());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMasterViewResizable(boolean isMasterViewResizable) {
        this.isMasterViewResizable = isMasterViewResizable;
        this.masterArea.setIgnoresContentsHeight(isMasterViewResizable);
        JComponent contents = null;
        if (isMasterViewResizable) {
            final CustomizedSplitPaneUI mainVerticalSplitterUI = new CustomizedSplitPaneUI();
            JExtendedSplitPane mainVerticalSplitter = new JExtendedSplitPane(0, this.masterPanel, this.detailsPanel){

                @Override
                public void updateUI() {
                    if (this.getUI() != mainVerticalSplitterUI) {
                        this.setUI(mainVerticalSplitterUI);
                    }
                    this.setBorder(null);
                    this.setOpaque(false);
                    this.setDividerSize(6);
                    this.setContinuousLayout(true);
                    final BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
                    divider.setBackground(BACKGROUND_COLOR);
                    divider.setBorder(null);
                    divider.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            divider.setBackground(HIGHLIGHT_BACKGROUND);
                            divider.repaint();
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            divider.setBackground(BACKGROUND_COLOR);
                            divider.repaint();
                        }
                    });
                }
            };
            mainVerticalSplitter.setDividerLocation(0.5);
            contents = mainVerticalSplitter;
        } else {
            JPanel containerPanel = new JPanel(new BorderLayout());
            containerPanel.setOpaque(false);
            containerPanel.add((Component)this.masterPanel, "North");
            containerPanel.add((Component)this.detailsPanel, "Center");
            contents = containerPanel;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.removeAll();
            this.add((Component)contents, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    private boolean isMasterAreaResizable() {
        return this.isMasterViewResizable;
    }

    private DisplayArea getDisplayArea(int location) {
        switch (location) {
            case 1: {
                return this.detailsTopLeftArea;
            }
            case 2: {
                return this.detailsTopRightArea;
            }
            case 3: {
                return this.detailsBottomLeftArea;
            }
            case 4: {
                return this.detailsBottomRightArea;
            }
        }
        return null;
    }

    private DisplayArea getDisplayArea(DisplayArea.Tab tab) {
        if (this.detailsTopLeftArea.containsTab(tab)) {
            return this.detailsTopLeftArea;
        }
        if (this.detailsTopRightArea.containsTab(tab)) {
            return this.detailsTopRightArea;
        }
        if (this.detailsBottomLeftArea.containsTab(tab)) {
            return this.detailsBottomLeftArea;
        }
        if (this.detailsBottomRightArea.containsTab(tab)) {
            return this.detailsBottomRightArea;
        }
        return null;
    }

    private void initComponents() {
        this.detailsTopLeftArea = new DisplayArea();
        this.detailsTopRightArea = new DisplayArea();
        final JPanel detailsTopPanel = new JPanel(new BorderLayout());
        detailsTopPanel.setOpaque(false);
        final CustomizedSplitPaneUI detailsTopHorizontalSplitterUI = new CustomizedSplitPaneUI();
        this.detailsTopHorizontalSplitter = new JExtendedSplitPane(1, this.detailsTopLeftArea, this.detailsTopRightArea){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                detailsTopPanel.setVisible(visible);
                this.revalidate();
                this.repaint();
            }

            @Override
            public void updateUI() {
                if (this.getUI() != detailsTopHorizontalSplitterUI) {
                    this.setUI(detailsTopHorizontalSplitterUI);
                }
                this.setBorder(null);
                this.setOpaque(false);
                this.setDividerSize(6);
                this.setContinuousLayout(true);
                final BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
                divider.setBackground(BACKGROUND_COLOR);
                divider.setBorder(null);
                divider.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        divider.setBackground(HIGHLIGHT_BACKGROUND);
                        divider.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        divider.setBackground(BACKGROUND_COLOR);
                        divider.repaint();
                    }
                });
            }
        };
        this.detailsTopHorizontalSplitter.setResizeWeight(0.5);
        this.detailsTopHorizontalSplitter.setDividerLocation(0.5);
        detailsTopPanel.add((Component)this.detailsTopHorizontalSplitter, "Center");
        this.detailsBottomLeftArea = new DisplayArea();
        this.detailsBottomRightArea = new DisplayArea();
        final JPanel detailsBottomPanel = new JPanel(new BorderLayout());
        detailsBottomPanel.setOpaque(false);
        final CustomizedSplitPaneUI detailsBottomHorizontalSplitterUI = new CustomizedSplitPaneUI();
        this.detailsBottomHorizontalSplitter = new JExtendedSplitPane(1, this.detailsBottomLeftArea, this.detailsBottomRightArea){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                detailsBottomPanel.setVisible(visible);
                this.revalidate();
                this.repaint();
            }

            @Override
            public void updateUI() {
                if (this.getUI() != detailsBottomHorizontalSplitterUI) {
                    this.setUI(detailsBottomHorizontalSplitterUI);
                }
                this.setBorder(null);
                this.setOpaque(false);
                this.setDividerSize(6);
                this.setContinuousLayout(true);
                final BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
                divider.setBackground(BACKGROUND_COLOR);
                divider.setBorder(null);
                divider.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        divider.setBackground(HIGHLIGHT_BACKGROUND);
                        divider.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        divider.setBackground(BACKGROUND_COLOR);
                        divider.repaint();
                    }
                });
            }
        };
        this.detailsBottomHorizontalSplitter.setResizeWeight(0.5);
        this.detailsBottomHorizontalSplitter.setDividerLocation(0.5);
        detailsBottomPanel.add((Component)this.detailsBottomHorizontalSplitter, "Center");
        this.detailsPanel = new JPanel(new BorderLayout());
        this.detailsPanel.setOpaque(false);
        this.detailsPanel.setVisible(false);
        final CustomizedSplitPaneUI detailsVerticalSplitterUI = new CustomizedSplitPaneUI();
        this.detailsVerticalSplitter = new JExtendedSplitPane(0, detailsTopPanel, detailsBottomPanel){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                DataViewComponent.this.detailsPanel.setVisible(visible);
                this.revalidate();
                this.repaint();
            }

            @Override
            public void updateUI() {
                if (this.getUI() != detailsVerticalSplitterUI) {
                    this.setUI(detailsVerticalSplitterUI);
                }
                this.setBorder(null);
                this.setOpaque(false);
                this.setDividerSize(6);
                this.setContinuousLayout(true);
                final BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
                divider.setBackground(BACKGROUND_COLOR);
                divider.setBorder(null);
                divider.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        divider.setBackground(HIGHLIGHT_BACKGROUND);
                        divider.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        divider.setBackground(BACKGROUND_COLOR);
                        divider.repaint();
                    }
                });
            }
        };
        this.detailsVerticalSplitter.setResizeWeight(0.5);
        this.detailsVerticalSplitter.setDividerLocation(0.5);
        this.detailsPanel.add((Component)this.detailsVerticalSplitter, "Center");
        this.masterArea = new DisplayArea();
        this.masterArea.setClosable(false);
        this.masterPanel = new JPanel(new BorderLayout());
        this.masterPanel.setOpaque(false);
        this.masterPanel.setVisible(false);
        this.masterPanel.add((Component)this.masterArea, "Center");
        this.setOpaque(true);
        this.setBackground(BACKGROUND_COLOR);
        this.setLayout(new BorderLayout());
    }

    static {
        int darkerB;
        int darkerG;
        BACKGROUND_COLOR = UISupport.getDefaultBackground();
        int darkerR = BACKGROUND_COLOR.getRed() - 20;
        if (darkerR < 0) {
            darkerR += 40;
        }
        if ((darkerG = BACKGROUND_COLOR.getGreen() - 20) < 0) {
            darkerG += 40;
        }
        if ((darkerB = BACKGROUND_COLOR.getBlue() - 20) < 0) {
            darkerB += 40;
        }
        HIGHLIGHT_BACKGROUND = new Color(darkerR, darkerG, darkerB);
    }

    public static class DetailsAreaConfiguration {
        private String name;
        private boolean closable;

        public DetailsAreaConfiguration(String name, boolean closable) {
            this.name = name;
            this.closable = closable;
        }

        private String getName() {
            return this.name;
        }

        private boolean isClosable() {
            return this.closable;
        }
    }

    public static class DetailsViewConfiguration {
        private double topHorizontalDividerLocation;
        private double topHorizontalDividerResizeWeight;
        private double bottomHorizontalDividerLocation;
        private double bottomHorizontalDividerResizeWeight;
        private double verticalDividerLocation;
        private double verticalDividerResizeWeight;

        public DetailsViewConfiguration(double topHorizontalDividerLocation, double topHorizontalDividerResizeWeight, double bottomHorizontalDividerLocation, double bottomHorizontalDividerResizeWeight, double verticalDividerLocation, double verticalDividerResizeWeight) {
            this.topHorizontalDividerLocation = topHorizontalDividerLocation;
            this.topHorizontalDividerResizeWeight = topHorizontalDividerResizeWeight;
            this.bottomHorizontalDividerLocation = bottomHorizontalDividerLocation;
            this.bottomHorizontalDividerResizeWeight = bottomHorizontalDividerResizeWeight;
            this.verticalDividerLocation = verticalDividerLocation;
            this.verticalDividerResizeWeight = verticalDividerResizeWeight;
        }

        public double getTopHorizontalDividerLocation() {
            return this.topHorizontalDividerLocation;
        }

        public double getTopHorizontalDividerResizeWeight() {
            return this.topHorizontalDividerResizeWeight;
        }

        public double getBottomHorizontalDividerLocation() {
            return this.bottomHorizontalDividerLocation;
        }

        public double getBottomHorizontalDividerResizeWeight() {
            return this.bottomHorizontalDividerResizeWeight;
        }

        public double getVerticalDividerLocation() {
            return this.verticalDividerLocation;
        }

        public double getVerticalDividerResizeWeight() {
            return this.verticalDividerResizeWeight;
        }
    }

    public static class MasterViewConfiguration {
        private boolean isMasterViewResizable;

        public MasterViewConfiguration(boolean isMasterAreaResizable) {
            this.isMasterViewResizable = isMasterAreaResizable;
        }

        private boolean isMasterViewResizable() {
            return this.isMasterViewResizable;
        }
    }

    public static class DetailsView {
        private DisplayArea.Tab tab;

        public DetailsView(String name, String description, int preferredPosition, JComponent view, JComponent[] options) {
            this.tab = new DisplayArea.Tab(name, description, preferredPosition, view, options);
        }

        private DisplayArea.Tab getTab() {
            return this.tab;
        }
    }

    public static class MasterView {
        private String name;
        private String description;
        private JComponent view;

        public MasterView(String name, String description, JComponent view) {
            this.name = name;
            this.description = description;
            this.view = view;
        }

        private String getName() {
            return this.name;
        }

        private String getDescription() {
            return this.description;
        }

        private JComponent getView() {
            return this.view;
        }
    }

    private static class CustomizedSplitPaneUI
    extends BasicSplitPaneUI {
        private CustomizedSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){

                @Override
                public void paint(Graphics g) {
                    Dimension size = this.getSize();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, size.width, size.height);
                }
            };
        }
    }
}

