/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.ShowOperation;
import org.netbeans.spi.io.InputOutputProvider;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public abstract class IOProvider {
    private IOProvider() {
    }

    @NonNull
    public static IOProvider getDefault() {
        InputOutputProvider<?, ?, ?, ?> inputOutputProvider = (InputOutputProvider<?, ?, ?, ?>)Lookup.getDefault().lookup(InputOutputProvider.class);
        if (inputOutputProvider != null) {
            return IOProvider.wrapProvider(inputOutputProvider);
        }
        inputOutputProvider = IOProvider.getBridgingDefault();
        if (inputOutputProvider != null) {
            return IOProvider.wrapProvider(inputOutputProvider);
        }
        return IOProvider.wrapProvider(new Trivial());
    }

    private static <IO, OW extends PrintWriter, P, F> IOProvider wrapProvider(InputOutputProvider<IO, OW, P, F> inputOutputProvider) {
        return new Impl<IO, OW, P, F>(inputOutputProvider);
    }

    private static InputOutputProvider<?, ?, ?, ?> getBridgingDefault() {
        return IOProvider.getBridging("getDefault", new Class[0], new Object[0]);
    }

    private static InputOutputProvider<?, ?, ?, ?> getBridging(String string) {
        return IOProvider.getBridging("get", new Class[]{String.class}, new Object[]{string});
    }

    private static InputOutputProvider<?, ?, ?, ?> getBridging(String string, Class<?>[] classArray, Object[] objectArray) {
        String string2 = "org.openide.io.BridgingGetter";
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader != null) {
            try {
                Class<?> clazz = Class.forName(string2, true, classLoader);
                Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = clazz.getDeclaredMethod(string, classArray);
                Object object = method.invoke(obj, objectArray);
                if (object instanceof InputOutputProvider) {
                    return (InputOutputProvider)object;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    @NonNull
    public static IOProvider get(@NonNull String string) {
        Parameters.notNull((CharSequence)"id", (Object)string);
        Collection collection = Lookup.getDefault().lookupAll(InputOutputProvider.class);
        for (InputOutputProvider inputOutputProvider : collection) {
            if (!inputOutputProvider.getId().equals(string)) continue;
            return IOProvider.wrapProvider(inputOutputProvider);
        }
        InputOutputProvider<?, ?, ?, ?> inputOutputProvider = IOProvider.getBridging(string);
        if (inputOutputProvider != null) {
            return IOProvider.wrapProvider(inputOutputProvider);
        }
        return IOProvider.getDefault();
    }

    @NonNull
    public abstract String getId();

    @NonNull
    public abstract InputOutput getIO(@NonNull String var1, boolean var2);

    @NonNull
    public abstract InputOutput getIO(@NonNull String var1, boolean var2, @NonNull Lookup var3);

    private static class Trivial
    implements InputOutputProvider<Object, PrintWriter, Void, Void> {
        private Trivial() {
        }

        @Override
        public String getId() {
            return "Trivial";
        }

        @Override
        public Object getIO(String string, boolean bl, Lookup lookup) {
            return this;
        }

        @Override
        public Reader getIn(Object object) {
            return new InputStreamReader(System.in);
        }

        @Override
        public PrintWriter getOut(Object object) {
            return new PrintWriter(System.out);
        }

        @Override
        public PrintWriter getErr(Object object) {
            return new PrintWriter(System.err);
        }

        @Override
        public void print(Object object, PrintWriter printWriter, String string, Hyperlink hyperlink, OutputColor outputColor, boolean bl) {
            printWriter.print(string);
            if (bl) {
                printWriter.println();
            }
        }

        @Override
        public Lookup getIOLookup(Object object) {
            return Lookup.EMPTY;
        }

        @Override
        public void resetIO(Object object) {
        }

        @Override
        public void showIO(Object object, Set<ShowOperation> set) {
        }

        @Override
        public void closeIO(Object object) {
        }

        @Override
        public boolean isIOClosed(Object object) {
            return false;
        }

        @Override
        public Void getCurrentPosition(Object object, PrintWriter printWriter) {
            return null;
        }

        @Override
        public void scrollTo(Object object, PrintWriter printWriter, Void void_) {
        }

        @Override
        public Void startFold(Object object, PrintWriter printWriter, boolean bl) {
            return null;
        }

        @Override
        public void endFold(Object object, PrintWriter printWriter, Void void_) {
        }

        @Override
        public void setFoldExpanded(Object object, PrintWriter printWriter, Void void_, boolean bl) {
        }

        @Override
        public String getIODescription(Object object) {
            return null;
        }

        @Override
        public void setIODescription(Object object, String string) {
        }
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends IOProvider {
        private final InputOutputProvider<IO, OW, P, F> impl;

        public Impl(InputOutputProvider<IO, OW, P, F> inputOutputProvider) {
            this.impl = inputOutputProvider;
        }

        @Override
        public String getId() {
            return this.impl.getId();
        }

        @Override
        public InputOutput getIO(String string, boolean bl) {
            return this.getIO(string, bl, Lookup.EMPTY);
        }

        @Override
        public InputOutput getIO(String string, boolean bl, Lookup lookup) {
            Parameters.notNull((CharSequence)"name", (Object)string);
            Parameters.notNull((CharSequence)"lookup", (Object)lookup);
            return InputOutput.create(this.impl, this.impl.getIO(string, bl, lookup));
        }
    }
}

