/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.common.base.Throwables;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetry;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EnabledTraceUtil
implements TraceUtil {
    private final Tracer tracer;
    private final OpenTelemetry openTelemetry;
    private final FirestoreOptions firestoreOptions;

    EnabledTraceUtil(FirestoreOptions firestoreOptions) {
        OpenTelemetry openTelemetry = firestoreOptions.getOpenTelemetryOptions().getOpenTelemetry();
        if (openTelemetry == null) {
            openTelemetry = GlobalOpenTelemetry.get();
        }
        this.firestoreOptions = firestoreOptions;
        this.openTelemetry = openTelemetry;
        Package pkg = this.getClass().getPackage();
        this.tracer = pkg != null ? openTelemetry.getTracer("com.google.cloud.firestore", pkg.getImplementationVersion()) : openTelemetry.getTracer("com.google.cloud.firestore");
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Override
    @Nullable
    public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
        if (this.openTelemetry.getTracerProvider() == TracerProvider.noop()) {
            return null;
        }
        return new OpenTelemetryGrpcChannelConfigurator();
    }

    String durationString(Duration duration) {
        int nanos = duration.getNano();
        long seconds = duration.getSeconds();
        int numLeadingZeros = 9;
        double nanosFraction = nanos;
        while (nanosFraction >= 1.0) {
            nanosFraction /= 10.0;
            --numLeadingZeros;
        }
        if (numLeadingZeros == 9) {
            numLeadingZeros = 0;
        }
        while (nanos > 0 && nanos % 10 == 0) {
            nanos /= 10;
        }
        StringBuilder stringBuilder = new StringBuilder().append(seconds).append(".");
        for (int i = 0; i < numLeadingZeros; ++i) {
            stringBuilder.append("0");
        }
        stringBuilder.append(nanos).append("s");
        return stringBuilder.toString();
    }

    private SpanBuilder addSettingsAttributesToCurrentSpan(SpanBuilder spanBuilder) {
        spanBuilder = spanBuilder.setAttribute("gcp.client.service", "Firestore");
        spanBuilder = spanBuilder.setAllAttributes(Attributes.builder().put("gcp.resource.name", String.format("//firestore.googleapis.com/projects/%s/databases/%s", this.firestoreOptions.getProjectId(), this.firestoreOptions.getDatabaseId())).put("gcp.firestore.settings.project_id", this.firestoreOptions.getProjectId()).put("gcp.firestore.settings.database_id", this.firestoreOptions.getDatabaseId()).put("gcp.firestore.settings.host", this.firestoreOptions.getHost()).build());
        if (this.firestoreOptions.getTransportChannelProvider() != null) {
            spanBuilder = spanBuilder.setAllAttributes(Attributes.builder().put("gcp.firestore.settings.channel.transport_name", this.firestoreOptions.getTransportChannelProvider().getTransportName()).put("gcp.firestore.settings.channel.needs_credentials", String.valueOf(this.firestoreOptions.getTransportChannelProvider().needsCredentials())).put("gcp.firestore.settings.channel.needs_endpoint", String.valueOf(this.firestoreOptions.getTransportChannelProvider().needsEndpoint())).put("gcp.firestore.settings.channel.needs_headers", String.valueOf(this.firestoreOptions.getTransportChannelProvider().needsHeaders())).put("gcp.firestore.settings.channel.should_auto_close", String.valueOf(this.firestoreOptions.getTransportChannelProvider().shouldAutoClose())).build());
        }
        if (this.firestoreOptions.getCredentials() != null) {
            spanBuilder = spanBuilder.setAttribute("gcp.firestore.settings.credentials.authentication_type", this.firestoreOptions.getCredentials().getAuthenticationType());
        }
        if (this.firestoreOptions.getRetrySettings() != null) {
            spanBuilder = spanBuilder.setAllAttributes(Attributes.builder().put("gcp.firestore.settings.retry_settings.initial_retry_delay", this.durationString(this.firestoreOptions.getRetrySettings().getInitialRetryDelayDuration())).put("gcp.firestore.settings.retry_settings.max_retry_delay", this.durationString(this.firestoreOptions.getRetrySettings().getMaxRetryDelayDuration())).put("gcp.firestore.settings.retry_settings.retry_delay_multiplier", String.valueOf(this.firestoreOptions.getRetrySettings().getRetryDelayMultiplier())).put("gcp.firestore.settings.retry_settings.max_attempts", String.valueOf(this.firestoreOptions.getRetrySettings().getMaxAttempts())).put("gcp.firestore.settings.retry_settings.initial_rpc_timeout", this.durationString(this.firestoreOptions.getRetrySettings().getInitialRpcTimeoutDuration())).put("gcp.firestore.settings.retry_settings.max_rpc_timeout", this.durationString(this.firestoreOptions.getRetrySettings().getMaxRpcTimeoutDuration())).put("gcp.firestore.settings.retry_settings.rpc_timeout_multiplier", String.valueOf(this.firestoreOptions.getRetrySettings().getRpcTimeoutMultiplier())).put("gcp.firestore.settings.retry_settings.total_timeout", this.durationString(this.firestoreOptions.getRetrySettings().getTotalTimeoutDuration())).build());
        }
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        double memoryUtilization = (double)(totalMemory - freeMemory) / (double)totalMemory;
        spanBuilder.setAttribute("gcp.firestore.memory_utilization", String.format("%.2f", memoryUtilization * 100.0) + "%");
        return spanBuilder;
    }

    @Override
    public Span startSpan(String spanName) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.PRODUCER);
        io.opentelemetry.api.trace.Span span = this.addSettingsAttributesToCurrentSpan(spanBuilder).startSpan();
        return new Span(span, spanName);
    }

    @Override
    public TraceUtil.Span startSpan(String spanName, TraceUtil.Context parent) {
        assert (parent instanceof Context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setSpanKind(SpanKind.PRODUCER).setParent(((Context)parent).context);
        io.opentelemetry.api.trace.Span span = this.addSettingsAttributesToCurrentSpan(spanBuilder).startSpan();
        return new Span(span, spanName);
    }

    @Override
    @Nonnull
    public TraceUtil.Span currentSpan() {
        return new Span(io.opentelemetry.api.trace.Span.current(), "");
    }

    @Override
    @Nonnull
    public TraceUtil.Context currentContext() {
        return new Context(io.opentelemetry.context.Context.current());
    }

    public class OpenTelemetryGrpcChannelConfigurator
    implements ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> {
        public ManagedChannelBuilder apply(ManagedChannelBuilder managedChannelBuilder) {
            GrpcTelemetry grpcTelemetry = GrpcTelemetry.create((OpenTelemetry)EnabledTraceUtil.this.getOpenTelemetry());
            return managedChannelBuilder.intercept(new ClientInterceptor[]{grpcTelemetry.newClientInterceptor()});
        }
    }

    static class Span
    implements TraceUtil.Span {
        private final io.opentelemetry.api.trace.Span span;
        private final String spanName;

        public Span(io.opentelemetry.api.trace.Span span, String spanName) {
            this.span = span;
            this.spanName = spanName;
        }

        @Override
        public void end() {
            this.span.end();
        }

        @Override
        public void end(Throwable error) {
            this.span.setStatus(StatusCode.ERROR, error.getMessage());
            this.span.recordException(error, Attributes.builder().put("exception.message", error.getMessage()).put("exception.type", error.getClass().getName()).put("exception.stacktrace", Throwables.getStackTraceAsString((Throwable)error)).build());
            this.span.end();
        }

        @Override
        public <T> void endAtFuture(ApiFuture<T> futureValue) {
            final io.opentelemetry.context.Context asyncContext = io.opentelemetry.context.Context.current();
            ApiFutures.addCallback(futureValue, (ApiFutureCallback)new ApiFutureCallback<T>(){

                public void onFailure(Throwable t) {
                    try (io.opentelemetry.context.Scope scope = asyncContext.makeCurrent();){
                        span.addEvent(spanName + " failed.");
                        this.end(t);
                    }
                }

                public void onSuccess(T result) {
                    try (io.opentelemetry.context.Scope scope = asyncContext.makeCurrent();){
                        span.addEvent(spanName + " succeeded.");
                        this.end();
                    }
                }
            });
        }

        @Override
        public TraceUtil.Span addEvent(String name) {
            this.span.addEvent(name);
            return this;
        }

        @Override
        public TraceUtil.Span addEvent(String name, Map<String, Object> attributes) {
            AttributesBuilder attributesBuilder = Attributes.builder();
            attributes.forEach((key, value) -> {
                if (value instanceof Integer) {
                    attributesBuilder.put(key, (long)((Integer)value).intValue());
                } else if (value instanceof Long) {
                    attributesBuilder.put(key, ((Long)value).longValue());
                } else if (value instanceof Double) {
                    attributesBuilder.put(key, ((Double)value).doubleValue());
                } else if (value instanceof Float) {
                    attributesBuilder.put(key, (double)((Float)value).floatValue());
                } else if (value instanceof Boolean) {
                    attributesBuilder.put(key, ((Boolean)value).booleanValue());
                } else if (value instanceof String) {
                    attributesBuilder.put(key, (String)value);
                } else {
                    throw new IllegalArgumentException("Unknown attribute type:" + value.getClass().getSimpleName());
                }
            });
            this.span.addEvent(name, attributesBuilder.build());
            return this;
        }

        @Override
        public TraceUtil.Span setAttribute(String key, int value) {
            this.span.setAttribute("gcp.firestore." + key, (long)value);
            return this;
        }

        @Override
        public TraceUtil.Span setAttribute(String key, String value) {
            this.span.setAttribute("gcp.firestore." + key, value);
            return this;
        }

        @Override
        public TraceUtil.Span setAttribute(String key, boolean value) {
            this.span.setAttribute("gcp.firestore." + key, value);
            return this;
        }

        @Override
        public Scope makeCurrent() {
            return new Scope(this.span.makeCurrent());
        }
    }

    static class Context
    implements TraceUtil.Context {
        private final io.opentelemetry.context.Context context;

        Context(io.opentelemetry.context.Context context) {
            this.context = context;
        }

        @Override
        public Scope makeCurrent() {
            return new Scope(this.context.makeCurrent());
        }
    }

    static class Scope
    implements TraceUtil.Scope {
        private final io.opentelemetry.context.Scope scope;

        Scope(io.opentelemetry.context.Scope scope) {
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }
    }
}

