/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.cloud.firestore.pipeline.stages.AbstractOptions;
import com.google.common.collect.ImmutableMap;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import java.util.Map;

final class InternalOptions {
    public static final InternalOptions EMPTY = new InternalOptions((ImmutableMap<String, Value>)ImmutableMap.of());
    final ImmutableMap<String, Value> options;

    InternalOptions(ImmutableMap<String, Value> options) {
        this.options = options;
    }

    public static InternalOptions of(String key, Value value) {
        return new InternalOptions((ImmutableMap<String, Value>)ImmutableMap.of((Object)key, (Object)value));
    }

    InternalOptions with(String key, Value value) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(this.options.size() + 1));
        builder.putAll(this.options);
        builder.put((Object)key, (Object)value);
        return new InternalOptions((ImmutableMap<String, Value>)builder.buildKeepingLast());
    }

    InternalOptions with(String key, Iterable<Value> values) {
        ArrayValue arrayValue = ArrayValue.newBuilder().addAllValues(values).build();
        return this.with(key, Value.newBuilder().setArrayValue(arrayValue).build());
    }

    InternalOptions with(String key, InternalOptions value) {
        return this.with(key, value.toValue());
    }

    InternalOptions adding(AbstractOptions<?> value) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(this.options.size() + value.toMap().size()));
        builder.putAll(this.options);
        for (Map.Entry entry : value.toMap().entrySet()) {
            builder.put((Object)((String)entry.getKey()), (Object)((Value)entry.getValue()));
        }
        return new InternalOptions((ImmutableMap<String, Value>)builder.buildKeepingLast());
    }

    private Value toValue() {
        MapValue mapValue = MapValue.newBuilder().putAllFields(this.options).build();
        return Value.newBuilder().setMapValue(mapValue).build();
    }
}

