/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.api.core.InternalApi;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.pipeline.stages.InternalOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.common.collect.Iterables;
import com.google.firestore.v1.Value;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@InternalApi
public final class Documents
extends Stage {
    private List<String> documents;

    @InternalApi
    Documents(List<String> documents) {
        super("documents", InternalOptions.EMPTY);
        this.documents = documents;
    }

    @InternalApi
    public static Documents of(DocumentReference ... documents) {
        return new Documents(Arrays.stream(documents).map(doc -> "/" + doc.getPath()).collect(Collectors.toList()));
    }

    @Override
    Iterable<Value> toStageArgs() {
        return Iterables.transform(this.documents, doc -> Value.newBuilder().setReferenceValue(doc).build());
    }
}

