/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.builders;

import java.time.Duration;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.ClusterCommandObjects;
import redis.clients.jedis.CommandFlagsRegistry;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.StaticCommandFlagsRegistry;
import redis.clients.jedis.builders.AbstractClientBuilder;
import redis.clients.jedis.executors.ClusterCommandExecutor;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.providers.ClusterConnectionProvider;
import redis.clients.jedis.providers.ConnectionProvider;

public abstract class ClusterClientBuilder<C>
extends AbstractClientBuilder<ClusterClientBuilder<C>, C> {
    private Set<HostAndPort> nodes = null;
    private int maxAttempts = 5;
    private Duration maxTotalRetriesDuration;
    private Duration topologyRefreshPeriod = null;
    private CommandFlagsRegistry commandFlags = null;

    public ClusterClientBuilder<C> nodes(Set<HostAndPort> nodes) {
        this.nodes = nodes;
        return this;
    }

    public ClusterClientBuilder<C> maxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public ClusterClientBuilder<C> maxTotalRetriesDuration(Duration maxTotalRetriesDuration) {
        this.maxTotalRetriesDuration = maxTotalRetriesDuration;
        return this;
    }

    public ClusterClientBuilder<C> topologyRefreshPeriod(Duration topologyRefreshPeriod) {
        this.topologyRefreshPeriod = topologyRefreshPeriod;
        return this;
    }

    public ClusterClientBuilder<C> commandFlags(CommandFlagsRegistry commandFlags) {
        this.commandFlags = commandFlags;
        return this;
    }

    @Override
    protected ClusterClientBuilder<C> self() {
        return this;
    }

    @Override
    protected ConnectionProvider createDefaultConnectionProvider() {
        return new ClusterConnectionProvider(this.nodes, this.clientConfig, this.cache, (GenericObjectPoolConfig<Connection>)this.poolConfig, this.topologyRefreshPeriod);
    }

    protected CommandFlagsRegistry createDefaultCommandFlagsRegistry() {
        return StaticCommandFlagsRegistry.registry();
    }

    @Override
    protected CommandExecutor createDefaultCommandExecutor() {
        if (this.commandFlags == null) {
            this.commandFlags = this.createDefaultCommandFlagsRegistry();
        }
        Duration effectiveMaxTotalRetriesDuration = this.maxTotalRetriesDuration == null ? Duration.ofMillis((long)this.clientConfig.getSocketTimeoutMillis() * (long)this.maxAttempts) : this.maxTotalRetriesDuration;
        return new ClusterCommandExecutor((ClusterConnectionProvider)this.connectionProvider, this.maxAttempts, effectiveMaxTotalRetriesDuration, this.commandFlags);
    }

    @Override
    protected CommandObjects createDefaultCommandObjects() {
        return new ClusterCommandObjects();
    }

    @Override
    protected void validateSpecificConfiguration() {
        this.validateCommonConfiguration();
        if (this.nodes == null || this.nodes.isEmpty()) {
            throw new IllegalArgumentException("At least one cluster node must be specified for cluster mode");
        }
        if (this.maxAttempts <= 0) {
            throw new IllegalArgumentException("Max attempts must be positive for cluster mode");
        }
        if (this.maxTotalRetriesDuration != null && this.maxTotalRetriesDuration.isNegative()) {
            throw new IllegalArgumentException("Max total retries duration cannot be negative for cluster mode");
        }
        if (this.topologyRefreshPeriod != null && this.topologyRefreshPeriod.isNegative()) {
            throw new IllegalArgumentException("Topology refresh period cannot be negative for cluster mode");
        }
    }
}

