/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.net.URI;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpResponse;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpReceiver
implements Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiver.class);
    private final HttpChannel channel;
    private final SerializedInvoker invoker;
    private ResponseState responseState = ResponseState.IDLE;
    private ContentSource rawContentSource;
    private Content.Source contentSource;
    private Throwable failure;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
        Executor executor = channel.getHttpDestination().getHttpClient().getExecutor();
        this.invoker = new SerializedInvoker(HttpReceiver.class.getSimpleName(), executor);
    }

    protected abstract Content.Chunk read(boolean var1);

    protected abstract void onInterim();

    protected abstract void failAndClose(Throwable var1);

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState == ResponseState.FAILURE;
    }

    protected boolean hasContent() {
        return this.contentSource != null;
    }

    protected void responseBegin(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseBegin for {} on {}", (Object)exchange, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseBegin for {} on {}", (Object)exchange, (Object)this);
            }
            if (exchange.isResponseCompleteOrTerminated()) {
                return;
            }
            this.responseState = ResponseState.BEGIN;
            HttpResponse response = exchange.getResponse();
            HttpConversation conversation = exchange.getConversation();
            HttpClient client = this.getHttpDestination().getHttpClient();
            ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
            Response.Listener handlerListener = null;
            if (protocolHandler != null) {
                handlerListener = protocolHandler.getResponseListener();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} found protocol handler {}", (Object)response, (Object)protocolHandler);
                }
            }
            conversation.updateResponseListeners(handlerListener);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying response begin for {} on {}", (Object)exchange, (Object)this);
            }
            conversation.getResponseListeners().notifyBegin(response);
        });
    }

    protected void responseHeader(HttpExchange exchange, HttpField field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeader {} for {} on {}", new Object[]{field, exchange, this});
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeader for {} on {}", (Object)exchange, (Object)this);
            }
            if (exchange.isResponseCompleteOrTerminated()) {
                return;
            }
            this.responseState = ResponseState.HEADER;
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying response header {} for {} on {}", new Object[]{field, exchange, this});
            }
            boolean process = exchange.getConversation().getResponseListeners().notifyHeader(response, field);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notified response header {}, processing {}", (Object)field, (Object)(process ? "needed" : "skipped"));
            }
            if (process) {
                response.addHeader(field);
                HttpHeader fieldHeader = field.getHeader();
                if (fieldHeader != null) {
                    switch (fieldHeader) {
                        case SET_COOKIE: 
                        case SET_COOKIE2: {
                            URI uri = exchange.getRequest().getURI();
                            if (uri == null) break;
                            this.storeCookie(uri, field);
                        }
                    }
                }
            }
        });
    }

    protected void storeCookie(URI uri, HttpField field) {
        this.getHttpDestination().getHttpClient().putCookie(uri, field);
    }

    protected void responseHeaders(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeaders for {} on {}", (Object)exchange, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeaders for {} on {}", (Object)exchange, (Object)this);
            }
            if (exchange.isResponseCompleteOrTerminated()) {
                return;
            }
            this.responseState = ResponseState.HEADERS;
            HttpResponse response = exchange.getResponse();
            HttpFields responseHeaders = response.getHeaders();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response headers {}{}{}", new Object[]{response, System.lineSeparator(), responseHeaders.toString().trim()});
            }
            ContentDecoder.Factory decoderFactory = null;
            if (!HttpMethod.HEAD.is(exchange.getRequest().getMethod())) {
                int comma;
                String contentEncoding = responseHeaders.getLast(HttpHeader.CONTENT_ENCODING);
                if (contentEncoding != null && (comma = contentEncoding.indexOf(",")) > 0) {
                    List values = new QuotedCSV(false, new String[]{contentEncoding}).getValues();
                    contentEncoding = (String)values.get(values.size() - 1);
                }
                for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                    if (!factory.getEncoding().equalsIgnoreCase(contentEncoding)) continue;
                    decoderFactory = factory;
                    this.beforeDecoding(response, contentEncoding);
                    break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying response headers for {} on {}", (Object)exchange, (Object)this);
            }
            ResponseListeners responseListeners = exchange.getConversation().getResponseListeners();
            responseListeners.notifyHeaders(response);
            if (exchange.isResponseCompleteOrTerminated()) {
                return;
            }
            if (HttpStatus.isInterim((int)response.getStatus())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interim response status {}, succeeding", (Object)response.getStatus());
                }
                this.responseSuccess(this::onInterim);
                return;
            }
            this.responseState = ResponseState.CONTENT;
            if (this.rawContentSource != null) {
                throw new IllegalStateException();
            }
            this.rawContentSource = new ContentSource();
            this.contentSource = this.rawContentSource;
            if (decoderFactory != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Decoding {} response content for {} on {}", new Object[]{decoderFactory.getEncoding(), exchange, this});
                }
                this.contentSource = new DecodedContentSource(decoderFactory.newDecoderContentSource(this.rawContentSource), response);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying response content {} for {} on {}", new Object[]{this.contentSource, exchange, this});
            }
            responseListeners.notifyContentSource(response, this.contentSource);
        });
    }

    protected void responseContentAvailable(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseContentAvailable for {} on {}", (Object)exchange, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseContentAvailable for {} on {}", (Object)exchange, (Object)this);
            }
            if (exchange.isResponseCompleteOrTerminated()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying data available for {} on {}", (Object)exchange, (Object)this);
            }
            this.rawContentSource.onDataAvailable();
        });
    }

    protected void responseSuccess(Runnable afterSuccessTask) {
        HttpExchange exchange = this.getHttpExchange();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseSuccess for {} on {}", (Object)exchange, (Object)this);
        }
        if (exchange == null || !exchange.responseComplete(null)) {
            return;
        }
        Runnable successTask = () -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseSuccess for {} on {}", (Object)exchange, (Object)this);
            }
            this.responseState = ResponseState.IDLE;
            this.reset();
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying response success for {} on {}", (Object)exchange, (Object)this);
            }
            exchange.getConversation().getResponseListeners().notifySuccess(response);
            if (HttpStatus.isInterim((int)exchange.getResponse().getStatus())) {
                return;
            }
            this.terminateResponse(exchange);
        };
        if (afterSuccessTask == null) {
            this.invoker.run(successTask);
        } else {
            this.invoker.run(new Runnable[]{successTask, afterSuccessTask});
        }
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange = this.getHttpExchange();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response failure {} for {} on {}", new Object[]{failure, exchange, this});
        }
        if (exchange != null && exchange.responseComplete(failure)) {
            this.abort(exchange, failure, promise);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Already failed on {}", (Object)this);
            }
            promise.succeeded((Object)false);
        }
    }

    private void terminateResponse(HttpExchange exchange) {
        Result result = exchange.terminateResponse();
        this.terminateResponse(exchange, result);
    }

    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}, result: {}", (Object)response, (Object)result);
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(exchange, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", (Object)(this.failure == null ? "succeeded" : "failed"), (Object)result);
            }
            exchange.getConversation().getResponseListeners().notifyComplete(result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
        }
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.getInvocationType((Object)this.contentSource);
    }

    protected void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting {}", (Object)this);
        }
        this.cleanup();
    }

    protected void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing {}", (Object)this);
        }
        this.cleanup();
    }

    private void cleanup() {
        this.rawContentSource = null;
        this.contentSource = null;
    }

    public void abort(HttpExchange exchange, Throwable failure, Promise<Boolean> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.atDebug().setCause(failure).log("Invoking abort for {} on {}", (Object)exchange, (Object)this);
        }
        if (!exchange.isResponseCompleteOrTerminated()) {
            throw new IllegalStateException();
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing abort with {} on {}", (Object)failure, (Object)this);
            }
            if (this.responseState == ResponseState.FAILURE) {
                promise.succeeded((Object)false);
                return;
            }
            this.responseState = ResponseState.FAILURE;
            this.failure = failure;
            if (this.contentSource != null) {
                this.contentSource.fail(failure);
            }
            this.dispose();
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying response failure {} for {} on {}", new Object[]{failure, exchange, this});
            }
            exchange.getConversation().getResponseListeners().notifyFailure(response, failure);
            this.terminateResponse(exchange);
            promise.succeeded((Object)true);
        });
    }

    private void beforeDecoding(Response response, String contentEncoding) {
        HttpResponse httpResponse = (HttpResponse)response;
        httpResponse.headers(headers -> {
            boolean seenContentEncoding = false;
            ListIterator iterator = headers.listIterator(headers.size());
            while (iterator.hasPrevious()) {
                HttpField field = (HttpField)iterator.previous();
                HttpHeader header = field.getHeader();
                if (header == HttpHeader.CONTENT_LENGTH) {
                    iterator.remove();
                    continue;
                }
                if (header != HttpHeader.CONTENT_ENCODING || seenContentEncoding) continue;
                seenContentEncoding = true;
                String value = field.getValue();
                int comma = value.lastIndexOf(",");
                if (comma < 0) {
                    iterator.remove();
                    continue;
                }
                iterator.set(new HttpField(HttpHeader.CONTENT_ENCODING, value.substring(0, comma)));
            }
        });
    }

    private void afterDecoding(Response response, long decodedLength) {
        HttpResponse httpResponse = (HttpResponse)response;
        httpResponse.headers(headers -> {
            headers.remove(HttpHeader.TRANSFER_ENCODING);
            headers.put(HttpHeader.CONTENT_LENGTH, decodedLength);
        });
    }

    public String toString() {
        return String.format("%s@%x(ex=%s,rsp=%s,failure=%s)", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getHttpExchange(), this.responseState, this.failure});
    }

    private static enum ResponseState {
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }

    private class ContentSource
    implements Content.Source,
    Invocable {
        private static final Logger LOG = LoggerFactory.getLogger(ContentSource.class);
        private final AtomicReference<Runnable> demandCallbackRef = new AtomicReference();
        private final AutoLock lock = new AutoLock();
        private final Runnable processDemand = this::processDemand;
        private Content.Chunk currentChunk;

        private ContentSource() {
        }

        public Content.Chunk read() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading from {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
                this.currentChunk = Content.Chunk.next((Content.Chunk)current);
                if (current != null) {
                    Content.Chunk chunk = current;
                    return chunk;
                }
            }
            current = HttpReceiver.this.read(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read {} from {}", (Object)current, (Object)this);
            }
            ignored = this.lock.lock();
            try {
                if (this.currentChunk != null) {
                    if (current != null) {
                        current.release();
                    }
                    Content.Chunk chunk = this.currentChunk;
                    return chunk;
                }
                this.currentChunk = Content.Chunk.next((Content.Chunk)current);
                Content.Chunk chunk = current;
                return chunk;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }

        private void onDataAvailable() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onDataAvailable on {}", (Object)this);
            }
            HttpReceiver.this.invoker.assertCurrentThreadInvoking();
            this.invokeDemandCallback(false);
        }

        public Invocable.InvocationType getInvocationType() {
            Runnable demandCallback = this.demandCallbackRef.get();
            if (demandCallback != null) {
                return Invocable.getInvocationType((Object)demandCallback);
            }
            return Invocable.getInvocationType((Object)HttpReceiver.this.getHttpChannel().getConnection());
        }

        public void demand(Runnable demandCallback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering demand on {}", (Object)this);
            }
            if (demandCallback == null) {
                throw new IllegalArgumentException();
            }
            if (!this.demandCallbackRef.compareAndSet(null, demandCallback)) {
                throw new IllegalStateException();
            }
            HttpReceiver.this.invoker.run(this.processDemand);
        }

        private void processDemand() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing demand on {}", (Object)this);
            }
            HttpReceiver.this.invoker.assertCurrentThreadInvoking();
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
            }
            if (current == null) {
                current = HttpReceiver.this.read(true);
                if (current == null) {
                    return;
                }
                ignored = this.lock.lock();
                try {
                    if (this.currentChunk != null) {
                        current.release();
                        return;
                    }
                    this.currentChunk = current;
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            this.invokeDemandCallback(false);
        }

        private void invokeDemandCallback(boolean invoke) {
            Runnable demandCallback = this.demandCallbackRef.getAndSet(null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking demand callback {} on {}", (Object)demandCallback, (Object)this);
            }
            if (demandCallback == null) {
                return;
            }
            try {
                if (invoke) {
                    HttpReceiver.this.invoker.run(demandCallback);
                } else {
                    HttpReceiver.this.invoker.assertCurrentThreadInvoking();
                    demandCallback.run();
                }
            }
            catch (Throwable x) {
                this.fail(x);
            }
        }

        public void fail(Throwable failure) {
            boolean failed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failing {}", (Object)this);
            }
            if (failed = this.error(failure)) {
                HttpReceiver.this.failAndClose(failure);
            }
            this.invokeDemandCallback(true);
        }

        private boolean error(Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Erroring {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                if (Content.Chunk.isFailure((Content.Chunk)this.currentChunk)) {
                    Throwable cause = this.currentChunk.getFailure();
                    if (!this.currentChunk.isLast()) {
                        this.currentChunk = Content.Chunk.from((Throwable)cause, (boolean)true);
                    }
                    ExceptionUtil.addSuppressedIfNotAssociated((Throwable)cause, (Throwable)failure);
                    boolean bl = false;
                    return bl;
                }
                if (this.currentChunk != null) {
                    this.currentChunk.release();
                }
                this.currentChunk = Content.Chunk.from((Throwable)failure);
            }
            return true;
        }

        private Content.Chunk chunk() {
            try (AutoLock ignored = this.lock.lock();){
                Content.Chunk chunk = this.currentChunk;
                return chunk;
            }
        }

        public String toString() {
            return String.format("%s@%x{c=%s,d=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.chunk(), this.demandCallbackRef);
        }
    }

    private class DecodedContentSource
    implements Content.Source,
    Invocable {
        private static final Logger LOG = LoggerFactory.getLogger(DecodedContentSource.class);
        private final Content.Source source;
        private final Response response;
        private long decodedLength;
        private boolean last;

        private DecodedContentSource(Content.Source source, Response response) {
            this.source = source;
            this.response = response;
        }

        public long getLength() {
            return this.source.getLength();
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)this.source);
        }

        public Content.Chunk read() {
            Content.Chunk chunk;
            while (true) {
                chunk = this.source.read();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Decoded chunk {}", (Object)chunk);
                }
                if (chunk == null) {
                    return null;
                }
                if (!chunk.isEmpty() || chunk.isLast()) break;
                chunk.release();
            }
            this.decodedLength += (long)chunk.remaining();
            if (chunk.isLast() && !this.last) {
                this.last = true;
                HttpReceiver.this.afterDecoding(this.response, this.decodedLength);
            }
            return chunk;
        }

        public void demand(Runnable demandCallback) {
            Invocable.ReadyTask demand = new Invocable.ReadyTask(Invocable.getInvocationType((Object)demandCallback), () -> HttpReceiver.this.invoker.run(demandCallback));
            this.source.demand((Runnable)demand);
        }

        public void fail(Throwable failure) {
            this.source.fail(failure);
        }

        public void fail(Throwable failure, boolean last) {
            this.source.fail(failure, last);
        }

        public boolean rewind() {
            boolean rewound = this.source.rewind();
            if (rewound) {
                this.decodedLength = 0L;
                this.last = false;
            }
            return rewound;
        }
    }
}

