/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.concurrent;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.concurrent.BasicNode;
import scala.collection.concurrent.CNode$;
import scala.collection.concurrent.CNodeBase;
import scala.collection.concurrent.Gen;
import scala.collection.concurrent.INode;
import scala.collection.concurrent.MainNode;
import scala.collection.concurrent.SNode;
import scala.collection.concurrent.TNode;
import scala.collection.concurrent.TrieMap;
import scala.math.Equiv;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public final class CNode<K, V>
extends CNodeBase<K, V> {
    private final int bitmap;
    private final BasicNode[] array;
    private final Gen gen;

    public static <K, V> MainNode<K, V> dual(SNode<K, V> sNode, int n, SNode<K, V> sNode2, int n2, int n3, Gen gen, Equiv<K> equiv) {
        return CNode$.MODULE$.dual(sNode, n, sNode2, n2, n3, gen, equiv);
    }

    public CNode(int bitmap, BasicNode[] array, Gen gen) {
        this.bitmap = bitmap;
        this.array = array;
        this.gen = gen;
    }

    public int bitmap() {
        return this.bitmap;
    }

    public BasicNode[] array() {
        return this.array;
    }

    public Gen gen() {
        return this.gen;
    }

    @Override
    public int cachedSize(Object ct) {
        int currsz = this.READ_SIZE();
        if (currsz != -1) {
            return currsz;
        }
        int sz = this.computeSize((TrieMap)ct);
        while (this.READ_SIZE() == -1) {
            this.CAS_SIZE(-1, sz);
        }
        return this.READ_SIZE();
    }

    @Override
    public int knownSize() {
        return this.READ_SIZE();
    }

    private int computeSize(TrieMap<K, V> ct) {
        int offset;
        int sz = 0;
        int n = offset = this.array().length > 0 ? ThreadLocalRandom.current().nextInt(0, this.array().length) : 0;
        for (int i = 0; i < this.array().length; ++i) {
            int pos = (i + offset) % this.array().length;
            BasicNode basicNode = this.array()[pos];
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                ++sz;
                continue;
            }
            if (basicNode instanceof INode) {
                INode iNode;
                INode in = iNode = (INode)basicNode;
                sz += in.cachedSize(ct);
                continue;
            }
            BasicNode basicNode2 = basicNode;
            throw new MatchError(basicNode2);
        }
        return sz;
    }

    public CNode<K, V> updatedAt(int pos, BasicNode nn, Gen gen) {
        int len = this.array().length;
        BasicNode[] narr = new BasicNode[len];
        Array$.MODULE$.copy(this.array(), 0, narr, 0, len);
        narr[pos] = nn;
        return new CNode<K, V>(this.bitmap(), narr, gen);
    }

    public CNode<K, V> removedAt(int pos, int flag, Gen gen) {
        BasicNode[] arr = this.array();
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len - 1];
        Array$.MODULE$.copy(arr, 0, narr, 0, pos);
        Array$.MODULE$.copy(arr, pos + 1, narr, pos, len - pos - 1);
        return new CNode<K, V>(this.bitmap() ^ flag, narr, gen);
    }

    public CNode<K, V> insertedAt(int pos, int flag, K k, V v, int hc, Gen gen) {
        int len = this.array().length;
        int bmp = this.bitmap();
        BasicNode[] narr = new BasicNode[len + 1];
        Array$.MODULE$.copy(this.array(), 0, narr, 0, pos);
        narr[pos] = new SNode<K, V>(k, v, hc);
        Array$.MODULE$.copy(this.array(), pos, narr, pos + 1, len - pos);
        return new CNode<K, V>(bmp | flag, narr, gen);
    }

    public CNode<K, V> renewed(Gen ngen, TrieMap<K, V> ct) {
        BasicNode[] arr = this.array();
        int len = arr.length;
        BasicNode[] narr = new BasicNode[len];
        for (int i = 0; i < len; ++i) {
            BasicNode basicNode = arr[i];
            if (basicNode instanceof INode) {
                INode iNode;
                INode in = iNode = (INode)basicNode;
                narr[i] = in.copyToGen(ngen, ct);
                continue;
            }
            if (basicNode != null) {
                BasicNode basicNode2;
                BasicNode bn;
                narr[i] = bn = (basicNode2 = basicNode);
                continue;
            }
            throw new MatchError(basicNode);
        }
        return new CNode<K, V>(this.bitmap(), narr, ngen);
    }

    private BasicNode resurrect(INode<K, V> inode, Object inodemain) {
        Object object = inodemain;
        if (object instanceof TNode) {
            TNode tNode;
            TNode tn = tNode = (TNode)object;
            return tn.copyUntombed();
        }
        return inode;
    }

    public MainNode<K, V> toContracted(int lev) {
        if (this.array().length == 1 && lev > 0) {
            BasicNode basicNode = this.array()[0];
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                return sn.copyTombed();
            }
            return this;
        }
        return this;
    }

    public MainNode<K, V> toCompressed(TrieMap<K, V> ct, int lev, Gen gen) {
        int bmp = this.bitmap();
        BasicNode[] arr = this.array();
        BasicNode[] tmparray = new BasicNode[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            BasicNode sub = arr[i];
            BasicNode basicNode = sub;
            if (basicNode instanceof INode) {
                INode iNode = (INode)basicNode;
                INode in = iNode;
                MainNode<K, V> inodemain = in.gcasRead(ct);
                if (!(!(inodemain == null))) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                tmparray[i] = this.resurrect(in, inodemain);
                continue;
            }
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                tmparray[i] = sn;
                continue;
            }
            BasicNode basicNode2 = basicNode;
            throw new MatchError(basicNode2);
        }
        return new CNode<K, V>(bmp, tmparray, gen).toContracted(lev);
    }

    @Override
    public String string(int lev) {
        Object[] objectArray = new Object[2];
        objectArray[0] = BoxesRunTime.boxToInteger(this.bitmap());
        Object object = Predef$.MODULE$.refArrayOps(this.array());
        objectArray[1] = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1<BasicNode, String> & Serializable)_$2 -> _$2.string(lev + 1), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("CNode %x\n%s"), ScalaRunTime$.MODULE$.genericWrapArray(objectArray));
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension("CNode(sz: %d; %s)", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.elems$1().size()), ((IterableOnceOps)this.elems$1().sorted(Ordering$String$.MODULE$)).mkString(", ")}));
    }

    private final Seq elems$1() {
        Object object = Predef$.MODULE$.refArrayOps(this.array());
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1<BasicNode, Iterable> & Serializable)x$1 -> {
            BasicNode basicNode = x$1;
            if (basicNode instanceof SNode) {
                SNode sNode;
                SNode sn = sNode = (SNode)basicNode;
                return Iterable$.MODULE$.single(sn.kvPair()._2().toString());
            }
            if (basicNode instanceof INode) {
                INode iNode;
                INode in = iNode = (INode)basicNode;
                return Iterable$.MODULE$.single(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(in.toString()), 14) + "(" + in.gen + ")");
            }
            BasicNode basicNode2 = basicNode;
            throw new MatchError(basicNode2);
        }, ClassTag$.MODULE$.apply(String.class)));
    }
}

