/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class StringParsers$
implements Serializable {
    public static final StringParsers$ MODULE$ = new StringParsers$();

    private StringParsers$() {
    }

    static {
        int intOverflowBoundary = -214748364;
        int intOverflowDigit = 9;
        long longOverflowBoundary = -922337203685477580L;
        int longOverflowDigit = 9;
        boolean POS = true;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringParsers$.class);
    }

    private final int decValue(char ch) {
        return Character.digit(ch, 10);
    }

    private final Option<Object> stepToOverflow(String from, int len, int agg, boolean isPositive, int min) {
        return this.rec$1(min, len, isPositive, from, 1, agg);
    }

    private final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public final Option<Object> parseBool(String from) {
        if (from.equalsIgnoreCase("true")) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(true));
        }
        if (from.equalsIgnoreCase("false")) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(false));
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseByte(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        int v = this.decValue(first);
        if (len == 1) {
            if (v > -1) {
                return Some$.MODULE$.apply(BoxesRunTime.boxToByte((byte)v));
            }
            return None$.MODULE$;
        }
        if (v > -1) {
            return this.stepToOverflow(from, len, -v, true, -128).map((Function1<Object, Byte> & Serializable)_$1 -> StringParsers$.parseByte$$anonfun$1(BoxesRunTime.unboxToInt(_$1)));
        }
        if (first == '+') {
            return this.stepToOverflow(from, len, 0, true, -128).map((Function1<Object, Byte> & Serializable)_$2 -> StringParsers$.parseByte$$anonfun$2(BoxesRunTime.unboxToInt(_$2)));
        }
        if (first == '-') {
            return this.stepToOverflow(from, len, 0, false, -128).map((Function1<Object, Byte> & Serializable)_$3 -> StringParsers$.parseByte$$anonfun$3(BoxesRunTime.unboxToInt(_$3)));
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseShort(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        int v = this.decValue(first);
        if (len == 1) {
            if (v > -1) {
                return Some$.MODULE$.apply(BoxesRunTime.boxToShort((short)v));
            }
            return None$.MODULE$;
        }
        if (v > -1) {
            return this.stepToOverflow(from, len, -v, true, Short.MIN_VALUE).map((Function1<Object, Short> & Serializable)_$4 -> StringParsers$.parseShort$$anonfun$1(BoxesRunTime.unboxToInt(_$4)));
        }
        if (first == '+') {
            return this.stepToOverflow(from, len, 0, true, Short.MIN_VALUE).map((Function1<Object, Short> & Serializable)_$5 -> StringParsers$.parseShort$$anonfun$2(BoxesRunTime.unboxToInt(_$5)));
        }
        if (first == '-') {
            return this.stepToOverflow(from, len, 0, false, Short.MIN_VALUE).map((Function1<Object, Short> & Serializable)_$6 -> StringParsers$.parseShort$$anonfun$3(BoxesRunTime.unboxToInt(_$6)));
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseInt(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        int v = this.decValue(first);
        if (len == 1) {
            if (v > -1) {
                return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(v));
            }
            return None$.MODULE$;
        }
        if (v > -1) {
            return this.step$1(len, from, 1, -v, true);
        }
        if (first == '+') {
            return this.step$1(len, from, 1, 0, true);
        }
        if (first == '-') {
            return this.step$1(len, from, 1, 0, false);
        }
        return None$.MODULE$;
    }

    public final Option<Object> parseLong(String from) {
        int len = from.length();
        if (len == 0) {
            return None$.MODULE$;
        }
        char first = from.charAt(0);
        long v = this.decValue(first);
        if (len == 1) {
            if (v > -1L) {
                return Some$.MODULE$.apply(BoxesRunTime.boxToLong(v));
            }
            return None$.MODULE$;
        }
        if (v > -1L) {
            return this.step$2(len, from, 1, -v, true);
        }
        if (first == '+') {
            return this.step$2(len, from, 1, 0L, true);
        }
        if (first == '-') {
            return this.step$2(len, from, 1, 0L, false);
        }
        return None$.MODULE$;
    }

    public final boolean checkFloatFormat(String format) {
        int unsigned;
        String string2 = Predef$.MODULE$.augmentString(format);
        int unspacedStart = StringOps$.MODULE$.indexWhere$extension(string2, (Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)ch -> StringParsers$.$anonfun$6(BoxesRunTime.unboxToChar(ch)), StringOps$.MODULE$.indexWhere$default$2$extension(string2));
        String string3 = Predef$.MODULE$.augmentString(format);
        int unspacedEnd = StringOps$.MODULE$.lastIndexWhere$extension(string3, (Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)ch -> StringParsers$.$anonfun$7(BoxesRunTime.unboxToChar(ch)), StringOps$.MODULE$.lastIndexWhere$default$2$extension(string3)) + 1;
        if (unspacedStart == -1 || unspacedStart >= unspacedEnd || unspacedEnd <= 0) {
            return false;
        }
        char startchar = format.charAt(unspacedStart);
        int n = unsigned = startchar == '-' || startchar == '+' ? unspacedStart + 1 : unspacedStart;
        if (unsigned >= unspacedEnd) {
            return false;
        }
        if (format.charAt(unsigned) == 'N') {
            String string4 = format.substring(unsigned, unspacedEnd);
            String string5 = "NaN";
            return !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (format.charAt(unsigned) == 'I') {
            String string6 = format.substring(unsigned, unspacedEnd);
            String string7 = "Infinity";
            return !(string6 != null ? !string6.equals(string7) : string7 != null);
        }
        char endchar = format.charAt(unspacedEnd - 1);
        int desuffixed = endchar == 'f' || endchar == 'F' || endchar == 'd' || endchar == 'D' ? unspacedEnd - 1 : unspacedEnd;
        int len = desuffixed - unsigned;
        if (len <= 0) {
            return false;
        }
        if (len >= 2 && (format.charAt(unsigned + 1) == 'x' || format.charAt(unsigned + 1) == 'X')) {
            return format.charAt(unsigned) == '0' && this.isHexFloatLiteral$1(format, unsigned + 2, desuffixed);
        }
        return this.isDecFloatLiteral$1(format, unsigned, desuffixed);
    }

    public Option<Object> parseFloat(String from) {
        if (this.checkFloatFormat(from)) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToFloat(Float.parseFloat(from)));
        }
        return None$.MODULE$;
    }

    public Option<Object> parseDouble(String from) {
        if (this.checkFloatFormat(from)) {
            return Some$.MODULE$.apply(BoxesRunTime.boxToDouble(Double.parseDouble(from)));
        }
        return None$.MODULE$;
    }

    private final Option rec$1(int min$1, int len$1, boolean isPositive$1, String from$1, int i, int agg) {
        while (agg >= min$1) {
            if (i == len$1) {
                if (!isPositive$1) {
                    return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(agg));
                }
                if (agg == min$1) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(-agg));
            }
            int digit = this.decValue(from$1.charAt(i));
            if (digit == -1) {
                return None$.MODULE$;
            }
            int n = i + 1;
            int n2 = agg * 10 - digit;
            i = n;
            agg = n2;
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ byte parseByte$$anonfun$1(int _$1) {
        return (byte)_$1;
    }

    private static final /* synthetic */ byte parseByte$$anonfun$2(int _$2) {
        return (byte)_$2;
    }

    private static final /* synthetic */ byte parseByte$$anonfun$3(int _$3) {
        return (byte)_$3;
    }

    private static final /* synthetic */ short parseShort$$anonfun$1(int _$4) {
        return (short)_$4;
    }

    private static final /* synthetic */ short parseShort$$anonfun$2(int _$5) {
        return (short)_$5;
    }

    private static final /* synthetic */ short parseShort$$anonfun$3(int _$6) {
        return (short)_$6;
    }

    private final Option step$1(int len$2, String from$2, int i, int agg, boolean isPositive) {
        while (true) {
            if (i == len$2) {
                if (!isPositive) {
                    return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(agg));
                }
                if (agg == Integer.MIN_VALUE) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply(BoxesRunTime.boxToInteger(-agg));
            }
            if (agg < -214748364) {
                return None$.MODULE$;
            }
            int digit = this.decValue(from$2.charAt(i));
            if (digit == -1 || agg == -214748364 && digit == 9) {
                return None$.MODULE$;
            }
            int n = i + 1;
            int n2 = agg * 10 - digit;
            i = n;
            agg = n2;
        }
    }

    private final Option step$2(int len$3, String from$3, int i, long agg, boolean isPositive) {
        while (true) {
            if (i == len$3) {
                if (isPositive && agg == Long.MIN_VALUE) {
                    return None$.MODULE$;
                }
                if (isPositive) {
                    return Some$.MODULE$.apply(BoxesRunTime.boxToLong(-agg));
                }
                return Some$.MODULE$.apply(BoxesRunTime.boxToLong(agg));
            }
            if (agg < -922337203685477580L) {
                return None$.MODULE$;
            }
            int digit = this.decValue(from$3.charAt(i));
            if (digit == -1 || agg == -922337203685477580L && digit == 9) {
                return None$.MODULE$;
            }
            int n = i + 1;
            long l = agg * 10L - (long)digit;
            i = n;
            agg = l;
        }
    }

    private final boolean rec$2(int end$1, Function1 pred$1, String format$1, int i) {
        boolean bl;
        block3: {
            block2: {
                while (i < end$1) {
                    if (BoxesRunTime.unboxToBoolean(pred$1.apply(BoxesRunTime.boxToCharacter(format$1.charAt(i))))) {
                        ++i;
                        continue;
                    }
                    break block2;
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean forAllBetween$1(String format$2, int start, int end, Function1 pred) {
        return this.rec$2(end, pred, format$2, start);
    }

    private final int rec$3(int until$1, Function1 predicate$1, String format$3, int i) {
        while (i < until$1 && BoxesRunTime.unboxToBoolean(predicate$1.apply(BoxesRunTime.boxToCharacter(format$3.charAt(i))))) {
            ++i;
        }
        return i;
    }

    private final int skipIndexWhile$1(String format$4, Function1 predicate, int from, int until) {
        return this.rec$3(until, predicate, format$4, from);
    }

    private final boolean isHexDigit$1(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private final /* synthetic */ boolean prefixOK$1$$anonfun$1(char ch) {
        return this.isHexDigit$1(ch);
    }

    private final /* synthetic */ boolean $anonfun$1(char ch) {
        return this.isHexDigit$1(ch);
    }

    private final /* synthetic */ boolean prefixOK$1$$anonfun$2(char ch) {
        return this.isHexDigit$1(ch);
    }

    private final boolean prefixOK$1(String format$6, int startIndex, int endIndex) {
        int noLeading;
        int len = endIndex - startIndex;
        return len > 0 && !(format$6.charAt(startIndex) != '.' ? (noLeading = this.skipIndexWhile$1(format$6, (Function1<Object, Boolean> & Serializable)ch -> this.$anonfun$1(BoxesRunTime.unboxToChar(ch)), startIndex, endIndex)) < endIndex && (format$6.charAt(noLeading) != '.' || !this.forAllBetween$1(format$6, noLeading + 1, endIndex, (Function1<Object, Boolean> & Serializable)ch -> this.prefixOK$1$$anonfun$2(BoxesRunTime.unboxToChar(ch)))) : len <= 1 || !this.forAllBetween$1(format$6, startIndex + 1, endIndex, (Function1<Object, Boolean> & Serializable)ch -> this.prefixOK$1$$anonfun$1(BoxesRunTime.unboxToChar(ch))));
    }

    private final boolean postfixOK$1(String format$7, int startIndex, int endIndex) {
        char startchar;
        return startIndex < endIndex && (this.forAllBetween$1(format$7, startIndex, endIndex, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))) || ((startchar = format$7.charAt(startIndex)) == '+' || startchar == '-') && endIndex - startIndex > 1 && this.forAllBetween$1(format$7, startIndex + 1, endIndex, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c))));
    }

    private static final /* synthetic */ boolean $anonfun$2(char ch) {
        return ch == 'p' || ch == 'P';
    }

    private final boolean isHexFloatLiteral$1(String format$5, int startIndex, int endIndex) {
        int pIndex = StringOps$.MODULE$.indexWhere$extension(Predef$.MODULE$.augmentString(format$5), (Function1<Object, Object>)(Function1<Object, Boolean> & Serializable)ch -> StringParsers$.$anonfun$2(BoxesRunTime.unboxToChar(ch)), startIndex);
        return pIndex <= endIndex && this.prefixOK$1(format$5, startIndex, pIndex) && this.postfixOK$1(format$5, pIndex + 1, endIndex);
    }

    private final boolean isExp$1(char c) {
        return c == 'e' || c == 'E';
    }

    private final boolean expOK$1(String format$9, int startIndex, int endIndex) {
        char startChar;
        return startIndex < endIndex && !((startChar = format$9.charAt(startIndex)) != '+' && startChar != '-' ? this.skipIndexWhile$1(format$9, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c)), startIndex, endIndex) != endIndex : endIndex <= startIndex + 1 || this.skipIndexWhile$1(format$9, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c)), startIndex + 1, endIndex) != endIndex);
    }

    private final boolean isDecFloatLiteral$1(String format$8, int startIndex, int endIndex) {
        char startChar = format$8.charAt(startIndex);
        if (startChar == '.') {
            int noSignificant = this.skipIndexWhile$1(format$8, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c)), startIndex + 1, endIndex);
            return noSignificant > startIndex + 1 && (noSignificant >= endIndex || this.isExp$1(format$8.charAt(noSignificant)) && this.expOK$1(format$8, noSignificant + 1, endIndex));
        }
        if (this.isDigit(startChar)) {
            int noSignificant;
            int noInt = this.skipIndexWhile$1(format$8, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c)), startIndex, endIndex);
            return noInt == endIndex || !(format$8.charAt(noInt) != '.' ? !this.isExp$1(format$8.charAt(noInt)) || !this.expOK$1(format$8, noInt + 1, endIndex) : (noSignificant = this.skipIndexWhile$1(format$8, (Function1<Object, Boolean> & Serializable)c -> StringParsers$.MODULE$.isDigit(BoxesRunTime.unboxToChar(c)), noInt + 1, endIndex)) < endIndex && (!this.isExp$1(format$8.charAt(noSignificant)) || !this.expOK$1(format$8, noSignificant + 1, endIndex)));
        }
        return false;
    }

    private static final /* synthetic */ boolean $anonfun$6(char ch) {
        return ch > ' ';
    }

    private static final /* synthetic */ boolean $anonfun$7(char ch) {
        return ch > ' ';
    }
}

