/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.actions.CopyAggregatorResult;
import com.intellij.database.actions.ShowAggregateViewAction;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridWidget;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.run.actions.ChooseAggregatorsAction;
import com.intellij.database.run.ui.TableAggregatorWidgetHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarEditorBasedWidgetFactory;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AggregatorWidget
extends GridWidget
implements Consumer<MouseEvent>,
StatusBarWidget.Multiframe {
    public static final String AGGREGATOR_WIDGET_HELPER_KEY = "ResultViewAggregatorWidgetHelper";
    public static final String ID = "GridAggregator";

    public AggregatorWidget(@NotNull Project project) {
        if (project == null) {
            AggregatorWidget.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    protected String getWidgetHelperKey() {
        return AGGREGATOR_WIDGET_HELPER_KEY;
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        AggregatorWidget aggregatorWidget = this;
        if (aggregatorWidget == null) {
            AggregatorWidget.$$$reportNull$$$0(1);
        }
        return aggregatorWidget;
    }

    public void consume(MouseEvent event) {
        ScriptedStatusBarWidgetGroup popupGroup = new ScriptedStatusBarWidgetGroup(this.myGrid, this.myStatusBar);
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("StatusBarPlace", (ActionGroup)popupGroup);
        this.myComponentShown = true;
        menu.getComponent().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                AggregatorWidget.this.myComponentShown = false;
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                AggregatorWidget.this.myComponentShown = false;
            }
        });
        menu.getComponent().show(event.getComponent(), event.getPoint().x, event.getPoint().y);
    }

    @Nullable
    public String getTooltipText() {
        return !this.isReady() ? null : DataGridBundle.message((String)"status.bar.grid.aggregator.widget.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public Consumer<MouseEvent> getClickConsumer() {
        AggregatorWidget aggregatorWidget = this;
        if (aggregatorWidget == null) {
            AggregatorWidget.$$$reportNull$$$0(2);
        }
        return aggregatorWidget;
    }

    public float getAlignment() {
        return 1.0f;
    }

    @NotNull
    public StatusBarWidget copy() {
        return new AggregatorWidget(this.myProject);
    }

    private boolean isReady() {
        return this.myGrid != null && !this.myGrid.isEditing() && this.myGrid.getVisibleRowsCount() * this.myGrid.getVisibleColumns().size() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/AggregatorWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/AggregatorWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClickConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class ScriptedStatusBarWidgetGroup
    extends ActionGroup
    implements DumbAware {
        private final DataGrid myGrid;
        private final StatusBar myStatusBar;

        ScriptedStatusBarWidgetGroup(@Nullable DataGrid grid, @Nullable StatusBar statusBar) {
            this.myGrid = grid;
            this.myStatusBar = statusBar;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ScriptedStatusBarWidgetGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null || this.myGrid == null || this.myStatusBar == null) {
                if (EMPTY_ARRAY == null) {
                    ScriptedStatusBarWidgetGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            TableAggregatorWidgetHelper helper = (TableAggregatorWidgetHelper)ObjectUtils.tryCast((Object)this.myGrid.getResultView().getComponent().getClientProperty(AggregatorWidget.AGGREGATOR_WIDGET_HELPER_KEY), TableAggregatorWidgetHelper.class);
            if (helper == null) {
                if (EMPTY_ARRAY == null) {
                    ScriptedStatusBarWidgetGroup.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            JBIterable<AnAction> children = ChooseAggregatorsAction.getChildrenImpl(this.myGrid, (factory, factories) -> new ChooseAggregatorsAction.SelectSingleAggregatorAction(this.myGrid, this.myStatusBar, helper, (DataAggregatorFactory)factory, (List<? extends DataAggregatorFactory>)factories, () -> GridUtil.getSettings(this.myGrid)));
            ShowAggregateViewAction showAggregateViewAction = (ShowAggregateViewAction)ActionManager.getInstance().getAction("Console.TableResult.AggregateView");
            CopyAggregatorResult copyAggregatorResult = (CopyAggregatorResult)ActionManager.getInstance().getAction("Console.TableResult.CopyAggregatorResult");
            showAggregateViewAction.setGrid(this.myGrid);
            copyAggregatorResult.setGrid(this.myGrid);
            JBIterable copySection = JBIterable.of((Object[])new AnAction[]{copyAggregatorResult, new Separator()});
            JBIterable openAggregatorSection = JBIterable.of((Object[])new AnAction[]{new Separator(), showAggregateViewAction});
            JBIterable allElements = copySection.append((Iterable)children.append((Iterable)openAggregatorSection));
            if ("StatusBarPlace".equals(e.getPlace())) {
                AnAction[] anActionArray = (AnAction[])allElements.map(o -> o instanceof Separator ? Separator.getInstance() : o).toArray((Object[])EMPTY_ARRAY);
                if (anActionArray == null) {
                    ScriptedStatusBarWidgetGroup.$$$reportNull$$$0(3);
                }
                return anActionArray;
            }
            AnAction[] anActionArray = (AnAction[])allElements.toArray((Object[])EMPTY_ARRAY);
            if (anActionArray == null) {
                ScriptedStatusBarWidgetGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/datagrid/AggregatorWidget$ScriptedStatusBarWidgetGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class Factory
    extends StatusBarEditorBasedWidgetFactory {
        @NotNull
        public String getId() {
            return AggregatorWidget.ID;
        }

        @NotNull
        public String getDisplayName() {
            String string = DataGridBundle.message((String)"status.bar.grid.aggregator.widget.display.name", (Object[])new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new AggregatorWidget(project);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return this.getFileEditor(statusBar) instanceof TableEditorBase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/AggregatorWidget$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/AggregatorWidget$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

