/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> uvec3(22u, 23u, 4u)) => u64vec3(317891438802ul, 0ul, 5ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) >> uvec3(19u, 1u, 13u)) => u64vec3(2543131510416ul, 42ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) >> uvec3(22u, 23u, 4u)) => u64vec3(0ul, 0ul, 11ul)
 * (u64vec3(167ul, 66ul, 187ul) >> uvec3(19u, 1u, 13u)) => u64vec3(0ul, 33ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> uvec3(22u, 23u, 4u)), u64vec3(317891438802ul, 0ul, 5ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) >> uvec3(19u, 1u, 13u)), u64vec3(2543131510416ul, 42ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> uvec3(22u, 23u, 4u)), u64vec3(0ul, 0ul, 11ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) >> uvec3(19u, 1u, 13u)), u64vec3(0ul, 33ul, 0ul))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
