/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec2(-10l, -12l) << ivec2(13, 26)) => i64vec2(-81920l, -805306368l)
 * (i64vec2(-10l, -12l) << ivec2(2, 26)) => i64vec2(-40l, -805306368l)
 * (i64vec2(-42l, 48l) << ivec2(13, 26)) => i64vec2(-344064l, 3221225472l)
 * (i64vec2(-42l, 48l) << ivec2(2, 26)) => i64vec2(-168l, 3221225472l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec2(-10l, -12l) << ivec2(13, 26)), i64vec2(-81920l, -805306368l))) ? 1 : -1] array0;
  float[all(equal((i64vec2(-10l, -12l) << ivec2(2, 26)), i64vec2(-40l, -805306368l))) ? 1 : -1] array1;
  float[all(equal((i64vec2(-42l, 48l) << ivec2(13, 26)), i64vec2(-344064l, 3221225472l))) ? 1 : -1] array2;
  float[all(equal((i64vec2(-42l, 48l) << ivec2(2, 26)), i64vec2(-168l, 3221225472l))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
