/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (3ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (1192ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(7ul, 8ul, 6ul, 15ul)
 * (1048576ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(6355ul, 7884ul, 5433ul, 13797ul)
 * (4251475ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(25766ul, 31965ul, 22028ul, 55940ul)
 * (29852643761ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(180925113ul, 224455968ul, 154676910ul, 392797944ul)
 * (4398046511104ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(26654827340ul, 33068018880ul, 22787805757ul, 57869033040ul)
 * (3948976685146ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(23933192031ul, 29691554023ul, 20461019094ul, 51960219541ul)
 * (135763469567146206ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(822808906467552ul, 1020777966670272ul, 703437666151016ul, 1786361441672976ul)
 * (11654173250180970009ul / u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(70631353031399818ul, 87625362783315563ul, 60384317358450621ul, 153344384870802236ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((3ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array1;
  float[all(equal((1192ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(7ul, 8ul, 6ul, 15ul))) ? 1 : -1] array2;
  float[all(equal((1048576ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(6355ul, 7884ul, 5433ul, 13797ul))) ? 1 : -1] array3;
  float[all(equal((4251475ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(25766ul, 31965ul, 22028ul, 55940ul))) ? 1 : -1] array4;
  float[all(equal((29852643761ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(180925113ul, 224455968ul, 154676910ul, 392797944ul))) ? 1 : -1] array5;
  float[all(equal((4398046511104ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(26654827340ul, 33068018880ul, 22787805757ul, 57869033040ul))) ? 1 : -1] array6;
  float[all(equal((3948976685146ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(23933192031ul, 29691554023ul, 20461019094ul, 51960219541ul))) ? 1 : -1] array7;
  float[all(equal((135763469567146206ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(822808906467552ul, 1020777966670272ul, 703437666151016ul, 1786361441672976ul))) ? 1 : -1] array8;
  float[all(equal((11654173250180970009ul / u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(70631353031399818ul, 87625362783315563ul, 60384317358450621ul, 153344384870802236ul))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
