/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.opensearch.knn.index.query.TopDocsDISI;

public class KNNScorer
extends Scorer {
    private final float boost;
    private final TopDocsDISI docIdsIter;

    public KNNScorer(TopDocs topDocs, float boost) {
        this.boost = boost;
        this.docIdsIter = new TopDocsDISI(topDocs);
    }

    public DocIdSetIterator iterator() {
        return this.docIdsIter;
    }

    public float getMaxScore(int upTo) {
        return Float.MAX_VALUE;
    }

    public float score() {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docIdsIter.score() * this.boost;
    }

    public int docID() {
        return this.docIdsIter.docID();
    }

    public static Scorer emptyScorer() {
        return new KNNScorer(TopDocsCollector.EMPTY_TOPDOCS, 0.0f);
    }
}

