/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import java.util.Objects;
import org.tribuo.Output;
import org.tribuo.common.tree.Node;
import org.tribuo.math.la.SparseVector;

public class SplitNode<T extends Output<T>>
implements Node<T> {
    private static final long serialVersionUID = 3L;
    private final Node<T> greaterThan;
    private final Node<T> lessThanOrEqual;
    private final int splitFeature;
    private final double splitValue;
    private final double impurity;

    public SplitNode(double splitValue, int featureID, double impurity, Node<T> greaterThan, Node<T> lessThanOrEqual) {
        this.splitValue = splitValue;
        this.splitFeature = featureID;
        this.impurity = impurity;
        this.greaterThan = greaterThan;
        this.lessThanOrEqual = lessThanOrEqual;
    }

    @Override
    public Node<T> getNextNode(SparseVector e) {
        double feature = e.get(this.splitFeature);
        if (feature > this.splitValue) {
            return this.greaterThan;
        }
        return this.lessThanOrEqual;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public double getImpurity() {
        return this.impurity;
    }

    @Override
    public Node<T> copy() {
        return new SplitNode<T>(this.splitValue, this.splitFeature, this.impurity, this.greaterThan.copy(), this.lessThanOrEqual.copy());
    }

    public int getFeatureID() {
        return this.splitFeature;
    }

    public double splitValue() {
        return this.splitValue;
    }

    public Node<T> getGreaterThan() {
        return this.greaterThan;
    }

    public Node<T> getLessThanOrEqual() {
        return this.lessThanOrEqual;
    }

    public String toString() {
        return "SplitNode(feature=" + this.splitFeature + ",value=" + this.splitValue + ",impurity=" + this.impurity + ",\n\t\tleft=" + this.lessThanOrEqual.toString() + ",\n\t\tright=" + this.greaterThan.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitNode splitNode = (SplitNode)o;
        return this.splitFeature == splitNode.splitFeature && Double.compare(splitNode.splitValue, this.splitValue) == 0 && Double.compare(splitNode.impurity, this.impurity) == 0 && this.greaterThan.equals(splitNode.greaterThan) && this.lessThanOrEqual.equals(splitNode.lessThanOrEqual);
    }

    public int hashCode() {
        return Objects.hash(this.greaterThan, this.lessThanOrEqual, this.splitFeature, this.splitValue, this.impurity);
    }
}

